/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The access configuration information for the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessConfigRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateAccessConfigRequest.Builder, CreateAccessConfigRequest> {
    private static final SdkField<Boolean> BOOTSTRAP_CLUSTER_CREATOR_ADMIN_PERMISSIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("bootstrapClusterCreatorAdminPermissions")
            .getter(getter(CreateAccessConfigRequest::bootstrapClusterCreatorAdminPermissions))
            .setter(setter(Builder::bootstrapClusterCreatorAdminPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("bootstrapClusterCreatorAdminPermissions").build()).build();

    private static final SdkField<String> AUTHENTICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationMode").getter(getter(CreateAccessConfigRequest::authenticationModeAsString))
            .setter(setter(Builder::authenticationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BOOTSTRAP_CLUSTER_CREATOR_ADMIN_PERMISSIONS_FIELD, AUTHENTICATION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean bootstrapClusterCreatorAdminPermissions;

    private final String authenticationMode;

    private CreateAccessConfigRequest(BuilderImpl builder) {
        this.bootstrapClusterCreatorAdminPermissions = builder.bootstrapClusterCreatorAdminPermissions;
        this.authenticationMode = builder.authenticationMode;
    }

    /**
     * <p>
     * Specifies whether or not the cluster creator IAM principal was set as a cluster admin access entry during cluster
     * creation time. The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies whether or not the cluster creator IAM principal was set as a cluster admin access entry during
     *         cluster creation time. The default value is <code>true</code>.
     */
    public final Boolean bootstrapClusterCreatorAdminPermissions() {
        return bootstrapClusterCreatorAdminPermissions;
    }

    /**
     * <p>
     * The desired authentication mode for the cluster. If you create a cluster by using the EKS API, Amazon Web
     * Services SDKs, or CloudFormation, the default is <code>CONFIG_MAP</code>. If you create the cluster by using the
     * Amazon Web Services Management Console, the default value is <code>API_AND_CONFIG_MAP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMode} will return {@link AuthenticationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationModeAsString}.
     * </p>
     * 
     * @return The desired authentication mode for the cluster. If you create a cluster by using the EKS API, Amazon Web
     *         Services SDKs, or CloudFormation, the default is <code>CONFIG_MAP</code>. If you create the cluster by
     *         using the Amazon Web Services Management Console, the default value is <code>API_AND_CONFIG_MAP</code>.
     * @see AuthenticationMode
     */
    public final AuthenticationMode authenticationMode() {
        return AuthenticationMode.fromValue(authenticationMode);
    }

    /**
     * <p>
     * The desired authentication mode for the cluster. If you create a cluster by using the EKS API, Amazon Web
     * Services SDKs, or CloudFormation, the default is <code>CONFIG_MAP</code>. If you create the cluster by using the
     * Amazon Web Services Management Console, the default value is <code>API_AND_CONFIG_MAP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMode} will return {@link AuthenticationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationModeAsString}.
     * </p>
     * 
     * @return The desired authentication mode for the cluster. If you create a cluster by using the EKS API, Amazon Web
     *         Services SDKs, or CloudFormation, the default is <code>CONFIG_MAP</code>. If you create the cluster by
     *         using the Amazon Web Services Management Console, the default value is <code>API_AND_CONFIG_MAP</code>.
     * @see AuthenticationMode
     */
    public final String authenticationModeAsString() {
        return authenticationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapClusterCreatorAdminPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessConfigRequest)) {
            return false;
        }
        CreateAccessConfigRequest other = (CreateAccessConfigRequest) obj;
        return Objects.equals(bootstrapClusterCreatorAdminPermissions(), other.bootstrapClusterCreatorAdminPermissions())
                && Objects.equals(authenticationModeAsString(), other.authenticationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessConfigRequest")
                .add("BootstrapClusterCreatorAdminPermissions", bootstrapClusterCreatorAdminPermissions())
                .add("AuthenticationMode", authenticationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bootstrapClusterCreatorAdminPermissions":
            return Optional.ofNullable(clazz.cast(bootstrapClusterCreatorAdminPermissions()));
        case "authenticationMode":
            return Optional.ofNullable(clazz.cast(authenticationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessConfigRequest, T> g) {
        return obj -> g.apply((CreateAccessConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateAccessConfigRequest> {
        /**
         * <p>
         * Specifies whether or not the cluster creator IAM principal was set as a cluster admin access entry during
         * cluster creation time. The default value is <code>true</code>.
         * </p>
         * 
         * @param bootstrapClusterCreatorAdminPermissions
         *        Specifies whether or not the cluster creator IAM principal was set as a cluster admin access entry
         *        during cluster creation time. The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapClusterCreatorAdminPermissions(Boolean bootstrapClusterCreatorAdminPermissions);

        /**
         * <p>
         * The desired authentication mode for the cluster. If you create a cluster by using the EKS API, Amazon Web
         * Services SDKs, or CloudFormation, the default is <code>CONFIG_MAP</code>. If you create the cluster by using
         * the Amazon Web Services Management Console, the default value is <code>API_AND_CONFIG_MAP</code>.
         * </p>
         * 
         * @param authenticationMode
         *        The desired authentication mode for the cluster. If you create a cluster by using the EKS API, Amazon
         *        Web Services SDKs, or CloudFormation, the default is <code>CONFIG_MAP</code>. If you create the
         *        cluster by using the Amazon Web Services Management Console, the default value is
         *        <code>API_AND_CONFIG_MAP</code>.
         * @see AuthenticationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMode
         */
        Builder authenticationMode(String authenticationMode);

        /**
         * <p>
         * The desired authentication mode for the cluster. If you create a cluster by using the EKS API, Amazon Web
         * Services SDKs, or CloudFormation, the default is <code>CONFIG_MAP</code>. If you create the cluster by using
         * the Amazon Web Services Management Console, the default value is <code>API_AND_CONFIG_MAP</code>.
         * </p>
         * 
         * @param authenticationMode
         *        The desired authentication mode for the cluster. If you create a cluster by using the EKS API, Amazon
         *        Web Services SDKs, or CloudFormation, the default is <code>CONFIG_MAP</code>. If you create the
         *        cluster by using the Amazon Web Services Management Console, the default value is
         *        <code>API_AND_CONFIG_MAP</code>.
         * @see AuthenticationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMode
         */
        Builder authenticationMode(AuthenticationMode authenticationMode);
    }

    static final class BuilderImpl implements Builder {
        private Boolean bootstrapClusterCreatorAdminPermissions;

        private String authenticationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessConfigRequest model) {
            bootstrapClusterCreatorAdminPermissions(model.bootstrapClusterCreatorAdminPermissions);
            authenticationMode(model.authenticationMode);
        }

        public final Boolean getBootstrapClusterCreatorAdminPermissions() {
            return bootstrapClusterCreatorAdminPermissions;
        }

        public final void setBootstrapClusterCreatorAdminPermissions(Boolean bootstrapClusterCreatorAdminPermissions) {
            this.bootstrapClusterCreatorAdminPermissions = bootstrapClusterCreatorAdminPermissions;
        }

        @Override
        public final Builder bootstrapClusterCreatorAdminPermissions(Boolean bootstrapClusterCreatorAdminPermissions) {
            this.bootstrapClusterCreatorAdminPermissions = bootstrapClusterCreatorAdminPermissions;
            return this;
        }

        public final String getAuthenticationMode() {
            return authenticationMode;
        }

        public final void setAuthenticationMode(String authenticationMode) {
            this.authenticationMode = authenticationMode;
        }

        @Override
        public final Builder authenticationMode(String authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        @Override
        public final Builder authenticationMode(AuthenticationMode authenticationMode) {
            this.authenticationMode(authenticationMode == null ? null : authenticationMode.toString());
            return this;
        }

        @Override
        public CreateAccessConfigRequest build() {
            return new CreateAccessConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
