/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImagePipelineRequest extends ImagebuilderRequest implements
        ToCopyableBuilder<CreateImagePipelineRequest.Builder, CreateImagePipelineRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateImagePipelineRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateImagePipelineRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageRecipeArn").getter(getter(CreateImagePipelineRequest::imageRecipeArn))
            .setter(setter(Builder::imageRecipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()).build();

    private static final SdkField<String> CONTAINER_RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerRecipeArn").getter(getter(CreateImagePipelineRequest::containerRecipeArn))
            .setter(setter(Builder::containerRecipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipeArn").build())
            .build();

    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("infrastructureConfigurationArn")
            .getter(getter(CreateImagePipelineRequest::infrastructureConfigurationArn))
            .setter(setter(Builder::infrastructureConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn")
                    .build()).build();

    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("distributionConfigurationArn")
            .getter(getter(CreateImagePipelineRequest::distributionConfigurationArn))
            .setter(setter(Builder::distributionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn")
                    .build()).build();

    private static final SdkField<ImageTestsConfiguration> IMAGE_TESTS_CONFIGURATION_FIELD = SdkField
            .<ImageTestsConfiguration> builder(MarshallingType.SDK_POJO).memberName("imageTestsConfiguration")
            .getter(getter(CreateImagePipelineRequest::imageTestsConfiguration)).setter(setter(Builder::imageTestsConfiguration))
            .constructor(ImageTestsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsConfiguration").build())
            .build();

    private static final SdkField<Boolean> ENHANCED_IMAGE_METADATA_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enhancedImageMetadataEnabled")
            .getter(getter(CreateImagePipelineRequest::enhancedImageMetadataEnabled))
            .setter(setter(Builder::enhancedImageMetadataEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedImageMetadataEnabled")
                    .build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(CreateImagePipelineRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateImagePipelineRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateImagePipelineRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateImagePipelineRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField
            .<ImageScanningConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("imageScanningConfiguration")
            .getter(getter(CreateImagePipelineRequest::imageScanningConfiguration))
            .setter(setter(Builder::imageScanningConfiguration))
            .constructor(ImageScanningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build())
            .build();

    private static final SdkField<List<WorkflowConfiguration>> WORKFLOWS_FIELD = SdkField
            .<List<WorkflowConfiguration>> builder(MarshallingType.LIST)
            .memberName("workflows")
            .getter(getter(CreateImagePipelineRequest::workflows))
            .setter(setter(Builder::workflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(CreateImagePipelineRequest::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            IMAGE_RECIPE_ARN_FIELD, CONTAINER_RECIPE_ARN_FIELD, INFRASTRUCTURE_CONFIGURATION_ARN_FIELD,
            DISTRIBUTION_CONFIGURATION_ARN_FIELD, IMAGE_TESTS_CONFIGURATION_FIELD, ENHANCED_IMAGE_METADATA_ENABLED_FIELD,
            SCHEDULE_FIELD, STATUS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD, WORKFLOWS_FIELD,
            EXECUTION_ROLE_FIELD));

    private final String name;

    private final String description;

    private final String imageRecipeArn;

    private final String containerRecipeArn;

    private final String infrastructureConfigurationArn;

    private final String distributionConfigurationArn;

    private final ImageTestsConfiguration imageTestsConfiguration;

    private final Boolean enhancedImageMetadataEnabled;

    private final Schedule schedule;

    private final String status;

    private final Map<String, String> tags;

    private final String clientToken;

    private final ImageScanningConfiguration imageScanningConfiguration;

    private final List<WorkflowConfiguration> workflows;

    private final String executionRole;

    private CreateImagePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.imageRecipeArn = builder.imageRecipeArn;
        this.containerRecipeArn = builder.containerRecipeArn;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.imageTestsConfiguration = builder.imageTestsConfiguration;
        this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
        this.workflows = builder.workflows;
        this.executionRole = builder.executionRole;
    }

    /**
     * <p>
     * The name of the image pipeline.
     * </p>
     * 
     * @return The name of the image pipeline.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the image pipeline.
     * </p>
     * 
     * @return The description of the image pipeline.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image
     * pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this
     *         image pipeline.
     */
    public final String imageRecipeArn() {
        return imageRecipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container
     * pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this
     *         container pipeline.
     */
    public final String containerRecipeArn() {
        return containerRecipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by
     * this image pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images
     *         created by this image pipeline.
     */
    public final String infrastructureConfigurationArn() {
        return infrastructureConfigurationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute
     * images created by this image pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and
     *         distribute images created by this image pipeline.
     */
    public final String distributionConfigurationArn() {
        return distributionConfigurationArn;
    }

    /**
     * <p>
     * The image test configuration of the image pipeline.
     * </p>
     * 
     * @return The image test configuration of the image pipeline.
     */
    public final ImageTestsConfiguration imageTestsConfiguration() {
        return imageTestsConfiguration;
    }

    /**
     * <p>
     * Collects additional information about the image being created, including the operating system (OS) version and
     * package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by
     * default.
     * </p>
     * 
     * @return Collects additional information about the image being created, including the operating system (OS)
     *         version and package list. This information is used to enhance the overall experience of using EC2 Image
     *         Builder. Enabled by default.
     */
    public final Boolean enhancedImageMetadataEnabled() {
        return enhancedImageMetadataEnabled;
    }

    /**
     * <p>
     * The schedule of the image pipeline.
     * </p>
     * 
     * @return The schedule of the image pipeline.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The status of the image pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the image pipeline.
     * @see PipelineStatus
     */
    public final PipelineStatus status() {
        return PipelineStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the image pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the image pipeline.
     * @see PipelineStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the image pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the image pipeline.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Contains settings for vulnerability scans.
     * </p>
     * 
     * @return Contains settings for vulnerability scans.
     */
    public final ImageScanningConfiguration imageScanningConfiguration() {
        return imageScanningConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workflows property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkflows() {
        return workflows != null && !(workflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains an array of workflow configuration objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflows} method.
     * </p>
     * 
     * @return Contains an array of workflow configuration objects.
     */
    public final List<WorkflowConfiguration> workflows() {
        return workflows;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to perform
     * workflow actions.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
     *         perform workflow actions.
     */
    public final String executionRole() {
        return executionRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(containerRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageTestsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedImageMetadataEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(imageScanningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflows() ? workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImagePipelineRequest)) {
            return false;
        }
        CreateImagePipelineRequest other = (CreateImagePipelineRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(imageRecipeArn(), other.imageRecipeArn())
                && Objects.equals(containerRecipeArn(), other.containerRecipeArn())
                && Objects.equals(infrastructureConfigurationArn(), other.infrastructureConfigurationArn())
                && Objects.equals(distributionConfigurationArn(), other.distributionConfigurationArn())
                && Objects.equals(imageTestsConfiguration(), other.imageTestsConfiguration())
                && Objects.equals(enhancedImageMetadataEnabled(), other.enhancedImageMetadataEnabled())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(imageScanningConfiguration(), other.imageScanningConfiguration())
                && hasWorkflows() == other.hasWorkflows() && Objects.equals(workflows(), other.workflows())
                && Objects.equals(executionRole(), other.executionRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateImagePipelineRequest").add("Name", name()).add("Description", description())
                .add("ImageRecipeArn", imageRecipeArn()).add("ContainerRecipeArn", containerRecipeArn())
                .add("InfrastructureConfigurationArn", infrastructureConfigurationArn())
                .add("DistributionConfigurationArn", distributionConfigurationArn())
                .add("ImageTestsConfiguration", imageTestsConfiguration())
                .add("EnhancedImageMetadataEnabled", enhancedImageMetadataEnabled()).add("Schedule", schedule())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken())
                .add("ImageScanningConfiguration", imageScanningConfiguration())
                .add("Workflows", hasWorkflows() ? workflows() : null).add("ExecutionRole", executionRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "imageRecipeArn":
            return Optional.ofNullable(clazz.cast(imageRecipeArn()));
        case "containerRecipeArn":
            return Optional.ofNullable(clazz.cast(containerRecipeArn()));
        case "infrastructureConfigurationArn":
            return Optional.ofNullable(clazz.cast(infrastructureConfigurationArn()));
        case "distributionConfigurationArn":
            return Optional.ofNullable(clazz.cast(distributionConfigurationArn()));
        case "imageTestsConfiguration":
            return Optional.ofNullable(clazz.cast(imageTestsConfiguration()));
        case "enhancedImageMetadataEnabled":
            return Optional.ofNullable(clazz.cast(enhancedImageMetadataEnabled()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "imageScanningConfiguration":
            return Optional.ofNullable(clazz.cast(imageScanningConfiguration()));
        case "workflows":
            return Optional.ofNullable(clazz.cast(workflows()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImagePipelineRequest, T> g) {
        return obj -> g.apply((CreateImagePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ImagebuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateImagePipelineRequest> {
        /**
         * <p>
         * The name of the image pipeline.
         * </p>
         * 
         * @param name
         *        The name of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the image pipeline.
         * </p>
         * 
         * @param description
         *        The description of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this
         * image pipeline.
         * </p>
         * 
         * @param imageRecipeArn
         *        The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by
         *        this image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageRecipeArn(String imageRecipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this
         * container pipeline.
         * </p>
         * 
         * @param containerRecipeArn
         *        The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by
         *        this container pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRecipeArn(String containerRecipeArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created
         * by this image pipeline.
         * </p>
         * 
         * @param infrastructureConfigurationArn
         *        The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images
         *        created by this image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureConfigurationArn(String infrastructureConfigurationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and
         * distribute images created by this image pipeline.
         * </p>
         * 
         * @param distributionConfigurationArn
         *        The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and
         *        distribute images created by this image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfigurationArn(String distributionConfigurationArn);

        /**
         * <p>
         * The image test configuration of the image pipeline.
         * </p>
         * 
         * @param imageTestsConfiguration
         *        The image test configuration of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration);

        /**
         * <p>
         * The image test configuration of the image pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageTestsConfiguration.Builder} avoiding
         * the need to create one manually via {@link ImageTestsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageTestsConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageTestsConfiguration(ImageTestsConfiguration)}.
         * 
         * @param imageTestsConfiguration
         *        a consumer that will call methods on {@link ImageTestsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageTestsConfiguration(ImageTestsConfiguration)
         */
        default Builder imageTestsConfiguration(Consumer<ImageTestsConfiguration.Builder> imageTestsConfiguration) {
            return imageTestsConfiguration(ImageTestsConfiguration.builder().applyMutation(imageTestsConfiguration).build());
        }

        /**
         * <p>
         * Collects additional information about the image being created, including the operating system (OS) version
         * and package list. This information is used to enhance the overall experience of using EC2 Image Builder.
         * Enabled by default.
         * </p>
         * 
         * @param enhancedImageMetadataEnabled
         *        Collects additional information about the image being created, including the operating system (OS)
         *        version and package list. This information is used to enhance the overall experience of using EC2
         *        Image Builder. Enabled by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled);

        /**
         * <p>
         * The schedule of the image pipeline.
         * </p>
         * 
         * @param schedule
         *        The schedule of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule of the image pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The status of the image pipeline.
         * </p>
         * 
         * @param status
         *        The status of the image pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the image pipeline.
         * </p>
         * 
         * @param status
         *        The status of the image pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder status(PipelineStatus status);

        /**
         * <p>
         * The tags of the image pipeline.
         * </p>
         * 
         * @param tags
         *        The tags of the image pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Contains settings for vulnerability scans.
         * </p>
         * 
         * @param imageScanningConfiguration
         *        Contains settings for vulnerability scans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration);

        /**
         * <p>
         * Contains settings for vulnerability scans.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageScanningConfiguration.Builder}
         * avoiding the need to create one manually via {@link ImageScanningConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageScanningConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageScanningConfiguration(ImageScanningConfiguration)}.
         * 
         * @param imageScanningConfiguration
         *        a consumer that will call methods on {@link ImageScanningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageScanningConfiguration(ImageScanningConfiguration)
         */
        default Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return imageScanningConfiguration(ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)
                    .build());
        }

        /**
         * <p>
         * Contains an array of workflow configuration objects.
         * </p>
         * 
         * @param workflows
         *        Contains an array of workflow configuration objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Collection<WorkflowConfiguration> workflows);

        /**
         * <p>
         * Contains an array of workflow configuration objects.
         * </p>
         * 
         * @param workflows
         *        Contains an array of workflow configuration objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(WorkflowConfiguration... workflows);

        /**
         * <p>
         * Contains an array of workflow configuration objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #workflows(List<WorkflowConfiguration>)}.
         * 
         * @param workflows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflows(java.util.Collection<WorkflowConfiguration>)
         */
        Builder workflows(Consumer<WorkflowConfiguration.Builder>... workflows);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
         * perform workflow actions.
         * </p>
         * 
         * @param executionRole
         *        The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to
         *        perform workflow actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ImagebuilderRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String imageRecipeArn;

        private String containerRecipeArn;

        private String infrastructureConfigurationArn;

        private String distributionConfigurationArn;

        private ImageTestsConfiguration imageTestsConfiguration;

        private Boolean enhancedImageMetadataEnabled;

        private Schedule schedule;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private ImageScanningConfiguration imageScanningConfiguration;

        private List<WorkflowConfiguration> workflows = DefaultSdkAutoConstructList.getInstance();

        private String executionRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImagePipelineRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            imageRecipeArn(model.imageRecipeArn);
            containerRecipeArn(model.containerRecipeArn);
            infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            distributionConfigurationArn(model.distributionConfigurationArn);
            imageTestsConfiguration(model.imageTestsConfiguration);
            enhancedImageMetadataEnabled(model.enhancedImageMetadataEnabled);
            schedule(model.schedule);
            status(model.status);
            tags(model.tags);
            clientToken(model.clientToken);
            imageScanningConfiguration(model.imageScanningConfiguration);
            workflows(model.workflows);
            executionRole(model.executionRole);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getImageRecipeArn() {
            return imageRecipeArn;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final String getContainerRecipeArn() {
            return containerRecipeArn;
        }

        public final void setContainerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
        }

        @Override
        public final Builder containerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final String getDistributionConfigurationArn() {
            return distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final ImageTestsConfiguration.Builder getImageTestsConfiguration() {
            return imageTestsConfiguration != null ? imageTestsConfiguration.toBuilder() : null;
        }

        public final void setImageTestsConfiguration(ImageTestsConfiguration.BuilderImpl imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration != null ? imageTestsConfiguration.build() : null;
        }

        @Override
        public final Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        public final Boolean getEnhancedImageMetadataEnabled() {
            return enhancedImageMetadataEnabled;
        }

        public final void setEnhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
        }

        @Override
        public final Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return imageScanningConfiguration != null ? imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        public final List<WorkflowConfiguration.Builder> getWorkflows() {
            List<WorkflowConfiguration.Builder> result = WorkflowConfigurationListCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<WorkflowConfiguration.BuilderImpl> workflows) {
            this.workflows = WorkflowConfigurationListCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<WorkflowConfiguration> workflows) {
            this.workflows = WorkflowConfigurationListCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(WorkflowConfiguration... workflows) {
            workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<WorkflowConfiguration.Builder>... workflows) {
            workflows(Stream.of(workflows).map(c -> WorkflowConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImagePipelineRequest build() {
            return new CreateImagePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
