/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.OnWorkflowFailure;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowParameter;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowParameterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowConfiguration> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowArn").getter(WorkflowConfiguration.getter(WorkflowConfiguration::workflowArn)).setter(WorkflowConfiguration.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowArn").build()}).build();
    private static final SdkField<List<WorkflowParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(WorkflowConfiguration.getter(WorkflowConfiguration::parameters)).setter(WorkflowConfiguration.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PARALLEL_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parallelGroup").getter(WorkflowConfiguration.getter(WorkflowConfiguration::parallelGroup)).setter(WorkflowConfiguration.setter(Builder::parallelGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelGroup").build()}).build();
    private static final SdkField<String> ON_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onFailure").getter(WorkflowConfiguration.getter(WorkflowConfiguration::onFailureAsString)).setter(WorkflowConfiguration.setter(Builder::onFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onFailure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD, PARAMETERS_FIELD, PARALLEL_GROUP_FIELD, ON_FAILURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String workflowArn;
    private final List<WorkflowParameter> parameters;
    private final String parallelGroup;
    private final String onFailure;

    private WorkflowConfiguration(BuilderImpl builder) {
        this.workflowArn = builder.workflowArn;
        this.parameters = builder.parameters;
        this.parallelGroup = builder.parallelGroup;
        this.onFailure = builder.onFailure;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<WorkflowParameter> parameters() {
        return this.parameters;
    }

    public final String parallelGroup() {
        return this.parallelGroup;
    }

    public final OnWorkflowFailure onFailure() {
        return OnWorkflowFailure.fromValue(this.onFailure);
    }

    public final String onFailureAsString() {
        return this.onFailure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.onFailureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowConfiguration)) {
            return false;
        }
        WorkflowConfiguration other = (WorkflowConfiguration)obj;
        return Objects.equals(this.workflowArn(), other.workflowArn()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.parallelGroup(), other.parallelGroup()) && Objects.equals(this.onFailureAsString(), other.onFailureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowConfiguration").add("WorkflowArn", (Object)this.workflowArn()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ParallelGroup", (Object)this.parallelGroup()).add("OnFailure", (Object)this.onFailureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "parallelGroup": {
                return Optional.ofNullable(clazz.cast(this.parallelGroup()));
            }
            case "onFailure": {
                return Optional.ofNullable(clazz.cast(this.onFailureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowConfiguration, T> g) {
        return obj -> g.apply((WorkflowConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workflowArn;
        private List<WorkflowParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private String parallelGroup;
        private String onFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowConfiguration model) {
            this.workflowArn(model.workflowArn);
            this.parameters(model.parameters);
            this.parallelGroup(model.parallelGroup);
            this.onFailure(model.onFailure);
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final List<WorkflowParameter.Builder> getParameters() {
            List<WorkflowParameter.Builder> result = WorkflowParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<WorkflowParameter.BuilderImpl> parameters) {
            this.parameters = WorkflowParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<WorkflowParameter> parameters) {
            this.parameters = WorkflowParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(WorkflowParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<WorkflowParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (WorkflowParameter)((WorkflowParameter.Builder)WorkflowParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getParallelGroup() {
            return this.parallelGroup;
        }

        public final void setParallelGroup(String parallelGroup) {
            this.parallelGroup = parallelGroup;
        }

        @Override
        public final Builder parallelGroup(String parallelGroup) {
            this.parallelGroup = parallelGroup;
            return this;
        }

        public final String getOnFailure() {
            return this.onFailure;
        }

        public final void setOnFailure(String onFailure) {
            this.onFailure = onFailure;
        }

        @Override
        public final Builder onFailure(String onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        @Override
        public final Builder onFailure(OnWorkflowFailure onFailure) {
            this.onFailure(onFailure == null ? null : onFailure.toString());
            return this;
        }

        public WorkflowConfiguration build() {
            return new WorkflowConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowConfiguration> {
        public Builder workflowArn(String var1);

        public Builder parameters(Collection<WorkflowParameter> var1);

        public Builder parameters(WorkflowParameter ... var1);

        public Builder parameters(Consumer<WorkflowParameter.Builder> ... var1);

        public Builder parallelGroup(String var1);

        public Builder onFailure(String var1);

        public Builder onFailure(OnWorkflowFailure var1);
    }
}

