/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The firewall policy defines the behavior of a firewall using a collection of stateless and stateful rule groups and
 * other settings. You can use one firewall policy for multiple firewalls.
 * </p>
 * <p>
 * This, along with <a>FirewallPolicyResponse</a>, define the policy. You can retrieve all objects for a firewall policy
 * by calling <a>DescribeFirewallPolicy</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallPolicy implements SdkPojo, Serializable, ToCopyableBuilder<FirewallPolicy.Builder, FirewallPolicy> {
    private static final SdkField<List<StatelessRuleGroupReference>> STATELESS_RULE_GROUP_REFERENCES_FIELD = SdkField
            .<List<StatelessRuleGroupReference>> builder(MarshallingType.LIST)
            .memberName("StatelessRuleGroupReferences")
            .getter(getter(FirewallPolicy::statelessRuleGroupReferences))
            .setter(setter(Builder::statelessRuleGroupReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRuleGroupReferences")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatelessRuleGroupReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatelessRuleGroupReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATELESS_DEFAULT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatelessDefaultActions")
            .getter(getter(FirewallPolicy::statelessDefaultActions))
            .setter(setter(Builder::statelessDefaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessDefaultActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatelessFragmentDefaultActions")
            .getter(getter(FirewallPolicy::statelessFragmentDefaultActions))
            .setter(setter(Builder::statelessFragmentDefaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessFragmentDefaultActions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CustomAction>> STATELESS_CUSTOM_ACTIONS_FIELD = SdkField
            .<List<CustomAction>> builder(MarshallingType.LIST)
            .memberName("StatelessCustomActions")
            .getter(getter(FirewallPolicy::statelessCustomActions))
            .setter(setter(Builder::statelessCustomActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessCustomActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StatefulRuleGroupReference>> STATEFUL_RULE_GROUP_REFERENCES_FIELD = SdkField
            .<List<StatefulRuleGroupReference>> builder(MarshallingType.LIST)
            .memberName("StatefulRuleGroupReferences")
            .getter(getter(FirewallPolicy::statefulRuleGroupReferences))
            .setter(setter(Builder::statefulRuleGroupReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRuleGroupReferences")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatefulRuleGroupReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatefulRuleGroupReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATEFUL_DEFAULT_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StatefulDefaultActions")
            .getter(getter(FirewallPolicy::statefulDefaultActions))
            .setter(setter(Builder::statefulDefaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulDefaultActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StatefulEngineOptions> STATEFUL_ENGINE_OPTIONS_FIELD = SdkField
            .<StatefulEngineOptions> builder(MarshallingType.SDK_POJO).memberName("StatefulEngineOptions")
            .getter(getter(FirewallPolicy::statefulEngineOptions)).setter(setter(Builder::statefulEngineOptions))
            .constructor(StatefulEngineOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulEngineOptions").build())
            .build();

    private static final SdkField<String> TLS_INSPECTION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TLSInspectionConfigurationArn")
            .getter(getter(FirewallPolicy::tlsInspectionConfigurationArn))
            .setter(setter(Builder::tlsInspectionConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSInspectionConfigurationArn")
                    .build()).build();

    private static final SdkField<PolicyVariables> POLICY_VARIABLES_FIELD = SdkField
            .<PolicyVariables> builder(MarshallingType.SDK_POJO).memberName("PolicyVariables")
            .getter(getter(FirewallPolicy::policyVariables)).setter(setter(Builder::policyVariables))
            .constructor(PolicyVariables::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVariables").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STATELESS_RULE_GROUP_REFERENCES_FIELD, STATELESS_DEFAULT_ACTIONS_FIELD, STATELESS_FRAGMENT_DEFAULT_ACTIONS_FIELD,
            STATELESS_CUSTOM_ACTIONS_FIELD, STATEFUL_RULE_GROUP_REFERENCES_FIELD, STATEFUL_DEFAULT_ACTIONS_FIELD,
            STATEFUL_ENGINE_OPTIONS_FIELD, TLS_INSPECTION_CONFIGURATION_ARN_FIELD, POLICY_VARIABLES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StatelessRuleGroupReference> statelessRuleGroupReferences;

    private final List<String> statelessDefaultActions;

    private final List<String> statelessFragmentDefaultActions;

    private final List<CustomAction> statelessCustomActions;

    private final List<StatefulRuleGroupReference> statefulRuleGroupReferences;

    private final List<String> statefulDefaultActions;

    private final StatefulEngineOptions statefulEngineOptions;

    private final String tlsInspectionConfigurationArn;

    private final PolicyVariables policyVariables;

    private FirewallPolicy(BuilderImpl builder) {
        this.statelessRuleGroupReferences = builder.statelessRuleGroupReferences;
        this.statelessDefaultActions = builder.statelessDefaultActions;
        this.statelessFragmentDefaultActions = builder.statelessFragmentDefaultActions;
        this.statelessCustomActions = builder.statelessCustomActions;
        this.statefulRuleGroupReferences = builder.statefulRuleGroupReferences;
        this.statefulDefaultActions = builder.statefulDefaultActions;
        this.statefulEngineOptions = builder.statefulEngineOptions;
        this.tlsInspectionConfigurationArn = builder.tlsInspectionConfigurationArn;
        this.policyVariables = builder.policyVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessRuleGroupReferences property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatelessRuleGroupReferences() {
        return statelessRuleGroupReferences != null && !(statelessRuleGroupReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * References to the stateless rule groups that are used in the policy. These define the matching criteria in
     * stateless rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessRuleGroupReferences} method.
     * </p>
     * 
     * @return References to the stateless rule groups that are used in the policy. These define the matching criteria
     *         in stateless rules.
     */
    public final List<StatelessRuleGroupReference> statelessRuleGroupReferences() {
        return statelessRuleGroupReferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessDefaultActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatelessDefaultActions() {
        return statelessDefaultActions != null && !(statelessDefaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want
     * non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>.
     * </p>
     * <p>
     * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
     * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
     * standard section choice.
     * </p>
     * <p>
     * For example, you could specify <code>["aws:pass"]</code> or you could specify
     * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
     * descriptions under <a>CustomAction</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessDefaultActions} method.
     * </p>
     * 
     * @return The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want
     *         non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>.
     *         </p>
     *         <p>
     *         You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
     *         <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
     *         your standard section choice.
     *         </p>
     *         <p>
     *         For example, you could specify <code>["aws:pass"]</code> or you could specify
     *         <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
     *         descriptions under <a>CustomAction</a>.
     */
    public final List<String> statelessDefaultActions() {
        return statelessDefaultActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessFragmentDefaultActions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasStatelessFragmentDefaultActions() {
        return statelessFragmentDefaultActions != null && !(statelessFragmentDefaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy.
     * Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols. If
     * you want non-matching fragmented UDP packets to be forwarded for stateful inspection, specify
     * <code>aws:forward_to_sfe</code>.
     * </p>
     * <p>
     * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
     * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
     * standard section choice.
     * </p>
     * <p>
     * For example, you could specify <code>["aws:pass"]</code> or you could specify
     * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
     * descriptions under <a>CustomAction</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessFragmentDefaultActions}
     * method.
     * </p>
     * 
     * @return The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the
     *         policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for other
     *         protocols. If you want non-matching fragmented UDP packets to be forwarded for stateful inspection,
     *         specify <code>aws:forward_to_sfe</code>. </p>
     *         <p>
     *         You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
     *         <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
     *         your standard section choice.
     *         </p>
     *         <p>
     *         For example, you could specify <code>["aws:pass"]</code> or you could specify
     *         <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
     *         descriptions under <a>CustomAction</a>.
     */
    public final List<String> statelessFragmentDefaultActions() {
        return statelessFragmentDefaultActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatelessCustomActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatelessCustomActions() {
        return statelessCustomActions != null && !(statelessCustomActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom action definitions that are available for use in the firewall policy's
     * <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you can use
     * it by name in your default actions specifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatelessCustomActions} method.
     * </p>
     * 
     * @return The custom action definitions that are available for use in the firewall policy's
     *         <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you
     *         can use it by name in your default actions specifications.
     */
    public final List<CustomAction> statelessCustomActions() {
        return statelessCustomActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatefulRuleGroupReferences property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatefulRuleGroupReferences() {
        return statefulRuleGroupReferences != null && !(statefulRuleGroupReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * References to the stateful rule groups that are used in the policy. These define the inspection criteria in
     * stateful rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatefulRuleGroupReferences} method.
     * </p>
     * 
     * @return References to the stateful rule groups that are used in the policy. These define the inspection criteria
     *         in stateful rules.
     */
    public final List<StatefulRuleGroupReference> statefulRuleGroupReferences() {
        return statefulRuleGroupReferences;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatefulDefaultActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatefulDefaultActions() {
        return statefulDefaultActions != null && !(statefulDefaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The default actions to take on a packet that doesn't match any stateful rules. The stateful default action is
     * optional, and is only valid when using the strict rule order.
     * </p>
     * <p>
     * Valid values of the stateful default action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * aws:drop_strict
     * </p>
     * </li>
     * <li>
     * <p>
     * aws:drop_established
     * </p>
     * </li>
     * <li>
     * <p>
     * aws:alert_strict
     * </p>
     * </li>
     * <li>
     * <p>
     * aws:alert_established
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html"
     * >Strict evaluation order</a> in the <i>Network Firewall Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatefulDefaultActions} method.
     * </p>
     * 
     * @return The default actions to take on a packet that doesn't match any stateful rules. The stateful default
     *         action is optional, and is only valid when using the strict rule order.</p>
     *         <p>
     *         Valid values of the stateful default action:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         aws:drop_strict
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         aws:drop_established
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         aws:alert_strict
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         aws:alert_established
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html"
     *         >Strict evaluation order</a> in the <i>Network Firewall Developer Guide</i>.
     */
    public final List<String> statefulDefaultActions() {
        return statefulDefaultActions;
    }

    /**
     * <p>
     * Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you use
     * in your policy must have stateful rule options settings that are compatible with these settings.
     * </p>
     * 
     * @return Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that
     *         you use in your policy must have stateful rule options settings that are compatible with these settings.
     */
    public final StatefulEngineOptions statefulEngineOptions() {
        return statefulEngineOptions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the TLS inspection configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the TLS inspection configuration.
     */
    public final String tlsInspectionConfigurationArn() {
        return tlsInspectionConfigurationArn;
    }

    /**
     * <p>
     * Contains variables that you can use to override default Suricata settings in your firewall policy.
     * </p>
     * 
     * @return Contains variables that you can use to override default Suricata settings in your firewall policy.
     */
    public final PolicyVariables policyVariables() {
        return policyVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessRuleGroupReferences() ? statelessRuleGroupReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessDefaultActions() ? statelessDefaultActions() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasStatelessFragmentDefaultActions() ? statelessFragmentDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatelessCustomActions() ? statelessCustomActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatefulRuleGroupReferences() ? statefulRuleGroupReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatefulDefaultActions() ? statefulDefaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statefulEngineOptions());
        hashCode = 31 * hashCode + Objects.hashCode(tlsInspectionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyVariables());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallPolicy)) {
            return false;
        }
        FirewallPolicy other = (FirewallPolicy) obj;
        return hasStatelessRuleGroupReferences() == other.hasStatelessRuleGroupReferences()
                && Objects.equals(statelessRuleGroupReferences(), other.statelessRuleGroupReferences())
                && hasStatelessDefaultActions() == other.hasStatelessDefaultActions()
                && Objects.equals(statelessDefaultActions(), other.statelessDefaultActions())
                && hasStatelessFragmentDefaultActions() == other.hasStatelessFragmentDefaultActions()
                && Objects.equals(statelessFragmentDefaultActions(), other.statelessFragmentDefaultActions())
                && hasStatelessCustomActions() == other.hasStatelessCustomActions()
                && Objects.equals(statelessCustomActions(), other.statelessCustomActions())
                && hasStatefulRuleGroupReferences() == other.hasStatefulRuleGroupReferences()
                && Objects.equals(statefulRuleGroupReferences(), other.statefulRuleGroupReferences())
                && hasStatefulDefaultActions() == other.hasStatefulDefaultActions()
                && Objects.equals(statefulDefaultActions(), other.statefulDefaultActions())
                && Objects.equals(statefulEngineOptions(), other.statefulEngineOptions())
                && Objects.equals(tlsInspectionConfigurationArn(), other.tlsInspectionConfigurationArn())
                && Objects.equals(policyVariables(), other.policyVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("FirewallPolicy")
                .add("StatelessRuleGroupReferences", hasStatelessRuleGroupReferences() ? statelessRuleGroupReferences() : null)
                .add("StatelessDefaultActions", hasStatelessDefaultActions() ? statelessDefaultActions() : null)
                .add("StatelessFragmentDefaultActions",
                        hasStatelessFragmentDefaultActions() ? statelessFragmentDefaultActions() : null)
                .add("StatelessCustomActions", hasStatelessCustomActions() ? statelessCustomActions() : null)
                .add("StatefulRuleGroupReferences", hasStatefulRuleGroupReferences() ? statefulRuleGroupReferences() : null)
                .add("StatefulDefaultActions", hasStatefulDefaultActions() ? statefulDefaultActions() : null)
                .add("StatefulEngineOptions", statefulEngineOptions())
                .add("TLSInspectionConfigurationArn", tlsInspectionConfigurationArn()).add("PolicyVariables", policyVariables())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatelessRuleGroupReferences":
            return Optional.ofNullable(clazz.cast(statelessRuleGroupReferences()));
        case "StatelessDefaultActions":
            return Optional.ofNullable(clazz.cast(statelessDefaultActions()));
        case "StatelessFragmentDefaultActions":
            return Optional.ofNullable(clazz.cast(statelessFragmentDefaultActions()));
        case "StatelessCustomActions":
            return Optional.ofNullable(clazz.cast(statelessCustomActions()));
        case "StatefulRuleGroupReferences":
            return Optional.ofNullable(clazz.cast(statefulRuleGroupReferences()));
        case "StatefulDefaultActions":
            return Optional.ofNullable(clazz.cast(statefulDefaultActions()));
        case "StatefulEngineOptions":
            return Optional.ofNullable(clazz.cast(statefulEngineOptions()));
        case "TLSInspectionConfigurationArn":
            return Optional.ofNullable(clazz.cast(tlsInspectionConfigurationArn()));
        case "PolicyVariables":
            return Optional.ofNullable(clazz.cast(policyVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallPolicy, T> g) {
        return obj -> g.apply((FirewallPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallPolicy> {
        /**
         * <p>
         * References to the stateless rule groups that are used in the policy. These define the matching criteria in
         * stateless rules.
         * </p>
         * 
         * @param statelessRuleGroupReferences
         *        References to the stateless rule groups that are used in the policy. These define the matching
         *        criteria in stateless rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRuleGroupReferences(Collection<StatelessRuleGroupReference> statelessRuleGroupReferences);

        /**
         * <p>
         * References to the stateless rule groups that are used in the policy. These define the matching criteria in
         * stateless rules.
         * </p>
         * 
         * @param statelessRuleGroupReferences
         *        References to the stateless rule groups that are used in the policy. These define the matching
         *        criteria in stateless rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessRuleGroupReferences(StatelessRuleGroupReference... statelessRuleGroupReferences);

        /**
         * <p>
         * References to the stateless rule groups that are used in the policy. These define the matching criteria in
         * stateless rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #statelessRuleGroupReferences(List<StatelessRuleGroupReference>)}.
         * 
         * @param statelessRuleGroupReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.StatelessRuleGroupReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessRuleGroupReferences(java.util.Collection<StatelessRuleGroupReference>)
         */
        Builder statelessRuleGroupReferences(Consumer<StatelessRuleGroupReference.Builder>... statelessRuleGroupReferences);

        /**
         * <p>
         * The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want
         * non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>.
         * </p>
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
         * standard section choice.
         * </p>
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify
         * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
         * descriptions under <a>CustomAction</a>.
         * </p>
         * 
         * @param statelessDefaultActions
         *        The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you
         *        want non-matching packets to be forwarded for stateful inspection, specify
         *        <code>aws:forward_to_sfe</code>. </p>
         *        <p>
         *        You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
         *        your standard section choice.
         *        </p>
         *        <p>
         *        For example, you could specify <code>["aws:pass"]</code> or you could specify
         *        <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom
         *        action descriptions under <a>CustomAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessDefaultActions(Collection<String> statelessDefaultActions);

        /**
         * <p>
         * The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want
         * non-matching packets to be forwarded for stateful inspection, specify <code>aws:forward_to_sfe</code>.
         * </p>
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
         * standard section choice.
         * </p>
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify
         * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
         * descriptions under <a>CustomAction</a>.
         * </p>
         * 
         * @param statelessDefaultActions
         *        The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you
         *        want non-matching packets to be forwarded for stateful inspection, specify
         *        <code>aws:forward_to_sfe</code>. </p>
         *        <p>
         *        You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
         *        your standard section choice.
         *        </p>
         *        <p>
         *        For example, you could specify <code>["aws:pass"]</code> or you could specify
         *        <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom
         *        action descriptions under <a>CustomAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessDefaultActions(String... statelessDefaultActions);

        /**
         * <p>
         * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy.
         * Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols.
         * If you want non-matching fragmented UDP packets to be forwarded for stateful inspection, specify
         * <code>aws:forward_to_sfe</code>.
         * </p>
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
         * standard section choice.
         * </p>
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify
         * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
         * descriptions under <a>CustomAction</a>.
         * </p>
         * 
         * @param statelessFragmentDefaultActions
         *        The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the
         *        policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for
         *        other protocols. If you want non-matching fragmented UDP packets to be forwarded for stateful
         *        inspection, specify <code>aws:forward_to_sfe</code>. </p>
         *        <p>
         *        You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
         *        your standard section choice.
         *        </p>
         *        <p>
         *        For example, you could specify <code>["aws:pass"]</code> or you could specify
         *        <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom
         *        action descriptions under <a>CustomAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions);

        /**
         * <p>
         * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy.
         * Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols.
         * If you want non-matching fragmented UDP packets to be forwarded for stateful inspection, specify
         * <code>aws:forward_to_sfe</code>.
         * </p>
         * <p>
         * You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         * <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with your
         * standard section choice.
         * </p>
         * <p>
         * For example, you could specify <code>["aws:pass"]</code> or you could specify
         * <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom action
         * descriptions under <a>CustomAction</a>.
         * </p>
         * 
         * @param statelessFragmentDefaultActions
         *        The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the
         *        policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for
         *        other protocols. If you want non-matching fragmented UDP packets to be forwarded for stateful
         *        inspection, specify <code>aws:forward_to_sfe</code>. </p>
         *        <p>
         *        You must specify one of the standard actions: <code>aws:pass</code>, <code>aws:drop</code>, or
         *        <code>aws:forward_to_sfe</code>. In addition, you can specify custom actions that are compatible with
         *        your standard section choice.
         *        </p>
         *        <p>
         *        For example, you could specify <code>["aws:pass"]</code> or you could specify
         *        <code>["aws:pass", “customActionName”]</code>. For information about compatibility, see the custom
         *        action descriptions under <a>CustomAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessFragmentDefaultActions(String... statelessFragmentDefaultActions);

        /**
         * <p>
         * The custom action definitions that are available for use in the firewall policy's
         * <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you can
         * use it by name in your default actions specifications.
         * </p>
         * 
         * @param statelessCustomActions
         *        The custom action definitions that are available for use in the firewall policy's
         *        <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then
         *        you can use it by name in your default actions specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessCustomActions(Collection<CustomAction> statelessCustomActions);

        /**
         * <p>
         * The custom action definitions that are available for use in the firewall policy's
         * <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you can
         * use it by name in your default actions specifications.
         * </p>
         * 
         * @param statelessCustomActions
         *        The custom action definitions that are available for use in the firewall policy's
         *        <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then
         *        you can use it by name in your default actions specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statelessCustomActions(CustomAction... statelessCustomActions);

        /**
         * <p>
         * The custom action definitions that are available for use in the firewall policy's
         * <code>StatelessDefaultActions</code> setting. You name each custom action that you define, and then you can
         * use it by name in your default actions specifications.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.CustomAction.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.networkfirewall.model.CustomAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.CustomAction.Builder#build()} is called
         * immediately and its result is passed to {@link #statelessCustomActions(List<CustomAction>)}.
         * 
         * @param statelessCustomActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.CustomAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statelessCustomActions(java.util.Collection<CustomAction>)
         */
        Builder statelessCustomActions(Consumer<CustomAction.Builder>... statelessCustomActions);

        /**
         * <p>
         * References to the stateful rule groups that are used in the policy. These define the inspection criteria in
         * stateful rules.
         * </p>
         * 
         * @param statefulRuleGroupReferences
         *        References to the stateful rule groups that are used in the policy. These define the inspection
         *        criteria in stateful rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleGroupReferences(Collection<StatefulRuleGroupReference> statefulRuleGroupReferences);

        /**
         * <p>
         * References to the stateful rule groups that are used in the policy. These define the inspection criteria in
         * stateful rules.
         * </p>
         * 
         * @param statefulRuleGroupReferences
         *        References to the stateful rule groups that are used in the policy. These define the inspection
         *        criteria in stateful rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulRuleGroupReferences(StatefulRuleGroupReference... statefulRuleGroupReferences);

        /**
         * <p>
         * References to the stateful rule groups that are used in the policy. These define the inspection criteria in
         * stateful rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #statefulRuleGroupReferences(List<StatefulRuleGroupReference>)}.
         * 
         * @param statefulRuleGroupReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.networkfirewall.model.StatefulRuleGroupReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statefulRuleGroupReferences(java.util.Collection<StatefulRuleGroupReference>)
         */
        Builder statefulRuleGroupReferences(Consumer<StatefulRuleGroupReference.Builder>... statefulRuleGroupReferences);

        /**
         * <p>
         * The default actions to take on a packet that doesn't match any stateful rules. The stateful default action is
         * optional, and is only valid when using the strict rule order.
         * </p>
         * <p>
         * Valid values of the stateful default action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * aws:drop_strict
         * </p>
         * </li>
         * <li>
         * <p>
         * aws:drop_established
         * </p>
         * </li>
         * <li>
         * <p>
         * aws:alert_strict
         * </p>
         * </li>
         * <li>
         * <p>
         * aws:alert_established
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html"
         * >Strict evaluation order</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param statefulDefaultActions
         *        The default actions to take on a packet that doesn't match any stateful rules. The stateful default
         *        action is optional, and is only valid when using the strict rule order.</p>
         *        <p>
         *        Valid values of the stateful default action:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        aws:drop_strict
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        aws:drop_established
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        aws:alert_strict
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        aws:alert_established
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html"
         *        >Strict evaluation order</a> in the <i>Network Firewall Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulDefaultActions(Collection<String> statefulDefaultActions);

        /**
         * <p>
         * The default actions to take on a packet that doesn't match any stateful rules. The stateful default action is
         * optional, and is only valid when using the strict rule order.
         * </p>
         * <p>
         * Valid values of the stateful default action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * aws:drop_strict
         * </p>
         * </li>
         * <li>
         * <p>
         * aws:drop_established
         * </p>
         * </li>
         * <li>
         * <p>
         * aws:alert_strict
         * </p>
         * </li>
         * <li>
         * <p>
         * aws:alert_established
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html"
         * >Strict evaluation order</a> in the <i>Network Firewall Developer Guide</i>.
         * </p>
         * 
         * @param statefulDefaultActions
         *        The default actions to take on a packet that doesn't match any stateful rules. The stateful default
         *        action is optional, and is only valid when using the strict rule order.</p>
         *        <p>
         *        Valid values of the stateful default action:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        aws:drop_strict
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        aws:drop_established
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        aws:alert_strict
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        aws:alert_established
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html"
         *        >Strict evaluation order</a> in the <i>Network Firewall Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulDefaultActions(String... statefulDefaultActions);

        /**
         * <p>
         * Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you
         * use in your policy must have stateful rule options settings that are compatible with these settings.
         * </p>
         * 
         * @param statefulEngineOptions
         *        Additional options governing how Network Firewall handles stateful rules. The stateful rule groups
         *        that you use in your policy must have stateful rule options settings that are compatible with these
         *        settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statefulEngineOptions(StatefulEngineOptions statefulEngineOptions);

        /**
         * <p>
         * Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you
         * use in your policy must have stateful rule options settings that are compatible with these settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatefulEngineOptions.Builder} avoiding
         * the need to create one manually via {@link StatefulEngineOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatefulEngineOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #statefulEngineOptions(StatefulEngineOptions)}.
         * 
         * @param statefulEngineOptions
         *        a consumer that will call methods on {@link StatefulEngineOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statefulEngineOptions(StatefulEngineOptions)
         */
        default Builder statefulEngineOptions(Consumer<StatefulEngineOptions.Builder> statefulEngineOptions) {
            return statefulEngineOptions(StatefulEngineOptions.builder().applyMutation(statefulEngineOptions).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the TLS inspection configuration.
         * </p>
         * 
         * @param tlsInspectionConfigurationArn
         *        The Amazon Resource Name (ARN) of the TLS inspection configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn);

        /**
         * <p>
         * Contains variables that you can use to override default Suricata settings in your firewall policy.
         * </p>
         * 
         * @param policyVariables
         *        Contains variables that you can use to override default Suricata settings in your firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVariables(PolicyVariables policyVariables);

        /**
         * <p>
         * Contains variables that you can use to override default Suricata settings in your firewall policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyVariables.Builder} avoiding the
         * need to create one manually via {@link PolicyVariables#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyVariables.Builder#build()} is called immediately and its
         * result is passed to {@link #policyVariables(PolicyVariables)}.
         * 
         * @param policyVariables
         *        a consumer that will call methods on {@link PolicyVariables.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyVariables(PolicyVariables)
         */
        default Builder policyVariables(Consumer<PolicyVariables.Builder> policyVariables) {
            return policyVariables(PolicyVariables.builder().applyMutation(policyVariables).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<StatelessRuleGroupReference> statelessRuleGroupReferences = DefaultSdkAutoConstructList.getInstance();

        private List<String> statelessDefaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> statelessFragmentDefaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<CustomAction> statelessCustomActions = DefaultSdkAutoConstructList.getInstance();

        private List<StatefulRuleGroupReference> statefulRuleGroupReferences = DefaultSdkAutoConstructList.getInstance();

        private List<String> statefulDefaultActions = DefaultSdkAutoConstructList.getInstance();

        private StatefulEngineOptions statefulEngineOptions;

        private String tlsInspectionConfigurationArn;

        private PolicyVariables policyVariables;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallPolicy model) {
            statelessRuleGroupReferences(model.statelessRuleGroupReferences);
            statelessDefaultActions(model.statelessDefaultActions);
            statelessFragmentDefaultActions(model.statelessFragmentDefaultActions);
            statelessCustomActions(model.statelessCustomActions);
            statefulRuleGroupReferences(model.statefulRuleGroupReferences);
            statefulDefaultActions(model.statefulDefaultActions);
            statefulEngineOptions(model.statefulEngineOptions);
            tlsInspectionConfigurationArn(model.tlsInspectionConfigurationArn);
            policyVariables(model.policyVariables);
        }

        public final List<StatelessRuleGroupReference.Builder> getStatelessRuleGroupReferences() {
            List<StatelessRuleGroupReference.Builder> result = StatelessRuleGroupReferencesCopier
                    .copyToBuilder(this.statelessRuleGroupReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessRuleGroupReferences(
                Collection<StatelessRuleGroupReference.BuilderImpl> statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences = StatelessRuleGroupReferencesCopier.copyFromBuilder(statelessRuleGroupReferences);
        }

        @Override
        public final Builder statelessRuleGroupReferences(Collection<StatelessRuleGroupReference> statelessRuleGroupReferences) {
            this.statelessRuleGroupReferences = StatelessRuleGroupReferencesCopier.copy(statelessRuleGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroupReferences(StatelessRuleGroupReference... statelessRuleGroupReferences) {
            statelessRuleGroupReferences(Arrays.asList(statelessRuleGroupReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessRuleGroupReferences(
                Consumer<StatelessRuleGroupReference.Builder>... statelessRuleGroupReferences) {
            statelessRuleGroupReferences(Stream.of(statelessRuleGroupReferences)
                    .map(c -> StatelessRuleGroupReference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getStatelessDefaultActions() {
            if (statelessDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessDefaultActions;
        }

        public final void setStatelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = StatelessActionsCopier.copy(statelessDefaultActions);
        }

        @Override
        public final Builder statelessDefaultActions(Collection<String> statelessDefaultActions) {
            this.statelessDefaultActions = StatelessActionsCopier.copy(statelessDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessDefaultActions(String... statelessDefaultActions) {
            statelessDefaultActions(Arrays.asList(statelessDefaultActions));
            return this;
        }

        public final Collection<String> getStatelessFragmentDefaultActions() {
            if (statelessFragmentDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statelessFragmentDefaultActions;
        }

        public final void setStatelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = StatelessActionsCopier.copy(statelessFragmentDefaultActions);
        }

        @Override
        public final Builder statelessFragmentDefaultActions(Collection<String> statelessFragmentDefaultActions) {
            this.statelessFragmentDefaultActions = StatelessActionsCopier.copy(statelessFragmentDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessFragmentDefaultActions(String... statelessFragmentDefaultActions) {
            statelessFragmentDefaultActions(Arrays.asList(statelessFragmentDefaultActions));
            return this;
        }

        public final List<CustomAction.Builder> getStatelessCustomActions() {
            List<CustomAction.Builder> result = CustomActionsCopier.copyToBuilder(this.statelessCustomActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatelessCustomActions(Collection<CustomAction.BuilderImpl> statelessCustomActions) {
            this.statelessCustomActions = CustomActionsCopier.copyFromBuilder(statelessCustomActions);
        }

        @Override
        public final Builder statelessCustomActions(Collection<CustomAction> statelessCustomActions) {
            this.statelessCustomActions = CustomActionsCopier.copy(statelessCustomActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessCustomActions(CustomAction... statelessCustomActions) {
            statelessCustomActions(Arrays.asList(statelessCustomActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statelessCustomActions(Consumer<CustomAction.Builder>... statelessCustomActions) {
            statelessCustomActions(Stream.of(statelessCustomActions).map(c -> CustomAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StatefulRuleGroupReference.Builder> getStatefulRuleGroupReferences() {
            List<StatefulRuleGroupReference.Builder> result = StatefulRuleGroupReferencesCopier
                    .copyToBuilder(this.statefulRuleGroupReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatefulRuleGroupReferences(
                Collection<StatefulRuleGroupReference.BuilderImpl> statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences = StatefulRuleGroupReferencesCopier.copyFromBuilder(statefulRuleGroupReferences);
        }

        @Override
        public final Builder statefulRuleGroupReferences(Collection<StatefulRuleGroupReference> statefulRuleGroupReferences) {
            this.statefulRuleGroupReferences = StatefulRuleGroupReferencesCopier.copy(statefulRuleGroupReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroupReferences(StatefulRuleGroupReference... statefulRuleGroupReferences) {
            statefulRuleGroupReferences(Arrays.asList(statefulRuleGroupReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRuleGroupReferences(
                Consumer<StatefulRuleGroupReference.Builder>... statefulRuleGroupReferences) {
            statefulRuleGroupReferences(Stream.of(statefulRuleGroupReferences)
                    .map(c -> StatefulRuleGroupReference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getStatefulDefaultActions() {
            if (statefulDefaultActions instanceof SdkAutoConstructList) {
                return null;
            }
            return statefulDefaultActions;
        }

        public final void setStatefulDefaultActions(Collection<String> statefulDefaultActions) {
            this.statefulDefaultActions = StatefulActionsCopier.copy(statefulDefaultActions);
        }

        @Override
        public final Builder statefulDefaultActions(Collection<String> statefulDefaultActions) {
            this.statefulDefaultActions = StatefulActionsCopier.copy(statefulDefaultActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulDefaultActions(String... statefulDefaultActions) {
            statefulDefaultActions(Arrays.asList(statefulDefaultActions));
            return this;
        }

        public final StatefulEngineOptions.Builder getStatefulEngineOptions() {
            return statefulEngineOptions != null ? statefulEngineOptions.toBuilder() : null;
        }

        public final void setStatefulEngineOptions(StatefulEngineOptions.BuilderImpl statefulEngineOptions) {
            this.statefulEngineOptions = statefulEngineOptions != null ? statefulEngineOptions.build() : null;
        }

        @Override
        public final Builder statefulEngineOptions(StatefulEngineOptions statefulEngineOptions) {
            this.statefulEngineOptions = statefulEngineOptions;
            return this;
        }

        public final String getTlsInspectionConfigurationArn() {
            return tlsInspectionConfigurationArn;
        }

        public final void setTlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
        }

        @Override
        public final Builder tlsInspectionConfigurationArn(String tlsInspectionConfigurationArn) {
            this.tlsInspectionConfigurationArn = tlsInspectionConfigurationArn;
            return this;
        }

        public final PolicyVariables.Builder getPolicyVariables() {
            return policyVariables != null ? policyVariables.toBuilder() : null;
        }

        public final void setPolicyVariables(PolicyVariables.BuilderImpl policyVariables) {
            this.policyVariables = policyVariables != null ? policyVariables.build() : null;
        }

        @Override
        public final Builder policyVariables(PolicyVariables policyVariables) {
            this.policyVariables = policyVariables;
            return this;
        }

        @Override
        public FirewallPolicy build() {
            return new FirewallPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
