/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateTransitGatewayConnectPeerRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<DisassociateTransitGatewayConnectPeerRequest.Builder, DisassociateTransitGatewayConnectPeerRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalNetworkId").getter(getter(DisassociateTransitGatewayConnectPeerRequest::globalNetworkId))
            .setter(setter(Builder::globalNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_CONNECT_PEER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("TransitGatewayConnectPeerArn")
            .getter(getter(DisassociateTransitGatewayConnectPeerRequest::transitGatewayConnectPeerArn))
            .setter(setter(Builder::transitGatewayConnectPeerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("transitGatewayConnectPeerArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD,
            TRANSIT_GATEWAY_CONNECT_PEER_ARN_FIELD));

    private final String globalNetworkId;

    private final String transitGatewayConnectPeerArn;

    private DisassociateTransitGatewayConnectPeerRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.transitGatewayConnectPeerArn = builder.transitGatewayConnectPeerArn;
    }

    /**
     * <p>
     * The ID of the global network.
     * </p>
     * 
     * @return The ID of the global network.
     */
    public final String globalNetworkId() {
        return globalNetworkId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the transit gateway Connect peer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the transit gateway Connect peer.
     */
    public final String transitGatewayConnectPeerArn() {
        return transitGatewayConnectPeerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayConnectPeerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateTransitGatewayConnectPeerRequest)) {
            return false;
        }
        DisassociateTransitGatewayConnectPeerRequest other = (DisassociateTransitGatewayConnectPeerRequest) obj;
        return Objects.equals(globalNetworkId(), other.globalNetworkId())
                && Objects.equals(transitGatewayConnectPeerArn(), other.transitGatewayConnectPeerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateTransitGatewayConnectPeerRequest").add("GlobalNetworkId", globalNetworkId())
                .add("TransitGatewayConnectPeerArn", transitGatewayConnectPeerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalNetworkId":
            return Optional.ofNullable(clazz.cast(globalNetworkId()));
        case "TransitGatewayConnectPeerArn":
            return Optional.ofNullable(clazz.cast(transitGatewayConnectPeerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateTransitGatewayConnectPeerRequest, T> g) {
        return obj -> g.apply((DisassociateTransitGatewayConnectPeerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateTransitGatewayConnectPeerRequest> {
        /**
         * <p>
         * The ID of the global network.
         * </p>
         * 
         * @param globalNetworkId
         *        The ID of the global network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalNetworkId(String globalNetworkId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the transit gateway Connect peer.
         * </p>
         * 
         * @param transitGatewayConnectPeerArn
         *        The Amazon Resource Name (ARN) of the transit gateway Connect peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConnectPeerArn(String transitGatewayConnectPeerArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String globalNetworkId;

        private String transitGatewayConnectPeerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateTransitGatewayConnectPeerRequest model) {
            super(model);
            globalNetworkId(model.globalNetworkId);
            transitGatewayConnectPeerArn(model.transitGatewayConnectPeerArn);
        }

        public final String getGlobalNetworkId() {
            return globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getTransitGatewayConnectPeerArn() {
            return transitGatewayConnectPeerArn;
        }

        public final void setTransitGatewayConnectPeerArn(String transitGatewayConnectPeerArn) {
            this.transitGatewayConnectPeerArn = transitGatewayConnectPeerArn;
        }

        @Override
        public final Builder transitGatewayConnectPeerArn(String transitGatewayConnectPeerArn) {
            this.transitGatewayConnectPeerArn = transitGatewayConnectPeerArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateTransitGatewayConnectPeerRequest build() {
            return new DisassociateTransitGatewayConnectPeerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
