/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.BgpOptions;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.Tag;
import software.amazon.awssdk.services.networkmanager.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectPeerRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, CreateConnectPeerRequest> {
    private static final SdkField<String> CONNECT_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectAttachmentId").getter(CreateConnectPeerRequest.getter(CreateConnectPeerRequest::connectAttachmentId)).setter(CreateConnectPeerRequest.setter(Builder::connectAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectAttachmentId").build()}).build();
    private static final SdkField<String> CORE_NETWORK_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkAddress").getter(CreateConnectPeerRequest.getter(CreateConnectPeerRequest::coreNetworkAddress)).setter(CreateConnectPeerRequest.setter(Builder::coreNetworkAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(CreateConnectPeerRequest.getter(CreateConnectPeerRequest::peerAddress)).setter(CreateConnectPeerRequest.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").build()}).build();
    private static final SdkField<BgpOptions> BGP_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BgpOptions").getter(CreateConnectPeerRequest.getter(CreateConnectPeerRequest::bgpOptions)).setter(CreateConnectPeerRequest.setter(Builder::bgpOptions)).constructor(BgpOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpOptions").build()}).build();
    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsideCidrBlocks").getter(CreateConnectPeerRequest.getter(CreateConnectPeerRequest::insideCidrBlocks)).setter(CreateConnectPeerRequest.setter(Builder::insideCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateConnectPeerRequest.getter(CreateConnectPeerRequest::tags)).setter(CreateConnectPeerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateConnectPeerRequest.getter(CreateConnectPeerRequest::clientToken)).setter(CreateConnectPeerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetArn").getter(CreateConnectPeerRequest.getter(CreateConnectPeerRequest::subnetArn)).setter(CreateConnectPeerRequest.setter(Builder::subnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_ATTACHMENT_ID_FIELD, CORE_NETWORK_ADDRESS_FIELD, PEER_ADDRESS_FIELD, BGP_OPTIONS_FIELD, INSIDE_CIDR_BLOCKS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, SUBNET_ARN_FIELD));
    private final String connectAttachmentId;
    private final String coreNetworkAddress;
    private final String peerAddress;
    private final BgpOptions bgpOptions;
    private final List<String> insideCidrBlocks;
    private final List<Tag> tags;
    private final String clientToken;
    private final String subnetArn;

    private CreateConnectPeerRequest(BuilderImpl builder) {
        super(builder);
        this.connectAttachmentId = builder.connectAttachmentId;
        this.coreNetworkAddress = builder.coreNetworkAddress;
        this.peerAddress = builder.peerAddress;
        this.bgpOptions = builder.bgpOptions;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.subnetArn = builder.subnetArn;
    }

    public final String connectAttachmentId() {
        return this.connectAttachmentId;
    }

    public final String coreNetworkAddress() {
        return this.coreNetworkAddress;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final BgpOptions bgpOptions() {
        return this.bgpOptions;
    }

    public final boolean hasInsideCidrBlocks() {
        return this.insideCidrBlocks != null && !(this.insideCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> insideCidrBlocks() {
        return this.insideCidrBlocks;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String subnetArn() {
        return this.subnetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectPeerRequest)) {
            return false;
        }
        CreateConnectPeerRequest other = (CreateConnectPeerRequest)((Object)obj);
        return Objects.equals(this.connectAttachmentId(), other.connectAttachmentId()) && Objects.equals(this.coreNetworkAddress(), other.coreNetworkAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && Objects.equals(this.bgpOptions(), other.bgpOptions()) && this.hasInsideCidrBlocks() == other.hasInsideCidrBlocks() && Objects.equals(this.insideCidrBlocks(), other.insideCidrBlocks()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.subnetArn(), other.subnetArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectPeerRequest").add("ConnectAttachmentId", (Object)this.connectAttachmentId()).add("CoreNetworkAddress", (Object)this.coreNetworkAddress()).add("PeerAddress", (Object)this.peerAddress()).add("BgpOptions", (Object)this.bgpOptions()).add("InsideCidrBlocks", this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).add("SubnetArn", (Object)this.subnetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.connectAttachmentId()));
            }
            case "CoreNetworkAddress": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "BgpOptions": {
                return Optional.ofNullable(clazz.cast(this.bgpOptions()));
            }
            case "InsideCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.insideCidrBlocks()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "SubnetArn": {
                return Optional.ofNullable(clazz.cast(this.subnetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectPeerRequest, T> g) {
        return obj -> g.apply((CreateConnectPeerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String connectAttachmentId;
        private String coreNetworkAddress;
        private String peerAddress;
        private BgpOptions bgpOptions;
        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String subnetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectPeerRequest model) {
            super(model);
            this.connectAttachmentId(model.connectAttachmentId);
            this.coreNetworkAddress(model.coreNetworkAddress);
            this.peerAddress(model.peerAddress);
            this.bgpOptions(model.bgpOptions);
            this.insideCidrBlocks(model.insideCidrBlocks);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
            this.subnetArn(model.subnetArn);
        }

        public final String getConnectAttachmentId() {
            return this.connectAttachmentId;
        }

        public final void setConnectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
        }

        @Override
        public final Builder connectAttachmentId(String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
            return this;
        }

        public final String getCoreNetworkAddress() {
            return this.coreNetworkAddress;
        }

        public final void setCoreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
        }

        @Override
        public final Builder coreNetworkAddress(String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final BgpOptions.Builder getBgpOptions() {
            return this.bgpOptions != null ? this.bgpOptions.toBuilder() : null;
        }

        public final void setBgpOptions(BgpOptions.BuilderImpl bgpOptions) {
            this.bgpOptions = bgpOptions != null ? bgpOptions.build() : null;
        }

        @Override
        public final Builder bgpOptions(BgpOptions bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (this.insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String ... insideCidrBlocks) {
            this.insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSubnetArn() {
            return this.subnetArn;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        @Override
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectPeerRequest build() {
            return new CreateConnectPeerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectPeerRequest> {
        public Builder connectAttachmentId(String var1);

        public Builder coreNetworkAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder bgpOptions(BgpOptions var1);

        default public Builder bgpOptions(Consumer<BgpOptions.Builder> bgpOptions) {
            return this.bgpOptions((BgpOptions)((BgpOptions.Builder)BgpOptions.builder().applyMutation(bgpOptions)).build());
        }

        public Builder insideCidrBlocks(Collection<String> var1);

        public Builder insideCidrBlocks(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder subnetArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

