/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelCapacityTaskRequest extends OutpostsRequest implements
        ToCopyableBuilder<CancelCapacityTaskRequest.Builder, CancelCapacityTaskRequest> {
    private static final SdkField<String> CAPACITY_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityTaskId").getter(getter(CancelCapacityTaskRequest::capacityTaskId))
            .setter(setter(Builder::capacityTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CapacityTaskId").build()).build();

    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostIdentifier").getter(getter(CancelCapacityTaskRequest::outpostIdentifier))
            .setter(setter(Builder::outpostIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_TASK_ID_FIELD,
            OUTPOST_IDENTIFIER_FIELD));

    private final String capacityTaskId;

    private final String outpostIdentifier;

    private CancelCapacityTaskRequest(BuilderImpl builder) {
        super(builder);
        this.capacityTaskId = builder.capacityTaskId;
        this.outpostIdentifier = builder.outpostIdentifier;
    }

    /**
     * <p>
     * ID of the capacity task that you want to cancel.
     * </p>
     * 
     * @return ID of the capacity task that you want to cancel.
     */
    public final String capacityTaskId() {
        return capacityTaskId;
    }

    /**
     * <p>
     * ID or ARN of the Outpost associated with the capacity task that you want to cancel.
     * </p>
     * 
     * @return ID or ARN of the Outpost associated with the capacity task that you want to cancel.
     */
    public final String outpostIdentifier() {
        return outpostIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelCapacityTaskRequest)) {
            return false;
        }
        CancelCapacityTaskRequest other = (CancelCapacityTaskRequest) obj;
        return Objects.equals(capacityTaskId(), other.capacityTaskId())
                && Objects.equals(outpostIdentifier(), other.outpostIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelCapacityTaskRequest").add("CapacityTaskId", capacityTaskId())
                .add("OutpostIdentifier", outpostIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityTaskId":
            return Optional.ofNullable(clazz.cast(capacityTaskId()));
        case "OutpostIdentifier":
            return Optional.ofNullable(clazz.cast(outpostIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelCapacityTaskRequest, T> g) {
        return obj -> g.apply((CancelCapacityTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelCapacityTaskRequest> {
        /**
         * <p>
         * ID of the capacity task that you want to cancel.
         * </p>
         * 
         * @param capacityTaskId
         *        ID of the capacity task that you want to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTaskId(String capacityTaskId);

        /**
         * <p>
         * ID or ARN of the Outpost associated with the capacity task that you want to cancel.
         * </p>
         * 
         * @param outpostIdentifier
         *        ID or ARN of the Outpost associated with the capacity task that you want to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostIdentifier(String outpostIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String capacityTaskId;

        private String outpostIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelCapacityTaskRequest model) {
            super(model);
            capacityTaskId(model.capacityTaskId);
            outpostIdentifier(model.outpostIdentifier);
        }

        public final String getCapacityTaskId() {
            return capacityTaskId;
        }

        public final void setCapacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
        }

        @Override
        public final Builder capacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
            return this;
        }

        public final String getOutpostIdentifier() {
            return outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelCapacityTaskRequest build() {
            return new CancelCapacityTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
