/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRedshiftIdcApplicationResponse extends RedshiftResponse implements
        ToCopyableBuilder<CreateRedshiftIdcApplicationResponse.Builder, CreateRedshiftIdcApplicationResponse> {
    private static final SdkField<RedshiftIdcApplication> REDSHIFT_IDC_APPLICATION_FIELD = SdkField
            .<RedshiftIdcApplication> builder(MarshallingType.SDK_POJO).memberName("RedshiftIdcApplication")
            .getter(getter(CreateRedshiftIdcApplicationResponse::redshiftIdcApplication))
            .setter(setter(Builder::redshiftIdcApplication)).constructor(RedshiftIdcApplication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftIdcApplication").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REDSHIFT_IDC_APPLICATION_FIELD));

    private final RedshiftIdcApplication redshiftIdcApplication;

    private CreateRedshiftIdcApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.redshiftIdcApplication = builder.redshiftIdcApplication;
    }

    /**
     * Returns the value of the RedshiftIdcApplication property for this object.
     * 
     * @return The value of the RedshiftIdcApplication property for this object.
     */
    public final RedshiftIdcApplication redshiftIdcApplication() {
        return redshiftIdcApplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(redshiftIdcApplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRedshiftIdcApplicationResponse)) {
            return false;
        }
        CreateRedshiftIdcApplicationResponse other = (CreateRedshiftIdcApplicationResponse) obj;
        return Objects.equals(redshiftIdcApplication(), other.redshiftIdcApplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRedshiftIdcApplicationResponse").add("RedshiftIdcApplication", redshiftIdcApplication())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedshiftIdcApplication":
            return Optional.ofNullable(clazz.cast(redshiftIdcApplication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRedshiftIdcApplicationResponse, T> g) {
        return obj -> g.apply((CreateRedshiftIdcApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRedshiftIdcApplicationResponse> {
        /**
         * Sets the value of the RedshiftIdcApplication property for this object.
         *
         * @param redshiftIdcApplication
         *        The new value for the RedshiftIdcApplication property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftIdcApplication(RedshiftIdcApplication redshiftIdcApplication);

        /**
         * Sets the value of the RedshiftIdcApplication property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RedshiftIdcApplication.Builder} avoiding
         * the need to create one manually via {@link RedshiftIdcApplication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftIdcApplication.Builder#build()} is called immediately and
         * its result is passed to {@link #redshiftIdcApplication(RedshiftIdcApplication)}.
         * 
         * @param redshiftIdcApplication
         *        a consumer that will call methods on {@link RedshiftIdcApplication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftIdcApplication(RedshiftIdcApplication)
         */
        default Builder redshiftIdcApplication(Consumer<RedshiftIdcApplication.Builder> redshiftIdcApplication) {
            return redshiftIdcApplication(RedshiftIdcApplication.builder().applyMutation(redshiftIdcApplication).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private RedshiftIdcApplication redshiftIdcApplication;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRedshiftIdcApplicationResponse model) {
            super(model);
            redshiftIdcApplication(model.redshiftIdcApplication);
        }

        public final RedshiftIdcApplication.Builder getRedshiftIdcApplication() {
            return redshiftIdcApplication != null ? redshiftIdcApplication.toBuilder() : null;
        }

        public final void setRedshiftIdcApplication(RedshiftIdcApplication.BuilderImpl redshiftIdcApplication) {
            this.redshiftIdcApplication = redshiftIdcApplication != null ? redshiftIdcApplication.build() : null;
        }

        @Override
        public final Builder redshiftIdcApplication(RedshiftIdcApplication redshiftIdcApplication) {
            this.redshiftIdcApplication = redshiftIdcApplication;
            return this;
        }

        @Override
        public CreateRedshiftIdcApplicationResponse build() {
            return new CreateRedshiftIdcApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
