/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAuthenticationProfilesResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeAuthenticationProfilesResponse.Builder, DescribeAuthenticationProfilesResponse> {
    private static final SdkField<List<AuthenticationProfile>> AUTHENTICATION_PROFILES_FIELD = SdkField
            .<List<AuthenticationProfile>> builder(MarshallingType.LIST)
            .memberName("AuthenticationProfiles")
            .getter(getter(DescribeAuthenticationProfilesResponse::authenticationProfiles))
            .setter(setter(Builder::authenticationProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthenticationProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthenticationProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AUTHENTICATION_PROFILES_FIELD));

    private final List<AuthenticationProfile> authenticationProfiles;

    private DescribeAuthenticationProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationProfiles = builder.authenticationProfiles;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthenticationProfiles property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthenticationProfiles() {
        return authenticationProfiles != null && !(authenticationProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of authentication profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticationProfiles} method.
     * </p>
     * 
     * @return The list of authentication profiles.
     */
    public final List<AuthenticationProfile> authenticationProfiles() {
        return authenticationProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthenticationProfiles() ? authenticationProfiles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuthenticationProfilesResponse)) {
            return false;
        }
        DescribeAuthenticationProfilesResponse other = (DescribeAuthenticationProfilesResponse) obj;
        return hasAuthenticationProfiles() == other.hasAuthenticationProfiles()
                && Objects.equals(authenticationProfiles(), other.authenticationProfiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAuthenticationProfilesResponse")
                .add("AuthenticationProfiles", hasAuthenticationProfiles() ? authenticationProfiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationProfiles":
            return Optional.ofNullable(clazz.cast(authenticationProfiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAuthenticationProfilesResponse, T> g) {
        return obj -> g.apply((DescribeAuthenticationProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAuthenticationProfilesResponse> {
        /**
         * <p>
         * The list of authentication profiles.
         * </p>
         * 
         * @param authenticationProfiles
         *        The list of authentication profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProfiles(Collection<AuthenticationProfile> authenticationProfiles);

        /**
         * <p>
         * The list of authentication profiles.
         * </p>
         * 
         * @param authenticationProfiles
         *        The list of authentication profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProfiles(AuthenticationProfile... authenticationProfiles);

        /**
         * <p>
         * The list of authentication profiles.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.AuthenticationProfile.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.AuthenticationProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.AuthenticationProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationProfiles(List<AuthenticationProfile>)}.
         * 
         * @param authenticationProfiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.AuthenticationProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationProfiles(java.util.Collection<AuthenticationProfile>)
         */
        Builder authenticationProfiles(Consumer<AuthenticationProfile.Builder>... authenticationProfiles);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<AuthenticationProfile> authenticationProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuthenticationProfilesResponse model) {
            super(model);
            authenticationProfiles(model.authenticationProfiles);
        }

        public final List<AuthenticationProfile.Builder> getAuthenticationProfiles() {
            List<AuthenticationProfile.Builder> result = AuthenticationProfileListCopier
                    .copyToBuilder(this.authenticationProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthenticationProfiles(Collection<AuthenticationProfile.BuilderImpl> authenticationProfiles) {
            this.authenticationProfiles = AuthenticationProfileListCopier.copyFromBuilder(authenticationProfiles);
        }

        @Override
        public final Builder authenticationProfiles(Collection<AuthenticationProfile> authenticationProfiles) {
            this.authenticationProfiles = AuthenticationProfileListCopier.copy(authenticationProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProfiles(AuthenticationProfile... authenticationProfiles) {
            authenticationProfiles(Arrays.asList(authenticationProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProfiles(Consumer<AuthenticationProfile.Builder>... authenticationProfiles) {
            authenticationProfiles(Stream.of(authenticationProfiles)
                    .map(c -> AuthenticationProfile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAuthenticationProfilesResponse build() {
            return new DescribeAuthenticationProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
