/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recommended action from the Amazon Redshift Advisor recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendedAction implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendedAction.Builder, RecommendedAction> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(RecommendedAction::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(RecommendedAction::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> COMMAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Command")
            .getter(getter(RecommendedAction::command)).setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RecommendedAction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, DATABASE_FIELD,
            COMMAND_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String text;

    private final String database;

    private final String command;

    private final String type;

    private RecommendedAction(BuilderImpl builder) {
        this.text = builder.text;
        this.database = builder.database;
        this.command = builder.command;
        this.type = builder.type;
    }

    /**
     * <p>
     * The specific instruction about the command.
     * </p>
     * 
     * @return The specific instruction about the command.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The database name to perform the action on. Only applicable if the type of command is SQL.
     * </p>
     * 
     * @return The database name to perform the action on. Only applicable if the type of command is SQL.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The command to run.
     * </p>
     * 
     * @return The command to run.
     */
    public final String command() {
        return command;
    }

    /**
     * <p>
     * The type of command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecommendedActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of command.
     * @see RecommendedActionType
     */
    public final RecommendedActionType type() {
        return RecommendedActionType.fromValue(type);
    }

    /**
     * <p>
     * The type of command.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecommendedActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of command.
     * @see RecommendedActionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendedAction)) {
            return false;
        }
        RecommendedAction other = (RecommendedAction) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(database(), other.database())
                && Objects.equals(command(), other.command()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendedAction").add("Text", text()).add("Database", database()).add("Command", command())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Command":
            return Optional.ofNullable(clazz.cast(command()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendedAction, T> g) {
        return obj -> g.apply((RecommendedAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendedAction> {
        /**
         * <p>
         * The specific instruction about the command.
         * </p>
         * 
         * @param text
         *        The specific instruction about the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The database name to perform the action on. Only applicable if the type of command is SQL.
         * </p>
         * 
         * @param database
         *        The database name to perform the action on. Only applicable if the type of command is SQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The command to run.
         * </p>
         * 
         * @param command
         *        The command to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String command);

        /**
         * <p>
         * The type of command.
         * </p>
         * 
         * @param type
         *        The type of command.
         * @see RecommendedActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendedActionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of command.
         * </p>
         * 
         * @param type
         *        The type of command.
         * @see RecommendedActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendedActionType
         */
        Builder type(RecommendedActionType type);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private String database;

        private String command;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendedAction model) {
            text(model.text);
            database(model.database);
            command(model.command);
            type(model.type);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getCommand() {
            return command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecommendedActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RecommendedAction build() {
            return new RecommendedAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
