/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A link to an Amazon Redshift Advisor reference for more information about a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceLink implements SdkPojo, Serializable, ToCopyableBuilder<ReferenceLink.Builder, ReferenceLink> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(ReferenceLink::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Link")
            .getter(getter(ReferenceLink::link)).setter(setter(Builder::link))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Link").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, LINK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String text;

    private final String link;

    private ReferenceLink(BuilderImpl builder) {
        this.text = builder.text;
        this.link = builder.link;
    }

    /**
     * <p>
     * The hyperlink text that describes the link to more information.
     * </p>
     * 
     * @return The hyperlink text that describes the link to more information.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The URL address to find more information.
     * </p>
     * 
     * @return The URL address to find more information.
     */
    public final String link() {
        return link;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(link());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLink)) {
            return false;
        }
        ReferenceLink other = (ReferenceLink) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(link(), other.link());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceLink").add("Text", text()).add("Link", link()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Link":
            return Optional.ofNullable(clazz.cast(link()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLink, T> g) {
        return obj -> g.apply((ReferenceLink) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceLink> {
        /**
         * <p>
         * The hyperlink text that describes the link to more information.
         * </p>
         * 
         * @param text
         *        The hyperlink text that describes the link to more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The URL address to find more information.
         * </p>
         * 
         * @param link
         *        The URL address to find more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder link(String link);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private String link;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLink model) {
            text(model.text);
            link(model.link);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getLink() {
            return link;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        @Override
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        @Override
        public ReferenceLink build() {
            return new ReferenceLink(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
