/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a resize cluster operation. For example, a scheduled action to run the <code>ResizeCluster</code> API
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResizeClusterRequest extends RedshiftRequest implements
        ToCopyableBuilder<ResizeClusterRequest.Builder, ResizeClusterRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ResizeClusterRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterType").getter(getter(ResizeClusterRequest::clusterType)).setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterType").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(ResizeClusterRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfNodes").getter(getter(ResizeClusterRequest::numberOfNodes))
            .setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<Boolean> CLASSIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Classic").getter(getter(ResizeClusterRequest::classic)).setter(setter(Builder::classic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classic").build()).build();

    private static final SdkField<String> RESERVED_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedNodeId").getter(getter(ResizeClusterRequest::reservedNodeId))
            .setter(setter(Builder::reservedNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeId").build()).build();

    private static final SdkField<String> TARGET_RESERVED_NODE_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetReservedNodeOfferingId")
            .getter(getter(ResizeClusterRequest::targetReservedNodeOfferingId))
            .setter(setter(Builder::targetReservedNodeOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeOfferingId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            CLUSTER_TYPE_FIELD, NODE_TYPE_FIELD, NUMBER_OF_NODES_FIELD, CLASSIC_FIELD, RESERVED_NODE_ID_FIELD,
            TARGET_RESERVED_NODE_OFFERING_ID_FIELD));

    private final String clusterIdentifier;

    private final String clusterType;

    private final String nodeType;

    private final Integer numberOfNodes;

    private final Boolean classic;

    private final String reservedNodeId;

    private final String targetReservedNodeOfferingId;

    private ResizeClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.classic = builder.classic;
        this.reservedNodeId = builder.reservedNodeId;
        this.targetReservedNodeOfferingId = builder.targetReservedNodeOfferingId;
    }

    /**
     * <p>
     * The unique identifier for the cluster to resize.
     * </p>
     * 
     * @return The unique identifier for the cluster to resize.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The new cluster type for the specified cluster.
     * </p>
     * 
     * @return The new cluster type for the specified cluster.
     */
    public final String clusterType() {
        return clusterType;
    }

    /**
     * <p>
     * The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.
     * </p>
     * 
     * @return The new node type for the nodes you are adding. If not specified, the cluster's current node type is
     *         used.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.
     * </p>
     * 
     * @return The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.
     */
    public final Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide
     * this parameter or set the value to <code>false</code>, the resize type is elastic.
     * </p>
     * 
     * @return A boolean value indicating whether the resize operation is using the classic resize process. If you don't
     *         provide this parameter or set the value to <code>false</code>, the resize type is elastic.
     */
    public final Boolean classic() {
        return classic;
    }

    /**
     * <p>
     * The identifier of the reserved node.
     * </p>
     * 
     * @return The identifier of the reserved node.
     */
    public final String reservedNodeId() {
        return reservedNodeId;
    }

    /**
     * <p>
     * The identifier of the target reserved node offering.
     * </p>
     * 
     * @return The identifier of the target reserved node offering.
     */
    public final String targetReservedNodeOfferingId() {
        return targetReservedNodeOfferingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(classic());
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(targetReservedNodeOfferingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResizeClusterRequest)) {
            return false;
        }
        ResizeClusterRequest other = (ResizeClusterRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(clusterType(), other.clusterType()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(numberOfNodes(), other.numberOfNodes()) && Objects.equals(classic(), other.classic())
                && Objects.equals(reservedNodeId(), other.reservedNodeId())
                && Objects.equals(targetReservedNodeOfferingId(), other.targetReservedNodeOfferingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResizeClusterRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("ClusterType", clusterType()).add("NodeType", nodeType()).add("NumberOfNodes", numberOfNodes())
                .add("Classic", classic()).add("ReservedNodeId", reservedNodeId())
                .add("TargetReservedNodeOfferingId", targetReservedNodeOfferingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "ClusterType":
            return Optional.ofNullable(clazz.cast(clusterType()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "Classic":
            return Optional.ofNullable(clazz.cast(classic()));
        case "ReservedNodeId":
            return Optional.ofNullable(clazz.cast(reservedNodeId()));
        case "TargetReservedNodeOfferingId":
            return Optional.ofNullable(clazz.cast(targetReservedNodeOfferingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResizeClusterRequest, T> g) {
        return obj -> g.apply((ResizeClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResizeClusterRequest> {
        /**
         * <p>
         * The unique identifier for the cluster to resize.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier for the cluster to resize.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The new cluster type for the specified cluster.
         * </p>
         * 
         * @param clusterType
         *        The new cluster type for the specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.
         * </p>
         * 
         * @param nodeType
         *        The new node type for the nodes you are adding. If not specified, the cluster's current node type is
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.
         * </p>
         * 
         * @param numberOfNodes
         *        The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * A boolean value indicating whether the resize operation is using the classic resize process. If you don't
         * provide this parameter or set the value to <code>false</code>, the resize type is elastic.
         * </p>
         * 
         * @param classic
         *        A boolean value indicating whether the resize operation is using the classic resize process. If you
         *        don't provide this parameter or set the value to <code>false</code>, the resize type is elastic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classic(Boolean classic);

        /**
         * <p>
         * The identifier of the reserved node.
         * </p>
         * 
         * @param reservedNodeId
         *        The identifier of the reserved node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeId(String reservedNodeId);

        /**
         * <p>
         * The identifier of the target reserved node offering.
         * </p>
         * 
         * @param targetReservedNodeOfferingId
         *        The identifier of the target reserved node offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String clusterType;

        private String nodeType;

        private Integer numberOfNodes;

        private Boolean classic;

        private String reservedNodeId;

        private String targetReservedNodeOfferingId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResizeClusterRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            clusterType(model.clusterType);
            nodeType(model.nodeType);
            numberOfNodes(model.numberOfNodes);
            classic(model.classic);
            reservedNodeId(model.reservedNodeId);
            targetReservedNodeOfferingId(model.targetReservedNodeOfferingId);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final Boolean getClassic() {
            return classic;
        }

        public final void setClassic(Boolean classic) {
            this.classic = classic;
        }

        @Override
        public final Builder classic(Boolean classic) {
            this.classic = classic;
            return this;
        }

        public final String getReservedNodeId() {
            return reservedNodeId;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final String getTargetReservedNodeOfferingId() {
            return targetReservedNodeOfferingId;
        }

        public final void setTargetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
        }

        @Override
        public final Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResizeClusterRequest build() {
            return new ResizeClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
