/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The AvailabilityZone and ClusterNodes information of the secondary compute unit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecondaryClusterInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SecondaryClusterInfo.Builder, SecondaryClusterInfo> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(SecondaryClusterInfo::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<List<ClusterNode>> CLUSTER_NODES_FIELD = SdkField
            .<List<ClusterNode>> builder(MarshallingType.LIST)
            .memberName("ClusterNodes")
            .getter(getter(SecondaryClusterInfo::clusterNodes))
            .setter(setter(Builder::clusterNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            CLUSTER_NODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final List<ClusterNode> clusterNodes;

    private SecondaryClusterInfo(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.clusterNodes = builder.clusterNodes;
    }

    /**
     * <p>
     * The name of the Availability Zone in which the secondary compute unit of the cluster is located.
     * </p>
     * 
     * @return The name of the Availability Zone in which the secondary compute unit of the cluster is located.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterNodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterNodes() {
        return clusterNodes != null && !(clusterNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The nodes in the secondary compute unit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterNodes} method.
     * </p>
     * 
     * @return The nodes in the secondary compute unit.
     */
    public final List<ClusterNode> clusterNodes() {
        return clusterNodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterNodes() ? clusterNodes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondaryClusterInfo)) {
            return false;
        }
        SecondaryClusterInfo other = (SecondaryClusterInfo) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && hasClusterNodes() == other.hasClusterNodes()
                && Objects.equals(clusterNodes(), other.clusterNodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecondaryClusterInfo").add("AvailabilityZone", availabilityZone())
                .add("ClusterNodes", hasClusterNodes() ? clusterNodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ClusterNodes":
            return Optional.ofNullable(clazz.cast(clusterNodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecondaryClusterInfo, T> g) {
        return obj -> g.apply((SecondaryClusterInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecondaryClusterInfo> {
        /**
         * <p>
         * The name of the Availability Zone in which the secondary compute unit of the cluster is located.
         * </p>
         * 
         * @param availabilityZone
         *        The name of the Availability Zone in which the secondary compute unit of the cluster is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The nodes in the secondary compute unit.
         * </p>
         * 
         * @param clusterNodes
         *        The nodes in the secondary compute unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNodes(Collection<ClusterNode> clusterNodes);

        /**
         * <p>
         * The nodes in the secondary compute unit.
         * </p>
         * 
         * @param clusterNodes
         *        The nodes in the secondary compute unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNodes(ClusterNode... clusterNodes);

        /**
         * <p>
         * The nodes in the secondary compute unit.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.ClusterNode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.redshift.model.ClusterNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.ClusterNode.Builder#build()} is called immediately and
         * its result is passed to {@link #clusterNodes(List<ClusterNode>)}.
         * 
         * @param clusterNodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.ClusterNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterNodes(java.util.Collection<ClusterNode>)
         */
        Builder clusterNodes(Consumer<ClusterNode.Builder>... clusterNodes);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private List<ClusterNode> clusterNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecondaryClusterInfo model) {
            availabilityZone(model.availabilityZone);
            clusterNodes(model.clusterNodes);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final List<ClusterNode.Builder> getClusterNodes() {
            List<ClusterNode.Builder> result = ClusterNodesListCopier.copyToBuilder(this.clusterNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterNodes(Collection<ClusterNode.BuilderImpl> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copyFromBuilder(clusterNodes);
        }

        @Override
        public final Builder clusterNodes(Collection<ClusterNode> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copy(clusterNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(ClusterNode... clusterNodes) {
            clusterNodes(Arrays.asList(clusterNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(Consumer<ClusterNode.Builder>... clusterNodes) {
            clusterNodes(Stream.of(clusterNodes).map(c -> ClusterNode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SecondaryClusterInfo build() {
            return new SecondaryClusterInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
