/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.Parameter;

public class DescribeDefaultClusterParametersIterable
implements SdkIterable<DescribeDefaultClusterParametersResponse> {
    private final RedshiftClient client;
    private final DescribeDefaultClusterParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDefaultClusterParametersIterable(RedshiftClient client, DescribeDefaultClusterParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDefaultClusterParametersResponseFetcher();
    }

    public Iterator<DescribeDefaultClusterParametersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeDefaultClusterParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.defaultClusterParameters() != null && response.defaultClusterParameters().parameters() != null) {
                return response.defaultClusterParameters().parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDefaultClusterParametersResponseFetcher
    implements SyncPageFetcher<DescribeDefaultClusterParametersResponse> {
        private DescribeDefaultClusterParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDefaultClusterParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.defaultClusterParameters().marker());
        }

        public DescribeDefaultClusterParametersResponse nextPage(DescribeDefaultClusterParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDefaultClusterParametersIterable.this.client.describeDefaultClusterParameters(DescribeDefaultClusterParametersIterable.this.firstRequest);
            }
            return DescribeDefaultClusterParametersIterable.this.client.describeDefaultClusterParameters((DescribeDefaultClusterParametersRequest)((Object)DescribeDefaultClusterParametersIterable.this.firstRequest.toBuilder().marker(previousPage.defaultClusterParameters().marker()).build()));
        }
    }
}

