/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom SageMaker image. For more information, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomImage implements SdkPojo, Serializable, ToCopyableBuilder<CustomImage.Builder, CustomImage> {
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(CustomImage::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<Integer> IMAGE_VERSION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ImageVersionNumber").getter(getter(CustomImage::imageVersionNumber))
            .setter(setter(Builder::imageVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersionNumber").build())
            .build();

    private static final SdkField<String> APP_IMAGE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppImageConfigName").getter(getter(CustomImage::appImageConfigName))
            .setter(setter(Builder::appImageConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_NAME_FIELD,
            IMAGE_VERSION_NUMBER_FIELD, APP_IMAGE_CONFIG_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String imageName;

    private final Integer imageVersionNumber;

    private final String appImageConfigName;

    private CustomImage(BuilderImpl builder) {
        this.imageName = builder.imageName;
        this.imageVersionNumber = builder.imageVersionNumber;
        this.appImageConfigName = builder.appImageConfigName;
    }

    /**
     * <p>
     * The name of the CustomImage. Must be unique to your account.
     * </p>
     * 
     * @return The name of the CustomImage. Must be unique to your account.
     */
    public final String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The version number of the CustomImage.
     * </p>
     * 
     * @return The version number of the CustomImage.
     */
    public final Integer imageVersionNumber() {
        return imageVersionNumber;
    }

    /**
     * <p>
     * The name of the AppImageConfig.
     * </p>
     * 
     * @return The name of the AppImageConfig.
     */
    public final String appImageConfigName() {
        return appImageConfigName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(imageVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(appImageConfigName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomImage)) {
            return false;
        }
        CustomImage other = (CustomImage) obj;
        return Objects.equals(imageName(), other.imageName()) && Objects.equals(imageVersionNumber(), other.imageVersionNumber())
                && Objects.equals(appImageConfigName(), other.appImageConfigName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomImage").add("ImageName", imageName()).add("ImageVersionNumber", imageVersionNumber())
                .add("AppImageConfigName", appImageConfigName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "ImageVersionNumber":
            return Optional.ofNullable(clazz.cast(imageVersionNumber()));
        case "AppImageConfigName":
            return Optional.ofNullable(clazz.cast(appImageConfigName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomImage, T> g) {
        return obj -> g.apply((CustomImage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomImage> {
        /**
         * <p>
         * The name of the CustomImage. Must be unique to your account.
         * </p>
         * 
         * @param imageName
         *        The name of the CustomImage. Must be unique to your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The version number of the CustomImage.
         * </p>
         * 
         * @param imageVersionNumber
         *        The version number of the CustomImage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersionNumber(Integer imageVersionNumber);

        /**
         * <p>
         * The name of the AppImageConfig.
         * </p>
         * 
         * @param appImageConfigName
         *        The name of the AppImageConfig.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appImageConfigName(String appImageConfigName);
    }

    static final class BuilderImpl implements Builder {
        private String imageName;

        private Integer imageVersionNumber;

        private String appImageConfigName;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomImage model) {
            imageName(model.imageName);
            imageVersionNumber(model.imageVersionNumber);
            appImageConfigName(model.appImageConfigName);
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final Integer getImageVersionNumber() {
            return imageVersionNumber;
        }

        public final void setImageVersionNumber(Integer imageVersionNumber) {
            this.imageVersionNumber = imageVersionNumber;
        }

        @Override
        public final Builder imageVersionNumber(Integer imageVersionNumber) {
            this.imageVersionNumber = imageVersionNumber;
            return this;
        }

        public final String getAppImageConfigName() {
            return appImageConfigName;
        }

        public final void setAppImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
        }

        @Override
        public final Builder appImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        @Override
        public CustomImage build() {
            return new CustomImage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
