/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entity returned by the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchRecord.html">SearchRecord</a> API
 * containing the properties of a hyperparameter tuning job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterTuningJobSearchEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterTuningJobSearchEntity.Builder, HyperParameterTuningJobSearchEntity> {
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HyperParameterTuningJobName")
            .getter(getter(HyperParameterTuningJobSearchEntity::hyperParameterTuningJobName))
            .setter(setter(Builder::hyperParameterTuningJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobName")
                    .build()).build();

    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HyperParameterTuningJobArn")
            .getter(getter(HyperParameterTuningJobSearchEntity::hyperParameterTuningJobArn))
            .setter(setter(Builder::hyperParameterTuningJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobArn").build())
            .build();

    private static final SdkField<HyperParameterTuningJobConfig> HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD = SdkField
            .<HyperParameterTuningJobConfig> builder(MarshallingType.SDK_POJO)
            .memberName("HyperParameterTuningJobConfig")
            .getter(getter(HyperParameterTuningJobSearchEntity::hyperParameterTuningJobConfig))
            .setter(setter(Builder::hyperParameterTuningJobConfig))
            .constructor(HyperParameterTuningJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobConfig")
                    .build()).build();

    private static final SdkField<HyperParameterTrainingJobDefinition> TRAINING_JOB_DEFINITION_FIELD = SdkField
            .<HyperParameterTrainingJobDefinition> builder(MarshallingType.SDK_POJO).memberName("TrainingJobDefinition")
            .getter(getter(HyperParameterTuningJobSearchEntity::trainingJobDefinition))
            .setter(setter(Builder::trainingJobDefinition)).constructor(HyperParameterTrainingJobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinition").build())
            .build();

    private static final SdkField<List<HyperParameterTrainingJobDefinition>> TRAINING_JOB_DEFINITIONS_FIELD = SdkField
            .<List<HyperParameterTrainingJobDefinition>> builder(MarshallingType.LIST)
            .memberName("TrainingJobDefinitions")
            .getter(getter(HyperParameterTuningJobSearchEntity::trainingJobDefinitions))
            .setter(setter(Builder::trainingJobDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HyperParameterTrainingJobDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(HyperParameterTrainingJobDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HyperParameterTuningJobStatus")
            .getter(getter(HyperParameterTuningJobSearchEntity::hyperParameterTuningJobStatusAsString))
            .setter(setter(Builder::hyperParameterTuningJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobStatus")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(HyperParameterTuningJobSearchEntity::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> HYPER_PARAMETER_TUNING_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("HyperParameterTuningEndTime")
            .getter(getter(HyperParameterTuningJobSearchEntity::hyperParameterTuningEndTime))
            .setter(setter(Builder::hyperParameterTuningEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningEndTime")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(HyperParameterTuningJobSearchEntity::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<TrainingJobStatusCounters> TRAINING_JOB_STATUS_COUNTERS_FIELD = SdkField
            .<TrainingJobStatusCounters> builder(MarshallingType.SDK_POJO).memberName("TrainingJobStatusCounters")
            .getter(getter(HyperParameterTuningJobSearchEntity::trainingJobStatusCounters))
            .setter(setter(Builder::trainingJobStatusCounters)).constructor(TrainingJobStatusCounters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatusCounters").build())
            .build();

    private static final SdkField<ObjectiveStatusCounters> OBJECTIVE_STATUS_COUNTERS_FIELD = SdkField
            .<ObjectiveStatusCounters> builder(MarshallingType.SDK_POJO).memberName("ObjectiveStatusCounters")
            .getter(getter(HyperParameterTuningJobSearchEntity::objectiveStatusCounters))
            .setter(setter(Builder::objectiveStatusCounters)).constructor(ObjectiveStatusCounters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectiveStatusCounters").build())
            .build();

    private static final SdkField<HyperParameterTrainingJobSummary> BEST_TRAINING_JOB_FIELD = SdkField
            .<HyperParameterTrainingJobSummary> builder(MarshallingType.SDK_POJO).memberName("BestTrainingJob")
            .getter(getter(HyperParameterTuningJobSearchEntity::bestTrainingJob)).setter(setter(Builder::bestTrainingJob))
            .constructor(HyperParameterTrainingJobSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestTrainingJob").build()).build();

    private static final SdkField<HyperParameterTrainingJobSummary> OVERALL_BEST_TRAINING_JOB_FIELD = SdkField
            .<HyperParameterTrainingJobSummary> builder(MarshallingType.SDK_POJO).memberName("OverallBestTrainingJob")
            .getter(getter(HyperParameterTuningJobSearchEntity::overallBestTrainingJob))
            .setter(setter(Builder::overallBestTrainingJob)).constructor(HyperParameterTrainingJobSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallBestTrainingJob").build())
            .build();

    private static final SdkField<HyperParameterTuningJobWarmStartConfig> WARM_START_CONFIG_FIELD = SdkField
            .<HyperParameterTuningJobWarmStartConfig> builder(MarshallingType.SDK_POJO).memberName("WarmStartConfig")
            .getter(getter(HyperParameterTuningJobSearchEntity::warmStartConfig)).setter(setter(Builder::warmStartConfig))
            .constructor(HyperParameterTuningJobWarmStartConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmStartConfig").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(HyperParameterTuningJobSearchEntity::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<HyperParameterTuningJobCompletionDetails> TUNING_JOB_COMPLETION_DETAILS_FIELD = SdkField
            .<HyperParameterTuningJobCompletionDetails> builder(MarshallingType.SDK_POJO)
            .memberName("TuningJobCompletionDetails")
            .getter(getter(HyperParameterTuningJobSearchEntity::tuningJobCompletionDetails))
            .setter(setter(Builder::tuningJobCompletionDetails))
            .constructor(HyperParameterTuningJobCompletionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJobCompletionDetails").build())
            .build();

    private static final SdkField<HyperParameterTuningJobConsumedResources> CONSUMED_RESOURCES_FIELD = SdkField
            .<HyperParameterTuningJobConsumedResources> builder(MarshallingType.SDK_POJO).memberName("ConsumedResources")
            .getter(getter(HyperParameterTuningJobSearchEntity::consumedResources)).setter(setter(Builder::consumedResources))
            .constructor(HyperParameterTuningJobConsumedResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedResources").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(HyperParameterTuningJobSearchEntity::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HYPER_PARAMETER_TUNING_JOB_NAME_FIELD, HYPER_PARAMETER_TUNING_JOB_ARN_FIELD, HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD,
            TRAINING_JOB_DEFINITION_FIELD, TRAINING_JOB_DEFINITIONS_FIELD, HYPER_PARAMETER_TUNING_JOB_STATUS_FIELD,
            CREATION_TIME_FIELD, HYPER_PARAMETER_TUNING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            TRAINING_JOB_STATUS_COUNTERS_FIELD, OBJECTIVE_STATUS_COUNTERS_FIELD, BEST_TRAINING_JOB_FIELD,
            OVERALL_BEST_TRAINING_JOB_FIELD, WARM_START_CONFIG_FIELD, FAILURE_REASON_FIELD, TUNING_JOB_COMPLETION_DETAILS_FIELD,
            CONSUMED_RESOURCES_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hyperParameterTuningJobName;

    private final String hyperParameterTuningJobArn;

    private final HyperParameterTuningJobConfig hyperParameterTuningJobConfig;

    private final HyperParameterTrainingJobDefinition trainingJobDefinition;

    private final List<HyperParameterTrainingJobDefinition> trainingJobDefinitions;

    private final String hyperParameterTuningJobStatus;

    private final Instant creationTime;

    private final Instant hyperParameterTuningEndTime;

    private final Instant lastModifiedTime;

    private final TrainingJobStatusCounters trainingJobStatusCounters;

    private final ObjectiveStatusCounters objectiveStatusCounters;

    private final HyperParameterTrainingJobSummary bestTrainingJob;

    private final HyperParameterTrainingJobSummary overallBestTrainingJob;

    private final HyperParameterTuningJobWarmStartConfig warmStartConfig;

    private final String failureReason;

    private final HyperParameterTuningJobCompletionDetails tuningJobCompletionDetails;

    private final HyperParameterTuningJobConsumedResources consumedResources;

    private final List<Tag> tags;

    private HyperParameterTuningJobSearchEntity(BuilderImpl builder) {
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.hyperParameterTuningJobArn = builder.hyperParameterTuningJobArn;
        this.hyperParameterTuningJobConfig = builder.hyperParameterTuningJobConfig;
        this.trainingJobDefinition = builder.trainingJobDefinition;
        this.trainingJobDefinitions = builder.trainingJobDefinitions;
        this.hyperParameterTuningJobStatus = builder.hyperParameterTuningJobStatus;
        this.creationTime = builder.creationTime;
        this.hyperParameterTuningEndTime = builder.hyperParameterTuningEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trainingJobStatusCounters = builder.trainingJobStatusCounters;
        this.objectiveStatusCounters = builder.objectiveStatusCounters;
        this.bestTrainingJob = builder.bestTrainingJob;
        this.overallBestTrainingJob = builder.overallBestTrainingJob;
        this.warmStartConfig = builder.warmStartConfig;
        this.failureReason = builder.failureReason;
        this.tuningJobCompletionDetails = builder.tuningJobCompletionDetails;
        this.consumedResources = builder.consumedResources;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of a hyperparameter tuning job.
     * </p>
     * 
     * @return The name of a hyperparameter tuning job.
     */
    public final String hyperParameterTuningJobName() {
        return hyperParameterTuningJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a hyperparameter tuning job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a hyperparameter tuning job.
     */
    public final String hyperParameterTuningJobArn() {
        return hyperParameterTuningJobArn;
    }

    /**
     * Returns the value of the HyperParameterTuningJobConfig property for this object.
     * 
     * @return The value of the HyperParameterTuningJobConfig property for this object.
     */
    public final HyperParameterTuningJobConfig hyperParameterTuningJobConfig() {
        return hyperParameterTuningJobConfig;
    }

    /**
     * Returns the value of the TrainingJobDefinition property for this object.
     * 
     * @return The value of the TrainingJobDefinition property for this object.
     */
    public final HyperParameterTrainingJobDefinition trainingJobDefinition() {
        return trainingJobDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrainingJobDefinitions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTrainingJobDefinitions() {
        return trainingJobDefinitions != null && !(trainingJobDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The job definitions included in a hyperparameter tuning job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrainingJobDefinitions} method.
     * </p>
     * 
     * @return The job definitions included in a hyperparameter tuning job.
     */
    public final List<HyperParameterTrainingJobDefinition> trainingJobDefinitions() {
        return trainingJobDefinitions;
    }

    /**
     * <p>
     * The status of a hyperparameter tuning job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hyperParameterTuningJobStatus} will return {@link HyperParameterTuningJobStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #hyperParameterTuningJobStatusAsString}.
     * </p>
     * 
     * @return The status of a hyperparameter tuning job.
     * @see HyperParameterTuningJobStatus
     */
    public final HyperParameterTuningJobStatus hyperParameterTuningJobStatus() {
        return HyperParameterTuningJobStatus.fromValue(hyperParameterTuningJobStatus);
    }

    /**
     * <p>
     * The status of a hyperparameter tuning job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #hyperParameterTuningJobStatus} will return {@link HyperParameterTuningJobStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #hyperParameterTuningJobStatusAsString}.
     * </p>
     * 
     * @return The status of a hyperparameter tuning job.
     * @see HyperParameterTuningJobStatus
     */
    public final String hyperParameterTuningJobStatusAsString() {
        return hyperParameterTuningJobStatus;
    }

    /**
     * <p>
     * The time that a hyperparameter tuning job was created.
     * </p>
     * 
     * @return The time that a hyperparameter tuning job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time that a hyperparameter tuning job ended.
     * </p>
     * 
     * @return The time that a hyperparameter tuning job ended.
     */
    public final Instant hyperParameterTuningEndTime() {
        return hyperParameterTuningEndTime;
    }

    /**
     * <p>
     * The time that a hyperparameter tuning job was last modified.
     * </p>
     * 
     * @return The time that a hyperparameter tuning job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the TrainingJobStatusCounters property for this object.
     * 
     * @return The value of the TrainingJobStatusCounters property for this object.
     */
    public final TrainingJobStatusCounters trainingJobStatusCounters() {
        return trainingJobStatusCounters;
    }

    /**
     * Returns the value of the ObjectiveStatusCounters property for this object.
     * 
     * @return The value of the ObjectiveStatusCounters property for this object.
     */
    public final ObjectiveStatusCounters objectiveStatusCounters() {
        return objectiveStatusCounters;
    }

    /**
     * Returns the value of the BestTrainingJob property for this object.
     * 
     * @return The value of the BestTrainingJob property for this object.
     */
    public final HyperParameterTrainingJobSummary bestTrainingJob() {
        return bestTrainingJob;
    }

    /**
     * Returns the value of the OverallBestTrainingJob property for this object.
     * 
     * @return The value of the OverallBestTrainingJob property for this object.
     */
    public final HyperParameterTrainingJobSummary overallBestTrainingJob() {
        return overallBestTrainingJob;
    }

    /**
     * Returns the value of the WarmStartConfig property for this object.
     * 
     * @return The value of the WarmStartConfig property for this object.
     */
    public final HyperParameterTuningJobWarmStartConfig warmStartConfig() {
        return warmStartConfig;
    }

    /**
     * <p>
     * The error that was created when a hyperparameter tuning job failed.
     * </p>
     * 
     * @return The error that was created when a hyperparameter tuning job failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Information about either a current or completed hyperparameter tuning job.
     * </p>
     * 
     * @return Information about either a current or completed hyperparameter tuning job.
     */
    public final HyperParameterTuningJobCompletionDetails tuningJobCompletionDetails() {
        return tuningJobCompletionDetails;
    }

    /**
     * <p>
     * The total amount of resources consumed by a hyperparameter tuning job.
     * </p>
     * 
     * @return The total amount of resources consumed by a hyperparameter tuning job.
     */
    public final HyperParameterTuningJobConsumedResources consumedResources() {
        return consumedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with a hyperparameter tuning job. For more information see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with a hyperparameter tuning job. For more information see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainingJobDefinitions() ? trainingJobDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(objectiveStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(bestTrainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(overallBestTrainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(warmStartConfig());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(tuningJobCompletionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(consumedResources());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobSearchEntity)) {
            return false;
        }
        HyperParameterTuningJobSearchEntity other = (HyperParameterTuningJobSearchEntity) obj;
        return Objects.equals(hyperParameterTuningJobName(), other.hyperParameterTuningJobName())
                && Objects.equals(hyperParameterTuningJobArn(), other.hyperParameterTuningJobArn())
                && Objects.equals(hyperParameterTuningJobConfig(), other.hyperParameterTuningJobConfig())
                && Objects.equals(trainingJobDefinition(), other.trainingJobDefinition())
                && hasTrainingJobDefinitions() == other.hasTrainingJobDefinitions()
                && Objects.equals(trainingJobDefinitions(), other.trainingJobDefinitions())
                && Objects.equals(hyperParameterTuningJobStatusAsString(), other.hyperParameterTuningJobStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(hyperParameterTuningEndTime(), other.hyperParameterTuningEndTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(trainingJobStatusCounters(), other.trainingJobStatusCounters())
                && Objects.equals(objectiveStatusCounters(), other.objectiveStatusCounters())
                && Objects.equals(bestTrainingJob(), other.bestTrainingJob())
                && Objects.equals(overallBestTrainingJob(), other.overallBestTrainingJob())
                && Objects.equals(warmStartConfig(), other.warmStartConfig())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(tuningJobCompletionDetails(), other.tuningJobCompletionDetails())
                && Objects.equals(consumedResources(), other.consumedResources()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HyperParameterTuningJobSearchEntity")
                .add("HyperParameterTuningJobName", hyperParameterTuningJobName())
                .add("HyperParameterTuningJobArn", hyperParameterTuningJobArn())
                .add("HyperParameterTuningJobConfig", hyperParameterTuningJobConfig())
                .add("TrainingJobDefinition", trainingJobDefinition())
                .add("TrainingJobDefinitions", hasTrainingJobDefinitions() ? trainingJobDefinitions() : null)
                .add("HyperParameterTuningJobStatus", hyperParameterTuningJobStatusAsString())
                .add("CreationTime", creationTime()).add("HyperParameterTuningEndTime", hyperParameterTuningEndTime())
                .add("LastModifiedTime", lastModifiedTime()).add("TrainingJobStatusCounters", trainingJobStatusCounters())
                .add("ObjectiveStatusCounters", objectiveStatusCounters()).add("BestTrainingJob", bestTrainingJob())
                .add("OverallBestTrainingJob", overallBestTrainingJob()).add("WarmStartConfig", warmStartConfig())
                .add("FailureReason", failureReason()).add("TuningJobCompletionDetails", tuningJobCompletionDetails())
                .add("ConsumedResources", consumedResources()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HyperParameterTuningJobName":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobName()));
        case "HyperParameterTuningJobArn":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobArn()));
        case "HyperParameterTuningJobConfig":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobConfig()));
        case "TrainingJobDefinition":
            return Optional.ofNullable(clazz.cast(trainingJobDefinition()));
        case "TrainingJobDefinitions":
            return Optional.ofNullable(clazz.cast(trainingJobDefinitions()));
        case "HyperParameterTuningJobStatus":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "HyperParameterTuningEndTime":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningEndTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "TrainingJobStatusCounters":
            return Optional.ofNullable(clazz.cast(trainingJobStatusCounters()));
        case "ObjectiveStatusCounters":
            return Optional.ofNullable(clazz.cast(objectiveStatusCounters()));
        case "BestTrainingJob":
            return Optional.ofNullable(clazz.cast(bestTrainingJob()));
        case "OverallBestTrainingJob":
            return Optional.ofNullable(clazz.cast(overallBestTrainingJob()));
        case "WarmStartConfig":
            return Optional.ofNullable(clazz.cast(warmStartConfig()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "TuningJobCompletionDetails":
            return Optional.ofNullable(clazz.cast(tuningJobCompletionDetails()));
        case "ConsumedResources":
            return Optional.ofNullable(clazz.cast(consumedResources()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobSearchEntity, T> g) {
        return obj -> g.apply((HyperParameterTuningJobSearchEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterTuningJobSearchEntity> {
        /**
         * <p>
         * The name of a hyperparameter tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobName
         *        The name of a hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobName(String hyperParameterTuningJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a hyperparameter tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobArn
         *        The Amazon Resource Name (ARN) of a hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn);

        /**
         * Sets the value of the HyperParameterTuningJobConfig property for this object.
         *
         * @param hyperParameterTuningJobConfig
         *        The new value for the HyperParameterTuningJobConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig hyperParameterTuningJobConfig);

        /**
         * Sets the value of the HyperParameterTuningJobConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HyperParameterTuningJobConfig.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTuningJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #hyperParameterTuningJobConfig(HyperParameterTuningJobConfig)}.
         * 
         * @param hyperParameterTuningJobConfig
         *        a consumer that will call methods on {@link HyperParameterTuningJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperParameterTuningJobConfig(HyperParameterTuningJobConfig)
         */
        default Builder hyperParameterTuningJobConfig(
                Consumer<HyperParameterTuningJobConfig.Builder> hyperParameterTuningJobConfig) {
            return hyperParameterTuningJobConfig(HyperParameterTuningJobConfig.builder()
                    .applyMutation(hyperParameterTuningJobConfig).build());
        }

        /**
         * Sets the value of the TrainingJobDefinition property for this object.
         *
         * @param trainingJobDefinition
         *        The new value for the TrainingJobDefinition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobDefinition(HyperParameterTrainingJobDefinition trainingJobDefinition);

        /**
         * Sets the value of the TrainingJobDefinition property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link HyperParameterTrainingJobDefinition.Builder} avoiding the need to create one manually via
         * {@link HyperParameterTrainingJobDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTrainingJobDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #trainingJobDefinition(HyperParameterTrainingJobDefinition)}.
         * 
         * @param trainingJobDefinition
         *        a consumer that will call methods on {@link HyperParameterTrainingJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobDefinition(HyperParameterTrainingJobDefinition)
         */
        default Builder trainingJobDefinition(Consumer<HyperParameterTrainingJobDefinition.Builder> trainingJobDefinition) {
            return trainingJobDefinition(HyperParameterTrainingJobDefinition.builder().applyMutation(trainingJobDefinition)
                    .build());
        }

        /**
         * <p>
         * The job definitions included in a hyperparameter tuning job.
         * </p>
         * 
         * @param trainingJobDefinitions
         *        The job definitions included in a hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition> trainingJobDefinitions);

        /**
         * <p>
         * The job definitions included in a hyperparameter tuning job.
         * </p>
         * 
         * @param trainingJobDefinitions
         *        The job definitions included in a hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobDefinitions(HyperParameterTrainingJobDefinition... trainingJobDefinitions);

        /**
         * <p>
         * The job definitions included in a hyperparameter tuning job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #trainingJobDefinitions(List<HyperParameterTrainingJobDefinition>)}.
         * 
         * @param trainingJobDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobDefinitions(java.util.Collection<HyperParameterTrainingJobDefinition>)
         */
        Builder trainingJobDefinitions(Consumer<HyperParameterTrainingJobDefinition.Builder>... trainingJobDefinitions);

        /**
         * <p>
         * The status of a hyperparameter tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobStatus
         *        The status of a hyperparameter tuning job.
         * @see HyperParameterTuningJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobStatus
         */
        Builder hyperParameterTuningJobStatus(String hyperParameterTuningJobStatus);

        /**
         * <p>
         * The status of a hyperparameter tuning job.
         * </p>
         * 
         * @param hyperParameterTuningJobStatus
         *        The status of a hyperparameter tuning job.
         * @see HyperParameterTuningJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterTuningJobStatus
         */
        Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus hyperParameterTuningJobStatus);

        /**
         * <p>
         * The time that a hyperparameter tuning job was created.
         * </p>
         * 
         * @param creationTime
         *        The time that a hyperparameter tuning job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time that a hyperparameter tuning job ended.
         * </p>
         * 
         * @param hyperParameterTuningEndTime
         *        The time that a hyperparameter tuning job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningEndTime(Instant hyperParameterTuningEndTime);

        /**
         * <p>
         * The time that a hyperparameter tuning job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time that a hyperparameter tuning job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the TrainingJobStatusCounters property for this object.
         *
         * @param trainingJobStatusCounters
         *        The new value for the TrainingJobStatusCounters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobStatusCounters(TrainingJobStatusCounters trainingJobStatusCounters);

        /**
         * Sets the value of the TrainingJobStatusCounters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TrainingJobStatusCounters.Builder}
         * avoiding the need to create one manually via {@link TrainingJobStatusCounters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingJobStatusCounters.Builder#build()} is called immediately
         * and its result is passed to {@link #trainingJobStatusCounters(TrainingJobStatusCounters)}.
         * 
         * @param trainingJobStatusCounters
         *        a consumer that will call methods on {@link TrainingJobStatusCounters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobStatusCounters(TrainingJobStatusCounters)
         */
        default Builder trainingJobStatusCounters(Consumer<TrainingJobStatusCounters.Builder> trainingJobStatusCounters) {
            return trainingJobStatusCounters(TrainingJobStatusCounters.builder().applyMutation(trainingJobStatusCounters).build());
        }

        /**
         * Sets the value of the ObjectiveStatusCounters property for this object.
         *
         * @param objectiveStatusCounters
         *        The new value for the ObjectiveStatusCounters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectiveStatusCounters(ObjectiveStatusCounters objectiveStatusCounters);

        /**
         * Sets the value of the ObjectiveStatusCounters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ObjectiveStatusCounters.Builder} avoiding
         * the need to create one manually via {@link ObjectiveStatusCounters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectiveStatusCounters.Builder#build()} is called immediately
         * and its result is passed to {@link #objectiveStatusCounters(ObjectiveStatusCounters)}.
         * 
         * @param objectiveStatusCounters
         *        a consumer that will call methods on {@link ObjectiveStatusCounters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectiveStatusCounters(ObjectiveStatusCounters)
         */
        default Builder objectiveStatusCounters(Consumer<ObjectiveStatusCounters.Builder> objectiveStatusCounters) {
            return objectiveStatusCounters(ObjectiveStatusCounters.builder().applyMutation(objectiveStatusCounters).build());
        }

        /**
         * Sets the value of the BestTrainingJob property for this object.
         *
         * @param bestTrainingJob
         *        The new value for the BestTrainingJob property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestTrainingJob(HyperParameterTrainingJobSummary bestTrainingJob);

        /**
         * Sets the value of the BestTrainingJob property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HyperParameterTrainingJobSummary.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTrainingJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTrainingJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #bestTrainingJob(HyperParameterTrainingJobSummary)}.
         * 
         * @param bestTrainingJob
         *        a consumer that will call methods on {@link HyperParameterTrainingJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bestTrainingJob(HyperParameterTrainingJobSummary)
         */
        default Builder bestTrainingJob(Consumer<HyperParameterTrainingJobSummary.Builder> bestTrainingJob) {
            return bestTrainingJob(HyperParameterTrainingJobSummary.builder().applyMutation(bestTrainingJob).build());
        }

        /**
         * Sets the value of the OverallBestTrainingJob property for this object.
         *
         * @param overallBestTrainingJob
         *        The new value for the OverallBestTrainingJob property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overallBestTrainingJob(HyperParameterTrainingJobSummary overallBestTrainingJob);

        /**
         * Sets the value of the OverallBestTrainingJob property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HyperParameterTrainingJobSummary.Builder}
         * avoiding the need to create one manually via {@link HyperParameterTrainingJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTrainingJobSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #overallBestTrainingJob(HyperParameterTrainingJobSummary)}.
         * 
         * @param overallBestTrainingJob
         *        a consumer that will call methods on {@link HyperParameterTrainingJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overallBestTrainingJob(HyperParameterTrainingJobSummary)
         */
        default Builder overallBestTrainingJob(Consumer<HyperParameterTrainingJobSummary.Builder> overallBestTrainingJob) {
            return overallBestTrainingJob(HyperParameterTrainingJobSummary.builder().applyMutation(overallBestTrainingJob)
                    .build());
        }

        /**
         * Sets the value of the WarmStartConfig property for this object.
         *
         * @param warmStartConfig
         *        The new value for the WarmStartConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig warmStartConfig);

        /**
         * Sets the value of the WarmStartConfig property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link HyperParameterTuningJobWarmStartConfig.Builder} avoiding the need to create one manually via
         * {@link HyperParameterTuningJobWarmStartConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobWarmStartConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #warmStartConfig(HyperParameterTuningJobWarmStartConfig)}.
         * 
         * @param warmStartConfig
         *        a consumer that will call methods on {@link HyperParameterTuningJobWarmStartConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmStartConfig(HyperParameterTuningJobWarmStartConfig)
         */
        default Builder warmStartConfig(Consumer<HyperParameterTuningJobWarmStartConfig.Builder> warmStartConfig) {
            return warmStartConfig(HyperParameterTuningJobWarmStartConfig.builder().applyMutation(warmStartConfig).build());
        }

        /**
         * <p>
         * The error that was created when a hyperparameter tuning job failed.
         * </p>
         * 
         * @param failureReason
         *        The error that was created when a hyperparameter tuning job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Information about either a current or completed hyperparameter tuning job.
         * </p>
         * 
         * @param tuningJobCompletionDetails
         *        Information about either a current or completed hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuningJobCompletionDetails(HyperParameterTuningJobCompletionDetails tuningJobCompletionDetails);

        /**
         * <p>
         * Information about either a current or completed hyperparameter tuning job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link HyperParameterTuningJobCompletionDetails.Builder} avoiding the need to create one manually via
         * {@link HyperParameterTuningJobCompletionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobCompletionDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #tuningJobCompletionDetails(HyperParameterTuningJobCompletionDetails)}.
         * 
         * @param tuningJobCompletionDetails
         *        a consumer that will call methods on {@link HyperParameterTuningJobCompletionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tuningJobCompletionDetails(HyperParameterTuningJobCompletionDetails)
         */
        default Builder tuningJobCompletionDetails(
                Consumer<HyperParameterTuningJobCompletionDetails.Builder> tuningJobCompletionDetails) {
            return tuningJobCompletionDetails(HyperParameterTuningJobCompletionDetails.builder()
                    .applyMutation(tuningJobCompletionDetails).build());
        }

        /**
         * <p>
         * The total amount of resources consumed by a hyperparameter tuning job.
         * </p>
         * 
         * @param consumedResources
         *        The total amount of resources consumed by a hyperparameter tuning job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedResources(HyperParameterTuningJobConsumedResources consumedResources);

        /**
         * <p>
         * The total amount of resources consumed by a hyperparameter tuning job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link HyperParameterTuningJobConsumedResources.Builder} avoiding the need to create one manually via
         * {@link HyperParameterTuningJobConsumedResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperParameterTuningJobConsumedResources.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #consumedResources(HyperParameterTuningJobConsumedResources)}.
         * 
         * @param consumedResources
         *        a consumer that will call methods on {@link HyperParameterTuningJobConsumedResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedResources(HyperParameterTuningJobConsumedResources)
         */
        default Builder consumedResources(Consumer<HyperParameterTuningJobConsumedResources.Builder> consumedResources) {
            return consumedResources(HyperParameterTuningJobConsumedResources.builder().applyMutation(consumedResources).build());
        }

        /**
         * <p>
         * The tags associated with a hyperparameter tuning job. For more information see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags associated with a hyperparameter tuning job. For more information see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with a hyperparameter tuning job. For more information see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags associated with a hyperparameter tuning job. For more information see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with a hyperparameter tuning job. For more information see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String hyperParameterTuningJobName;

        private String hyperParameterTuningJobArn;

        private HyperParameterTuningJobConfig hyperParameterTuningJobConfig;

        private HyperParameterTrainingJobDefinition trainingJobDefinition;

        private List<HyperParameterTrainingJobDefinition> trainingJobDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String hyperParameterTuningJobStatus;

        private Instant creationTime;

        private Instant hyperParameterTuningEndTime;

        private Instant lastModifiedTime;

        private TrainingJobStatusCounters trainingJobStatusCounters;

        private ObjectiveStatusCounters objectiveStatusCounters;

        private HyperParameterTrainingJobSummary bestTrainingJob;

        private HyperParameterTrainingJobSummary overallBestTrainingJob;

        private HyperParameterTuningJobWarmStartConfig warmStartConfig;

        private String failureReason;

        private HyperParameterTuningJobCompletionDetails tuningJobCompletionDetails;

        private HyperParameterTuningJobConsumedResources consumedResources;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobSearchEntity model) {
            hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            hyperParameterTuningJobArn(model.hyperParameterTuningJobArn);
            hyperParameterTuningJobConfig(model.hyperParameterTuningJobConfig);
            trainingJobDefinition(model.trainingJobDefinition);
            trainingJobDefinitions(model.trainingJobDefinitions);
            hyperParameterTuningJobStatus(model.hyperParameterTuningJobStatus);
            creationTime(model.creationTime);
            hyperParameterTuningEndTime(model.hyperParameterTuningEndTime);
            lastModifiedTime(model.lastModifiedTime);
            trainingJobStatusCounters(model.trainingJobStatusCounters);
            objectiveStatusCounters(model.objectiveStatusCounters);
            bestTrainingJob(model.bestTrainingJob);
            overallBestTrainingJob(model.overallBestTrainingJob);
            warmStartConfig(model.warmStartConfig);
            failureReason(model.failureReason);
            tuningJobCompletionDetails(model.tuningJobCompletionDetails);
            consumedResources(model.consumedResources);
            tags(model.tags);
        }

        public final String getHyperParameterTuningJobName() {
            return hyperParameterTuningJobName;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        @Override
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final String getHyperParameterTuningJobArn() {
            return hyperParameterTuningJobArn;
        }

        public final void setHyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
        }

        @Override
        public final Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
            return this;
        }

        public final HyperParameterTuningJobConfig.Builder getHyperParameterTuningJobConfig() {
            return hyperParameterTuningJobConfig != null ? hyperParameterTuningJobConfig.toBuilder() : null;
        }

        public final void setHyperParameterTuningJobConfig(HyperParameterTuningJobConfig.BuilderImpl hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig != null ? hyperParameterTuningJobConfig.build()
                    : null;
        }

        @Override
        public final Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig;
            return this;
        }

        public final HyperParameterTrainingJobDefinition.Builder getTrainingJobDefinition() {
            return trainingJobDefinition != null ? trainingJobDefinition.toBuilder() : null;
        }

        public final void setTrainingJobDefinition(HyperParameterTrainingJobDefinition.BuilderImpl trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition != null ? trainingJobDefinition.build() : null;
        }

        @Override
        public final Builder trainingJobDefinition(HyperParameterTrainingJobDefinition trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition;
            return this;
        }

        public final List<HyperParameterTrainingJobDefinition.Builder> getTrainingJobDefinitions() {
            List<HyperParameterTrainingJobDefinition.Builder> result = HyperParameterTrainingJobDefinitionsCopier
                    .copyToBuilder(this.trainingJobDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingJobDefinitions(
                Collection<HyperParameterTrainingJobDefinition.BuilderImpl> trainingJobDefinitions) {
            this.trainingJobDefinitions = HyperParameterTrainingJobDefinitionsCopier.copyFromBuilder(trainingJobDefinitions);
        }

        @Override
        public final Builder trainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition> trainingJobDefinitions) {
            this.trainingJobDefinitions = HyperParameterTrainingJobDefinitionsCopier.copy(trainingJobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobDefinitions(HyperParameterTrainingJobDefinition... trainingJobDefinitions) {
            trainingJobDefinitions(Arrays.asList(trainingJobDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobDefinitions(
                Consumer<HyperParameterTrainingJobDefinition.Builder>... trainingJobDefinitions) {
            trainingJobDefinitions(Stream.of(trainingJobDefinitions)
                    .map(c -> HyperParameterTrainingJobDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getHyperParameterTuningJobStatus() {
            return hyperParameterTuningJobStatus;
        }

        public final void setHyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
            return this;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus(hyperParameterTuningJobStatus == null ? null : hyperParameterTuningJobStatus
                    .toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getHyperParameterTuningEndTime() {
            return hyperParameterTuningEndTime;
        }

        public final void setHyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
        }

        @Override
        public final Builder hyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final TrainingJobStatusCounters.Builder getTrainingJobStatusCounters() {
            return trainingJobStatusCounters != null ? trainingJobStatusCounters.toBuilder() : null;
        }

        public final void setTrainingJobStatusCounters(TrainingJobStatusCounters.BuilderImpl trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters != null ? trainingJobStatusCounters.build() : null;
        }

        @Override
        public final Builder trainingJobStatusCounters(TrainingJobStatusCounters trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters;
            return this;
        }

        public final ObjectiveStatusCounters.Builder getObjectiveStatusCounters() {
            return objectiveStatusCounters != null ? objectiveStatusCounters.toBuilder() : null;
        }

        public final void setObjectiveStatusCounters(ObjectiveStatusCounters.BuilderImpl objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters != null ? objectiveStatusCounters.build() : null;
        }

        @Override
        public final Builder objectiveStatusCounters(ObjectiveStatusCounters objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters;
            return this;
        }

        public final HyperParameterTrainingJobSummary.Builder getBestTrainingJob() {
            return bestTrainingJob != null ? bestTrainingJob.toBuilder() : null;
        }

        public final void setBestTrainingJob(HyperParameterTrainingJobSummary.BuilderImpl bestTrainingJob) {
            this.bestTrainingJob = bestTrainingJob != null ? bestTrainingJob.build() : null;
        }

        @Override
        public final Builder bestTrainingJob(HyperParameterTrainingJobSummary bestTrainingJob) {
            this.bestTrainingJob = bestTrainingJob;
            return this;
        }

        public final HyperParameterTrainingJobSummary.Builder getOverallBestTrainingJob() {
            return overallBestTrainingJob != null ? overallBestTrainingJob.toBuilder() : null;
        }

        public final void setOverallBestTrainingJob(HyperParameterTrainingJobSummary.BuilderImpl overallBestTrainingJob) {
            this.overallBestTrainingJob = overallBestTrainingJob != null ? overallBestTrainingJob.build() : null;
        }

        @Override
        public final Builder overallBestTrainingJob(HyperParameterTrainingJobSummary overallBestTrainingJob) {
            this.overallBestTrainingJob = overallBestTrainingJob;
            return this;
        }

        public final HyperParameterTuningJobWarmStartConfig.Builder getWarmStartConfig() {
            return warmStartConfig != null ? warmStartConfig.toBuilder() : null;
        }

        public final void setWarmStartConfig(HyperParameterTuningJobWarmStartConfig.BuilderImpl warmStartConfig) {
            this.warmStartConfig = warmStartConfig != null ? warmStartConfig.build() : null;
        }

        @Override
        public final Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig warmStartConfig) {
            this.warmStartConfig = warmStartConfig;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final HyperParameterTuningJobCompletionDetails.Builder getTuningJobCompletionDetails() {
            return tuningJobCompletionDetails != null ? tuningJobCompletionDetails.toBuilder() : null;
        }

        public final void setTuningJobCompletionDetails(
                HyperParameterTuningJobCompletionDetails.BuilderImpl tuningJobCompletionDetails) {
            this.tuningJobCompletionDetails = tuningJobCompletionDetails != null ? tuningJobCompletionDetails.build() : null;
        }

        @Override
        public final Builder tuningJobCompletionDetails(HyperParameterTuningJobCompletionDetails tuningJobCompletionDetails) {
            this.tuningJobCompletionDetails = tuningJobCompletionDetails;
            return this;
        }

        public final HyperParameterTuningJobConsumedResources.Builder getConsumedResources() {
            return consumedResources != null ? consumedResources.toBuilder() : null;
        }

        public final void setConsumedResources(HyperParameterTuningJobConsumedResources.BuilderImpl consumedResources) {
            this.consumedResources = consumedResources != null ? consumedResources.build() : null;
        }

        @Override
        public final Builder consumedResources(HyperParameterTuningJobConsumedResources consumedResources) {
            this.consumedResources = consumedResources;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public HyperParameterTuningJobSearchEntity build() {
            return new HyperParameterTuningJobSearchEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
