/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of a trial as returned by the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Trial implements SdkPojo, Serializable, ToCopyableBuilder<Trial.Builder, Trial> {
    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialName").getter(getter(Trial::trialName)).setter(setter(Builder::trialName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()).build();

    private static final SdkField<String> TRIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialArn").getter(getter(Trial::trialArn)).setter(setter(Builder::trialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(Trial::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExperimentName").getter(getter(Trial::experimentName)).setter(setter(Builder::experimentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()).build();

    private static final SdkField<TrialSource> SOURCE_FIELD = SdkField.<TrialSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(Trial::source)).setter(setter(Builder::source)).constructor(TrialSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Trial::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(Trial::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(Trial::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(Trial::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField
            .<MetadataProperties> builder(MarshallingType.SDK_POJO).memberName("MetadataProperties")
            .getter(getter(Trial::metadataProperties)).setter(setter(Builder::metadataProperties))
            .constructor(MetadataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Trial::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TrialComponentSimpleSummary>> TRIAL_COMPONENT_SUMMARIES_FIELD = SdkField
            .<List<TrialComponentSimpleSummary>> builder(MarshallingType.LIST)
            .memberName("TrialComponentSummaries")
            .getter(getter(Trial::trialComponentSummaries))
            .setter(setter(Builder::trialComponentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrialComponentSimpleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentSimpleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_NAME_FIELD,
            TRIAL_ARN_FIELD, DISPLAY_NAME_FIELD, EXPERIMENT_NAME_FIELD, SOURCE_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, METADATA_PROPERTIES_FIELD, TAGS_FIELD,
            TRIAL_COMPONENT_SUMMARIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trialName;

    private final String trialArn;

    private final String displayName;

    private final String experimentName;

    private final TrialSource source;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final MetadataProperties metadataProperties;

    private final List<Tag> tags;

    private final List<TrialComponentSimpleSummary> trialComponentSummaries;

    private Trial(BuilderImpl builder) {
        this.trialName = builder.trialName;
        this.trialArn = builder.trialArn;
        this.displayName = builder.displayName;
        this.experimentName = builder.experimentName;
        this.source = builder.source;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.metadataProperties = builder.metadataProperties;
        this.tags = builder.tags;
        this.trialComponentSummaries = builder.trialComponentSummaries;
    }

    /**
     * <p>
     * The name of the trial.
     * </p>
     * 
     * @return The name of the trial.
     */
    public final String trialName() {
        return trialName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trial.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trial.
     */
    public final String trialArn() {
        return trialArn;
    }

    /**
     * <p>
     * The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is
     * displayed.
     * </p>
     * 
     * @return The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code>
     *         is displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The name of the experiment the trial is part of.
     * </p>
     * 
     * @return The name of the experiment the trial is part of.
     */
    public final String experimentName() {
        return experimentName;
    }

    /**
     * Returns the value of the Source property for this object.
     * 
     * @return The value of the Source property for this object.
     */
    public final TrialSource source() {
        return source;
    }

    /**
     * <p>
     * When the trial was created.
     * </p>
     * 
     * @return When the trial was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Who created the trial.
     * </p>
     * 
     * @return Who created the trial.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Who last modified the trial.
     * </p>
     * 
     * @return Who last modified the trial.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * Returns the value of the MetadataProperties property for this object.
     * 
     * @return The value of the MetadataProperties property for this object.
     */
    public final MetadataProperties metadataProperties() {
        return metadataProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags that are associated with the trial. You can use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search on the
     * tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags that are associated with the trial. You can use <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search
     *         on the tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrialComponentSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTrialComponentSummaries() {
        return trialComponentSummaries != null && !(trialComponentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the components associated with the trial. For each component, a summary of the component's properties
     * is included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrialComponentSummaries} method.
     * </p>
     * 
     * @return A list of the components associated with the trial. For each component, a summary of the component's
     *         properties is included.
     */
    public final List<TrialComponentSimpleSummary> trialComponentSummaries() {
        return trialComponentSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trialName());
        hashCode = 31 * hashCode + Objects.hashCode(trialArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTrialComponentSummaries() ? trialComponentSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trial)) {
            return false;
        }
        Trial other = (Trial) obj;
        return Objects.equals(trialName(), other.trialName()) && Objects.equals(trialArn(), other.trialArn())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(experimentName(), other.experimentName())
                && Objects.equals(source(), other.source()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(metadataProperties(), other.metadataProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasTrialComponentSummaries() == other.hasTrialComponentSummaries()
                && Objects.equals(trialComponentSummaries(), other.trialComponentSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Trial").add("TrialName", trialName()).add("TrialArn", trialArn())
                .add("DisplayName", displayName()).add("ExperimentName", experimentName()).add("Source", source())
                .add("CreationTime", creationTime()).add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("MetadataProperties", metadataProperties())
                .add("Tags", hasTags() ? tags() : null)
                .add("TrialComponentSummaries", hasTrialComponentSummaries() ? trialComponentSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialName":
            return Optional.ofNullable(clazz.cast(trialName()));
        case "TrialArn":
            return Optional.ofNullable(clazz.cast(trialArn()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ExperimentName":
            return Optional.ofNullable(clazz.cast(experimentName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "MetadataProperties":
            return Optional.ofNullable(clazz.cast(metadataProperties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TrialComponentSummaries":
            return Optional.ofNullable(clazz.cast(trialComponentSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trial, T> g) {
        return obj -> g.apply((Trial) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Trial> {
        /**
         * <p>
         * The name of the trial.
         * </p>
         * 
         * @param trialName
         *        The name of the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialName(String trialName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trial.
         * </p>
         * 
         * @param trialArn
         *        The Amazon Resource Name (ARN) of the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialArn(String trialArn);

        /**
         * <p>
         * The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is
         * displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the trial as displayed. If <code>DisplayName</code> isn't specified,
         *        <code>TrialName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The name of the experiment the trial is part of.
         * </p>
         * 
         * @param experimentName
         *        The name of the experiment the trial is part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentName(String experimentName);

        /**
         * Sets the value of the Source property for this object.
         *
         * @param source
         *        The new value for the Source property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TrialSource source);

        /**
         * Sets the value of the Source property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TrialSource.Builder} avoiding the need to
         * create one manually via {@link TrialSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrialSource.Builder#build()} is called immediately and its result
         * is passed to {@link #source(TrialSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TrialSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TrialSource)
         */
        default Builder source(Consumer<TrialSource.Builder> source) {
            return source(TrialSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * When the trial was created.
         * </p>
         * 
         * @param creationTime
         *        When the trial was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Who created the trial.
         * </p>
         * 
         * @param createdBy
         *        Who created the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * <p>
         * Who created the trial.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * Who last modified the trial.
         * </p>
         * 
         * @param lastModifiedTime
         *        Who last modified the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * @param metadataProperties
         *        The new value for the MetadataProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProperties(MetadataProperties metadataProperties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MetadataProperties.Builder} avoiding the
         * need to create one manually via {@link MetadataProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataProperties(MetadataProperties)}.
         * 
         * @param metadataProperties
         *        a consumer that will call methods on {@link MetadataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataProperties(MetadataProperties)
         */
        default Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return metadataProperties(MetadataProperties.builder().applyMutation(metadataProperties).build());
        }

        /**
         * <p>
         * The list of tags that are associated with the trial. You can use <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search on
         * the tags.
         * </p>
         * 
         * @param tags
         *        The list of tags that are associated with the trial. You can use <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to
         *        search on the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags that are associated with the trial. You can use <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search on
         * the tags.
         * </p>
         * 
         * @param tags
         *        The list of tags that are associated with the trial. You can use <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to
         *        search on the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags that are associated with the trial. You can use <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search on
         * the tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A list of the components associated with the trial. For each component, a summary of the component's
         * properties is included.
         * </p>
         * 
         * @param trialComponentSummaries
         *        A list of the components associated with the trial. For each component, a summary of the component's
         *        properties is included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentSummaries(Collection<TrialComponentSimpleSummary> trialComponentSummaries);

        /**
         * <p>
         * A list of the components associated with the trial. For each component, a summary of the component's
         * properties is included.
         * </p>
         * 
         * @param trialComponentSummaries
         *        A list of the components associated with the trial. For each component, a summary of the component's
         *        properties is included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentSummaries(TrialComponentSimpleSummary... trialComponentSummaries);

        /**
         * <p>
         * A list of the components associated with the trial. For each component, a summary of the component's
         * properties is included.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #trialComponentSummaries(List<TrialComponentSimpleSummary>)}.
         * 
         * @param trialComponentSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.TrialComponentSimpleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialComponentSummaries(java.util.Collection<TrialComponentSimpleSummary>)
         */
        Builder trialComponentSummaries(Consumer<TrialComponentSimpleSummary.Builder>... trialComponentSummaries);
    }

    static final class BuilderImpl implements Builder {
        private String trialName;

        private String trialArn;

        private String displayName;

        private String experimentName;

        private TrialSource source;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private MetadataProperties metadataProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<TrialComponentSimpleSummary> trialComponentSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Trial model) {
            trialName(model.trialName);
            trialArn(model.trialArn);
            displayName(model.displayName);
            experimentName(model.experimentName);
            source(model.source);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            metadataProperties(model.metadataProperties);
            tags(model.tags);
            trialComponentSummaries(model.trialComponentSummaries);
        }

        public final String getTrialName() {
            return trialName;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        @Override
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final String getTrialArn() {
            return trialArn;
        }

        public final void setTrialArn(String trialArn) {
            this.trialArn = trialArn;
        }

        @Override
        public final Builder trialArn(String trialArn) {
            this.trialArn = trialArn;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getExperimentName() {
            return experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final TrialSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(TrialSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TrialSource source) {
            this.source = source;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return metadataProperties != null ? metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TrialComponentSimpleSummary.Builder> getTrialComponentSummaries() {
            List<TrialComponentSimpleSummary.Builder> result = TrialComponentSimpleSummariesCopier
                    .copyToBuilder(this.trialComponentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrialComponentSummaries(Collection<TrialComponentSimpleSummary.BuilderImpl> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSimpleSummariesCopier.copyFromBuilder(trialComponentSummaries);
        }

        @Override
        public final Builder trialComponentSummaries(Collection<TrialComponentSimpleSummary> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSimpleSummariesCopier.copy(trialComponentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(TrialComponentSimpleSummary... trialComponentSummaries) {
            trialComponentSummaries(Arrays.asList(trialComponentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(Consumer<TrialComponentSimpleSummary.Builder>... trialComponentSummaries) {
            trialComponentSummaries(Stream.of(trialComponentSummaries)
                    .map(c -> TrialComponentSimpleSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Trial build() {
            return new Trial(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
