/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMobileDeviceAccessRuleResponse extends WorkMailResponse implements
        ToCopyableBuilder<CreateMobileDeviceAccessRuleResponse.Builder, CreateMobileDeviceAccessRuleResponse> {
    private static final SdkField<String> MOBILE_DEVICE_ACCESS_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MobileDeviceAccessRuleId")
            .getter(getter(CreateMobileDeviceAccessRuleResponse::mobileDeviceAccessRuleId))
            .setter(setter(Builder::mobileDeviceAccessRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobileDeviceAccessRuleId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MOBILE_DEVICE_ACCESS_RULE_ID_FIELD));

    private final String mobileDeviceAccessRuleId;

    private CreateMobileDeviceAccessRuleResponse(BuilderImpl builder) {
        super(builder);
        this.mobileDeviceAccessRuleId = builder.mobileDeviceAccessRuleId;
    }

    /**
     * <p>
     * The identifier for the newly created mobile device access rule.
     * </p>
     * 
     * @return The identifier for the newly created mobile device access rule.
     */
    public final String mobileDeviceAccessRuleId() {
        return mobileDeviceAccessRuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mobileDeviceAccessRuleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMobileDeviceAccessRuleResponse)) {
            return false;
        }
        CreateMobileDeviceAccessRuleResponse other = (CreateMobileDeviceAccessRuleResponse) obj;
        return Objects.equals(mobileDeviceAccessRuleId(), other.mobileDeviceAccessRuleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMobileDeviceAccessRuleResponse")
                .add("MobileDeviceAccessRuleId", mobileDeviceAccessRuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MobileDeviceAccessRuleId":
            return Optional.ofNullable(clazz.cast(mobileDeviceAccessRuleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMobileDeviceAccessRuleResponse, T> g) {
        return obj -> g.apply((CreateMobileDeviceAccessRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMobileDeviceAccessRuleResponse> {
        /**
         * <p>
         * The identifier for the newly created mobile device access rule.
         * </p>
         * 
         * @param mobileDeviceAccessRuleId
         *        The identifier for the newly created mobile device access rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobileDeviceAccessRuleId(String mobileDeviceAccessRuleId);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String mobileDeviceAccessRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMobileDeviceAccessRuleResponse model) {
            super(model);
            mobileDeviceAccessRuleId(model.mobileDeviceAccessRuleId);
        }

        public final String getMobileDeviceAccessRuleId() {
            return mobileDeviceAccessRuleId;
        }

        public final void setMobileDeviceAccessRuleId(String mobileDeviceAccessRuleId) {
            this.mobileDeviceAccessRuleId = mobileDeviceAccessRuleId;
        }

        @Override
        public final Builder mobileDeviceAccessRuleId(String mobileDeviceAccessRuleId) {
            this.mobileDeviceAccessRuleId = mobileDeviceAccessRuleId;
            return this;
        }

        @Override
        public CreateMobileDeviceAccessRuleResponse build() {
            return new CreateMobileDeviceAccessRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
