/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImpersonationRoleEffectRequest extends WorkMailRequest implements
        ToCopyableBuilder<GetImpersonationRoleEffectRequest.Builder, GetImpersonationRoleEffectRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(GetImpersonationRoleEffectRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> IMPERSONATION_ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImpersonationRoleId").getter(getter(GetImpersonationRoleEffectRequest::impersonationRoleId))
            .setter(setter(Builder::impersonationRoleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpersonationRoleId").build())
            .build();

    private static final SdkField<String> TARGET_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetUser").getter(getter(GetImpersonationRoleEffectRequest::targetUser))
            .setter(setter(Builder::targetUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetUser").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            IMPERSONATION_ROLE_ID_FIELD, TARGET_USER_FIELD));

    private final String organizationId;

    private final String impersonationRoleId;

    private final String targetUser;

    private GetImpersonationRoleEffectRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.impersonationRoleId = builder.impersonationRoleId;
        this.targetUser = builder.targetUser;
    }

    /**
     * <p>
     * The WorkMail organization where the impersonation role is defined.
     * </p>
     * 
     * @return The WorkMail organization where the impersonation role is defined.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The impersonation role ID to test.
     * </p>
     * 
     * @return The impersonation role ID to test.
     */
    public final String impersonationRoleId() {
        return impersonationRoleId;
    }

    /**
     * <p>
     * The WorkMail organization user chosen to test the impersonation role. The following identity formats are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User ID: <code>12345678-1234-1234-1234-123456789012</code> or
     * <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: <code>user@domain.tld</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * User name: <code>user</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The WorkMail organization user chosen to test the impersonation role. The following identity formats are
     *         available:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         User ID: <code>12345678-1234-1234-1234-123456789012</code> or
     *         <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: <code>user@domain.tld</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         User name: <code>user</code>
     *         </p>
     *         </li>
     */
    public final String targetUser() {
        return targetUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(impersonationRoleId());
        hashCode = 31 * hashCode + Objects.hashCode(targetUser());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImpersonationRoleEffectRequest)) {
            return false;
        }
        GetImpersonationRoleEffectRequest other = (GetImpersonationRoleEffectRequest) obj;
        return Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(impersonationRoleId(), other.impersonationRoleId())
                && Objects.equals(targetUser(), other.targetUser());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImpersonationRoleEffectRequest").add("OrganizationId", organizationId())
                .add("ImpersonationRoleId", impersonationRoleId()).add("TargetUser", targetUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "ImpersonationRoleId":
            return Optional.ofNullable(clazz.cast(impersonationRoleId()));
        case "TargetUser":
            return Optional.ofNullable(clazz.cast(targetUser()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImpersonationRoleEffectRequest, T> g) {
        return obj -> g.apply((GetImpersonationRoleEffectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetImpersonationRoleEffectRequest> {
        /**
         * <p>
         * The WorkMail organization where the impersonation role is defined.
         * </p>
         * 
         * @param organizationId
         *        The WorkMail organization where the impersonation role is defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The impersonation role ID to test.
         * </p>
         * 
         * @param impersonationRoleId
         *        The impersonation role ID to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impersonationRoleId(String impersonationRoleId);

        /**
         * <p>
         * The WorkMail organization user chosen to test the impersonation role. The following identity formats are
         * available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * User ID: <code>12345678-1234-1234-1234-123456789012</code> or
         * <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Email address: <code>user@domain.tld</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * User name: <code>user</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param targetUser
         *        The WorkMail organization user chosen to test the impersonation role. The following identity formats
         *        are available:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        User ID: <code>12345678-1234-1234-1234-123456789012</code> or
         *        <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Email address: <code>user@domain.tld</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        User name: <code>user</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetUser(String targetUser);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String impersonationRoleId;

        private String targetUser;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImpersonationRoleEffectRequest model) {
            super(model);
            organizationId(model.organizationId);
            impersonationRoleId(model.impersonationRoleId);
            targetUser(model.targetUser);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getImpersonationRoleId() {
            return impersonationRoleId;
        }

        public final void setImpersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
        }

        @Override
        public final Builder impersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
            return this;
        }

        public final String getTargetUser() {
            return targetUser;
        }

        public final void setTargetUser(String targetUser) {
            this.targetUser = targetUser;
        }

        @Override
        public final Builder targetUser(String targetUser) {
            this.targetUser = targetUser;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetImpersonationRoleEffectRequest build() {
            return new GetImpersonationRoleEffectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
