/*
 * Decompiled with CFR 0.152.
 */
package software.reinvent.headless.chrome;

import com.google.common.io.Resources;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import software.reinvent.commons.config.ConfigLoader;

public class HeadlessDriver {
    private final ChromeDriver chromeDriver;

    public HeadlessDriver(Config config) {
        File file;
        String string;
        String string2;
        Config config2 = Optional.ofNullable(config).orElse(ConfigLoader.load());
        if (config2.hasPath("webdriver.chrome.driver")) {
            System.setProperty("webdriver.chrome.driver", config2.getString("webdriver.chrome.driver"));
        } else {
            try {
                string2 = config2.getString("os.name");
                string = StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)"windows") ? "chromedriver_win32-2.31.exe" : (StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)"mac") ? "chromedriver_mac-2.31" : "chromedriver_linux64-2.31");
                file = new File("/tmp/" + string);
                if (!file.exists()) {
                    FileUtils.copyInputStreamToFile((InputStream)Resources.getResource(this.getClass(), (String)string).openStream(), (File)file);
                    file.setExecutable(true);
                }
                System.setProperty("webdriver.chrome.driver", file.getPath());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        string2 = new ChromeOptions();
        string2.setBinary(config2.hasPath("webdriver.chrome.binary") ? config2.getString("webdriver.chrome.binary") : "/usr/bin/google-chrome-unstable");
        string = config2.hasPath("chrome.window.size") ? config2.getString("chrome.window.size") : "1920,1200";
        if (config2.hasPath("webdriver.user.agent")) {
            string2.addArguments(new String[]{"--user-agent=" + config2.getString("webdriver.user.agent")});
        }
        string2.addArguments(new String[]{"--headless", "--disable-gpu", "--no-sandbox", "--incognito", "window-size=" + string});
        file = DesiredCapabilities.chrome();
        file.setCapability("chromeOptions", string2);
        this.chromeDriver = new ChromeDriver((Capabilities)file);
    }

    public ChromeDriver getChromeDriver() {
        return this.chromeDriver;
    }
}

