/*
 * Decompiled with CFR 0.152.
 */
package tech.sqlclub.common.log;

import java.net.URL;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import tech.sqlclub.common.log.Logger;

public class LoggerImpl
extends Logger {
    private final org.slf4j.Logger logger;

    private static void initializeLogging() {
        boolean log4j12Initialized;
        String binderClass = StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr();
        boolean usingLog4j12 = "org.slf4j.impl.Log4jLoggerFactory".equals(binderClass);
        if (usingLog4j12 && !(log4j12Initialized = LogManager.getRootLogger().getAllAppenders().hasMoreElements())) {
            String defaultLogProps = "org/apache/spark/log4j-defaults.properties";
            URL url = LoggerImpl.class.getResource(defaultLogProps);
            if (url != null) {
                PropertyConfigurator.configure((URL)url);
                System.out.println("Using Spark's default log4j profile: " + defaultLogProps);
            } else {
                url = LoggerImpl.class.getResource("log4j.properties");
                if (url != null) {
                    PropertyConfigurator.configure((URL)url);
                }
            }
        }
    }

    public LoggerImpl(String clazzname) {
        this.logger = LoggerFactory.getLogger((String)clazzname);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void debug(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void debug(String format, Object ... args) {
        this.logger.debug(format, args);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logger.debug(msg, t);
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void info(String format, Object ... args) {
        this.logger.info(format, args);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logger.info(msg, t);
    }

    @Override
    public void warn(String msg) {
        this.logger.warn(msg);
    }

    @Override
    public void warn(String format, Object ... args) {
        this.logger.warn(format, args);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger.warn(msg, t);
    }

    @Override
    public void error(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void error(String format, Object ... args) {
        this.logger.error(format, args);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger.error(msg, t);
    }

    @Override
    public void trace(String msg) {
        this.logger.trace(msg);
    }

    @Override
    public void trace(String format, Object ... args) {
        this.logger.trace(format, args);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logger.trace(msg, t);
    }

    static {
        LoggerImpl.initializeLogging();
    }
}

