/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.SimpleClassLoader;
import org.apache.tomcat.util.depend.DependClassLoader;

public class Jdk11Compat {
    static Log logger = LogFactory.getLog((Class)(class$org$apache$tomcat$util$compat$Jdk11Compat == null ? (class$org$apache$tomcat$util$compat$Jdk11Compat = Jdk11Compat.class$("org.apache.tomcat.util.compat.Jdk11Compat")) : class$org$apache$tomcat$util$compat$Jdk11Compat));
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    static String javaVersion;
    static boolean java2;
    static Jdk11Compat compat;
    static final String JAVA2_SUPPORT = "org.apache.tomcat.util.compat.Jdk12Support";
    private static final String URL_COMPAT_HANDLERS = "org.apache.tomcat.util.compat";
    static /* synthetic */ Class class$org$apache$tomcat$util$compat$Jdk11Compat;

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static boolean isJava2() {
        return java2;
    }

    public ClassLoader newClassLoaderInstance(URL[] urls, ClassLoader parent) {
        return new SimpleClassLoader(urls, parent);
    }

    public Object getAccessControlContext() throws Exception {
        return null;
    }

    public Object doPrivileged(Action action, Object acc) throws Exception {
        return action.run();
    }

    public void setContextClassLoader(ClassLoader cl) {
    }

    public void refreshPolicy() {
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public ClassLoader getParentLoader(ClassLoader cl) {
        if (cl instanceof DependClassLoader) {
            return ((DependClassLoader)cl).getParentLoader();
        }
        if (cl instanceof SimpleClassLoader) {
            return ((SimpleClassLoader)cl).getParentLoader();
        }
        return null;
    }

    public URL[] getURLs(ClassLoader cl, int depth) {
        int c = 0;
        while (true) {
            if (cl instanceof DependClassLoader && cl != null) {
                cl = ((DependClassLoader)cl).getParentLoader();
                continue;
            }
            if (depth == c) {
                return ((SimpleClassLoader)cl).getURLs();
            }
            if ((cl = ((SimpleClassLoader)cl).getParentLoader()) == null || depth < ++c) break;
        }
        return null;
    }

    public ResourceBundle getBundle(String name, Locale loc, ClassLoader cl) {
        return ResourceBundle.getBundle(name, loc);
    }

    public Object getX509Certificates(byte[] x509) throws Exception {
        return null;
    }

    public static Jdk11Compat getJdkCompat() {
        return compat;
    }

    private static void init() {
        block14: {
            try {
                javaVersion = JAVA_1_0;
                Class.forName("java.lang.Void");
                javaVersion = JAVA_1_1;
                Class.forName("java.lang.ThreadLocal");
                java2 = true;
                javaVersion = JAVA_1_2;
                Class.forName("java.lang.StrictMath");
                javaVersion = JAVA_1_3;
                Class.forName("java.lang.CharSequence");
                javaVersion = JAVA_1_4;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            if (java2) {
                try {
                    Class<?> c = Class.forName(JAVA2_SUPPORT);
                    compat = (Jdk11Compat)c.newInstance();
                }
                catch (Exception ex) {
                    compat = new Jdk11Compat();
                }
            } else {
                compat = new Jdk11Compat();
                try {
                    URL url = new URL("jar:file:/test.jar!/foo");
                }
                catch (MalformedURLException ex) {
                    String handlers;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Installing jar protocol handler ");
                    }
                    if ((handlers = System.getProperty("java.protocol.handler.pkgs")) == null) {
                        handlers = URL_COMPAT_HANDLERS;
                    } else if (handlers.indexOf(URL_COMPAT_HANDLERS) < 0) {
                        handlers = handlers + ":org.apache.tomcat.util.compat";
                    }
                    ((Hashtable)System.getProperties()).put("java.protocol.handler.pkgs", handlers);
                    if (!logger.isDebugEnabled()) break block14;
                    try {
                        URL url = new URL("jar:file:/test.jar!/foo");
                    }
                    catch (MalformedURLException ex1) {
                        logger.debug((Object)"Jar protocol failing ", (Throwable)ex1);
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        java2 = false;
        Jdk11Compat.init();
    }
}

