/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.xml;

import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.xml.sax.AttributeList;

class SetVar
extends XmlAction {
    String varName;
    String nameAtt;
    String valAtt;
    boolean reset = false;

    public SetVar(String varName, String attributeN) {
        this.varName = varName;
        this.valAtt = attributeN;
        this.reset = true;
    }

    public SetVar(String varName, String nameAtt, String valueAtt, boolean reset) {
        this.varName = varName;
        this.nameAtt = nameAtt;
        this.valAtt = valueAtt;
        this.reset = reset;
    }

    public void start(SaxContext ctx) throws Exception {
        AttributeList attributes = ctx.getCurrentAttributes();
        String n = this.varName;
        if (n == null) {
            n = attributes.getValue(this.nameAtt);
        }
        String v = attributes.getValue(this.valAtt);
        if (n != null && v != null) {
            ctx.setVariable(n, v);
        }
        if (ctx.getDebug() > 0) {
            ctx.log("setVariable " + n + " " + v);
        }
    }

    public void cleanup(SaxContext ctx) {
        if (!this.reset) {
            return;
        }
        if (this.varName != null) {
            ctx.setVariable(this.varName, null);
        }
        if (ctx.getDebug() > 0) {
            ctx.log("setVariable " + this.varName + " null");
        }
    }
}

