/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.stax.DefaultXmlSymbolTable;
import com.ctc.wstx.stax.WstxEventReader;
import com.ctc.wstx.stax.WstxStreamReader;
import com.ctc.wstx.stax.cfg.InputConfigFlags;
import com.ctc.wstx.stax.cfg.ReaderConfig;
import com.ctc.wstx.stax.dtd.DTDId;
import com.ctc.wstx.stax.dtd.DTDSubset;
import com.ctc.wstx.stax.dtd.FullDTDReaderProxy;
import com.ctc.wstx.stax.evt.DefaultEventAllocator;
import com.ctc.wstx.stax.evt.FilteredEventReader;
import com.ctc.wstx.stax.exc.WstxIOException;
import com.ctc.wstx.stax.io.BranchingReaderSource;
import com.ctc.wstx.stax.io.InputBootstrapper;
import com.ctc.wstx.stax.io.InputSourceFactory;
import com.ctc.wstx.stax.io.ReaderBootstrapper;
import com.ctc.wstx.stax.io.StreamBootstrapper;
import com.ctc.wstx.stax.io.WstxInputResolver;
import com.ctc.wstx.stax.stream.FilteredStreamReader;
import com.ctc.wstx.stax.stream.ReaderCreator;
import com.ctc.wstx.util.SimpleCache;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.URLUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

public final class WstxInputFactory
extends XMLInputFactory
implements ReaderCreator,
InputConfigFlags {
    protected final ReaderConfig mConfig;
    protected XMLEventAllocator mAllocator = null;
    protected SimpleCache mDTDCache = null;
    static final SymbolTable mRootSymbols = DefaultXmlSymbolTable.getInstance();
    SymbolTable mSymbols = mRootSymbols;

    public WstxInputFactory() {
        this.mConfig = ReaderConfig.createFullDefaults(this.mSymbols, FullDTDReaderProxy.getInstance());
    }

    public synchronized DTDSubset findCachedDTD(DTDId id) {
        return this.mDTDCache == null ? null : (DTDSubset)this.mDTDCache.find(id);
    }

    public synchronized void updateSymbolTable(SymbolTable t) {
        SymbolTable curr = this.mSymbols;
        if (t.isDirectChildOf(curr)) {
            this.mSymbols = t;
        }
    }

    public synchronized void addCachedDTD(DTDId id, DTDSubset extSubset) {
        if (this.mDTDCache == null) {
            this.mDTDCache = new SimpleCache(this.mConfig.getDtdCacheSize());
        }
        this.mDTDCache.add(id, extSubset);
    }

    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) {
        return new FilteredEventReader(reader, filter);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        return new FilteredStreamReader(reader, filter);
    }

    public XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(in));
    }

    public XMLEventReader createXMLEventReader(InputStream in, String enc) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(in, enc));
    }

    public XMLEventReader createXMLEventReader(Reader r) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(r));
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(source));
    }

    public XMLEventReader createXMLEventReader(String systemId, InputStream in) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(systemId, in));
    }

    public XMLEventReader createXMLEventReader(String systemId, Reader r) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(systemId, r));
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader sr) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), sr);
    }

    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return this.createSR(null, StreamBootstrapper.getInstance(in, null, null, this.getInputBufferLength()));
    }

    public XMLStreamReader createXMLStreamReader(InputStream in, String enc) throws XMLStreamException {
        if (enc == null || enc.length() == 0) {
            return this.createXMLStreamReader(in);
        }
        try {
            return this.createSR(null, ReaderBootstrapper.getInstance(new InputStreamReader(in, enc), null, null, this.getInputBufferLength(), enc));
        }
        catch (UnsupportedEncodingException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public XMLStreamReader createXMLStreamReader(Reader r) throws XMLStreamException {
        return this.createXMLStreamReader(null, r);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.createSR(source);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in) throws XMLStreamException {
        return this.createSR(systemId, StreamBootstrapper.getInstance(in, null, systemId, this.getInputBufferLength()));
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader r) throws XMLStreamException {
        return this.createSR(systemId, ReaderBootstrapper.getInstance(r, null, systemId, this.getInputBufferLength(), null));
    }

    public Object getProperty(String name) {
        int id = this.mConfig.getPropertyId(name);
        if (id == 7) {
            return this.getEventAllocator();
        }
        return this.mConfig.getProperty(id);
    }

    public XMLEventAllocator getEventAllocator() {
        return this.mAllocator;
    }

    public XMLReporter getXMLReporter() {
        return this.mConfig.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this.mConfig.getXMLResolver();
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setEventAllocator(XMLEventAllocator allocator) {
        this.mAllocator = allocator;
    }

    public void setProperty(String propName, Object value) {
        int id = this.mConfig.getPropertyId(propName);
        if (id == 7) {
            this.setEventAllocator((XMLEventAllocator)value);
            return;
        }
        this.mConfig.setProperty(propName, id, value);
    }

    public boolean willCoalesceText() {
        return this.mConfig.willCoalesceText();
    }

    public boolean willSupportNamespaces() {
        return this.mConfig.willSupportNamespaces();
    }

    public boolean willReplaceEntityRefs() {
        return this.mConfig.willReplaceEntityRefs();
    }

    public boolean willSupportExternalEntities() {
        return this.mConfig.willSupportExternalEntities();
    }

    public boolean willSupportDTDs() {
        return this.mConfig.willSupportDTDs();
    }

    public boolean willValidateWithDTD() {
        return this.mConfig.willValidateWithDTD();
    }

    public boolean willNormalizeLFs() {
        return this.mConfig.willNormalizeLFs();
    }

    public boolean willNormalizeAttrValues() {
        return this.mConfig.willNormalizeAttrValues();
    }

    public boolean willInternNsURIs() {
        return this.mConfig.willInternNsURIs();
    }

    public boolean willReportAllTextAsCharacters() {
        return this.mConfig.willReportAllTextAsCharacters();
    }

    public boolean willReportPrologWhitespace() {
        return this.mConfig.willReportPrologWhitespace();
    }

    public boolean willCacheDTDs() {
        return this.mConfig.willCacheDTDs();
    }

    public boolean willParseLazily() {
        return this.mConfig.willParseLazily();
    }

    public int getInputBufferLength() {
        return this.mConfig.getInputBufferLength();
    }

    public int getTextBufferLength() {
        return this.mConfig.getTextBufferLength();
    }

    public int getShortestReportedTextSegment() {
        return this.mConfig.getShortestReportedTextSegment();
    }

    public Map getCustomInternalEntities() {
        return this.mConfig.getCustomInternalEntities();
    }

    public URL getBaseURL() {
        return this.mConfig.getBaseURL();
    }

    public WstxInputResolver getDtdResolver() {
        return this.mConfig.getDtdResolver();
    }

    public WstxInputResolver getEntityResolver() {
        return this.mConfig.getEntityResolver();
    }

    public void doCoalesceText(boolean state) {
        this.mConfig.doCoalesceText(state);
    }

    public void doSupportNamespaces(boolean state) {
        this.mConfig.doSupportNamespaces(state);
    }

    public void doReplaceEntityRefs(boolean state) {
        this.mConfig.doReplaceEntityRefs(state);
    }

    public void doSupportExternalEntities(boolean state) {
        this.mConfig.doSupportExternalEntities(state);
    }

    public void doSupportDTDs(boolean state) {
        this.mConfig.doSupportDTDs(state);
    }

    public void doValidateWithDTD(boolean state) {
        this.mConfig.doValidateWithDTD(state);
    }

    public void setXMLReporter(XMLReporter r) {
        this.mConfig.setXMLReporter(r);
    }

    public void setXMLResolver(XMLResolver r) {
        this.mConfig.setXMLResolver(r);
    }

    public void doNormalizeLFs(boolean state) {
        this.mConfig.doNormalizeLFs(state);
    }

    public void doNormalizeAttrValues(boolean state) {
        this.mConfig.doNormalizeAttrValues(state);
    }

    public void doInternNsURIs(boolean state) {
        this.mConfig.doInternNsURIs(state);
    }

    public void doReportPrologWhitespace(boolean state) {
        this.mConfig.doReportPrologWhitespace(state);
    }

    public void doCacheDTDs(boolean state) {
        this.mConfig.doCacheDTDs(state);
    }

    public void doParseLazily(boolean state) {
        this.mConfig.doParseLazily(state);
    }

    public void doReportAllTextAsCharacters(boolean state) {
        this.mConfig.doReportAllTextAsCharacters(state);
    }

    public void setInputBufferLength(int value) {
        this.mConfig.setInputBufferLength(value);
    }

    public void setTextBufferLength(int value) {
        this.mConfig.setTextBufferLength(value);
    }

    public void setShortestReportedTextSegment(int value) {
        this.mConfig.setShortestReportedTextSegment(value);
    }

    public void setBaseURL(URL baseURL) {
        this.mConfig.setBaseURL(baseURL);
    }

    public void setCustomInternalEntities(Map in) {
        this.mConfig.setCustomInternalEntities(in);
    }

    public void setDtdResolver(WstxInputResolver r) {
        this.mConfig.setDtdResolver(r);
    }

    public void setEntityResolver(WstxInputResolver r) {
        this.mConfig.setEntityResolver(r);
    }

    public void configureForMaxConformance() {
        this.mConfig.configureForMaxConformance();
    }

    public void configureForMaxConvenience() {
        this.mConfig.configureForMaxConvenience();
    }

    public void configureForMaxSpeed() {
        this.mConfig.configureForMaxSpeed();
    }

    public void configureForMinMemUsage() {
        this.mConfig.configureForMinMemUsage();
    }

    public void configureForRoundTripping() {
        this.mConfig.configureForRoundTripping();
    }

    private WstxStreamReader createSR(String systemId, InputBootstrapper bs) throws XMLStreamException {
        Reader r;
        URL src = this.mConfig.getBaseURL();
        if (src == null && systemId != null && systemId.length() > 0) {
            try {
                src = URLUtil.urlFromSystemId(systemId);
            }
            catch (IOException ie) {
                throw new WstxIOException(ie);
            }
        }
        try {
            r = bs.bootstrapInput(true, this.getXMLReporter());
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
        ReaderConfig cfg = this.mConfig.createNonShared(this.mSymbols.makeChild());
        BranchingReaderSource input = InputSourceFactory.constructBranchingSource(null, null, bs, null, systemId, src, r, false, cfg.getInputBufferLength());
        try {
            WstxStreamReader sr = WstxStreamReader.createWstxStreamReader(input, this, cfg, bs);
            return sr;
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    private WstxStreamReader createSR(Source src) throws XMLStreamException {
        if (src instanceof StreamSource) {
            InputBootstrapper bs;
            StreamSource ss = (StreamSource)src;
            Reader r = ss.getReader();
            if (r == null) {
                InputStream in = ss.getInputStream();
                if (in == null) {
                    throw new XMLStreamException("Can not create StAX reader for a StreamSource -- neither reader nor input stream was set.");
                }
                bs = StreamBootstrapper.getInstance(in, ss.getPublicId(), ss.getSystemId(), this.getInputBufferLength());
            } else {
                bs = ReaderBootstrapper.getInstance(r, ss.getPublicId(), ss.getSystemId(), this.getInputBufferLength(), null);
            }
            return this.createSR(src.getSystemId(), bs);
        }
        if (src instanceof SAXSource) {
            SAXSource sr = (SAXSource)src;
            throw new XMLStreamException("Can not create a STaX reader for a SAXSource -- not (yet) implemented.");
        }
        if (src instanceof DOMSource) {
            DOMSource sr = (DOMSource)src;
            throw new XMLStreamException("Can not create a STaX reader for a DOMSource -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate StAX reader for XML source type " + src.getClass() + " (unknown type)");
    }

    private XMLEventAllocator createEventAllocator() {
        XMLEventAllocator ea = this.mAllocator == null ? DefaultEventAllocator.rootInstance() : this.mAllocator;
        return ea.newInstance();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.ctc.wstx.stax.WstxInputFactory [input file]");
            System.exit(1);
        }
        WstxInputFactory f = new WstxInputFactory();
        System.out.println("Creating stream reader for file '" + args[0] + "'.");
        XMLStreamReader r = f.createXMLStreamReader(new FileInputStream(args[0]));
        r.close();
        System.out.println("Reader created and closed ok, exiting.");
    }

    static {
        mRootSymbols.setInternStrings(true);
    }
}

