/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.stax.DefaultXmlSymbolTable;
import com.ctc.wstx.stax.cfg.ErrorConsts;
import com.ctc.wstx.stax.cfg.WriterConfig;
import com.ctc.wstx.stax.ns.OutputElement;
import com.ctc.wstx.stax.stream.BaseStreamWriter;
import com.ctc.wstx.util.XMLQuoter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

public class WstxNsStreamWriter
extends BaseStreamWriter {
    protected static final String sPrefixXml = DefaultXmlSymbolTable.getXmlSymbol();
    protected static final String sPrefixXmlns = DefaultXmlSymbolTable.getXmlnsSymbol();
    final boolean mAutomaticNS;
    final boolean mCheckNS;
    final String mAutomaticNsPrefix;
    static final OutputElement sSharedRootElem = OutputElement.getRootInstance();
    OutputElement mCurrElem = sSharedRootElem;
    OutputElement.Declarations mNsDecl = null;
    NamespaceContext mRootNsContext = null;

    public WstxNsStreamWriter(Writer w, WriterConfig cfg) {
        super(w, cfg);
        int flags = cfg.getConfigFlags();
        this.mAutomaticNS = (flags & 2) != 0;
        this.mCheckNS = (flags & 8) != 0;
        this.mAutomaticNsPrefix = cfg.getAutomaticNsPrefix();
    }

    public NamespaceContext getNamespaceContext() {
        if (this.mNsDecl == null) {
            return this.mCurrElem;
        }
        return this.mNsDecl;
    }

    public String getPrefix(String uri) {
        if (this.mNsDecl != null) {
            return this.mNsDecl.getPrefix(uri);
        }
        return this.mCurrElem.getPrefix(uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        if (this.mNsDecl == null) {
            this.mNsDecl = new OutputElement.Declarations(this.mCurrElem);
        }
        this.mNsDecl.setDefaultNsUri(uri);
    }

    public void setNamespaceContext(NamespaceContext context) {
        if (this.mState != 1) {
            throw new IllegalStateException("Called setNamespaceContext() after having already output root element.");
        }
        this.mRootNsContext = context;
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (this.mCheckNS) {
            if (prefix.equals(sPrefixXml)) {
                if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                    this.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, uri);
                }
            } else if (prefix.equals(sPrefixXmlns)) {
                if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                    this.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, uri);
                }
            } else if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                this.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix);
            } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
                this.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, prefix);
            }
        }
        if (this.mNsDecl == null) {
            this.mNsDecl = new OutputElement.Declarations(this.mCurrElem);
        }
        this.mNsDecl.addNamespace(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (this.mCheckContent) {
            this.checkNameValidity(localName, false);
        }
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write an attribute when there is no open start element.");
        }
        this.doWriteAttr(localName, null, null, value);
    }

    public void writeAttribute(String nsURI, String localName, String value) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write an attribute when there is no open start element.");
        }
        String prefix = this.findOrCreatePrefix(null, nsURI, false);
        this.doWriteAttr(localName, nsURI, prefix, value);
    }

    public void writeAttribute(String prefix, String nsURI, String localName, String value) throws XMLStreamException {
        int status;
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write an attribute when there is no open start element.");
        }
        if (this.mCheckNS && (status = this.mCurrElem.isPrefixValid(prefix, nsURI, this.mCheckNS, false)) != 1) {
            if (status == 2) {
                prefix = this.findOrCreatePrefix(prefix, nsURI, false);
            }
            this.mCurrElem.addPrefix(prefix, nsURI);
            this.doWriteNamespace(prefix, nsURI);
        }
        this.doWriteAttr(localName, nsURI, prefix, value);
    }

    public void writeDefaultNamespace(String nsURI) throws XMLStreamException {
        if (this.mAutomaticNS) {
            return;
        }
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write a namespace declaration when there is no open start element.");
        }
        if (this.mCheckNS) {
            this.mCurrElem.checkDefaultNsWrite(nsURI);
        }
        try {
            this.mWriter.write(32);
            this.mWriter.write("xmlns");
            this.mWriter.write("=\"");
            this.mWriter.write(nsURI);
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mEmptyElement = true;
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        this.doWriteStartElement(null, localName);
        this.mNsDecl = null;
    }

    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        boolean nsOk;
        this.checkStartElement(localName);
        this.mEmptyElement = true;
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        String prefix = this.mCurrElem.findPrefix(nsURI, true);
        boolean bl = nsOk = prefix != null;
        if (!nsOk) {
            prefix = this.generatePrefix(null, nsURI);
            this.mCurrElem.addPrefix(prefix, nsURI);
        }
        this.mCurrElem.setPrefix(prefix);
        this.doWriteStartElement(prefix, localName);
        this.mNsDecl = null;
    }

    public void writeEmptyElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix, localName, nsURI, true);
    }

    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndElement(null, this.mCfgOutputEmptyElems);
    }

    public void writeNamespace(String prefix, String nsURI) throws XMLStreamException {
        if (this.mAutomaticNS) {
            return;
        }
        if (prefix == null || prefix.length() == 0 || prefix.equals("xmlns")) {
            this.writeDefaultNamespace(nsURI);
            return;
        }
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write a namespace declaration when there is no open start element.");
        }
        if (this.mCheckNS) {
            this.mCurrElem.checkNsWrite(prefix, nsURI);
        }
        this.doWriteNamespace(prefix, nsURI);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mEmptyElement = false;
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        this.doWriteStartElement(null, localName);
        this.mNsDecl = null;
    }

    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        boolean nsOk;
        this.checkStartElement(localName);
        this.mEmptyElement = false;
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        String prefix = this.mCurrElem.findPrefix(nsURI, true);
        boolean bl = nsOk = prefix != null;
        if (!nsOk) {
            prefix = this.generatePrefix(null, nsURI);
            this.mCurrElem.addPrefix(prefix, nsURI);
        }
        this.mCurrElem.setPrefix(prefix);
        this.doWriteStartElement(prefix, localName);
        this.mNsDecl = null;
    }

    public void writeStartElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix, localName, nsURI, true);
    }

    public void writeStartElement(StartElement elem) throws XMLStreamException {
        String prefix;
        QName name = elem.getName();
        Iterator<Attribute> it = elem.getNamespaces();
        while (it.hasNext()) {
            Namespace ns = it.next();
            prefix = ns.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                this.setDefaultNamespace(ns.getNamespaceURI());
                continue;
            }
            this.setPrefix(prefix, ns.getNamespaceURI());
        }
        String nsURI = name.getNamespaceURI();
        if (nsURI == null) {
            this.writeStartElement(name.getLocalPart());
        }
        prefix = name.getPrefix();
        if (this.mAutomaticNS && (prefix == null || prefix.length() == 0)) {
            this.writeStartElement(nsURI, name.getLocalPart());
        } else {
            this.writeStartElement(prefix, name.getLocalPart(), nsURI);
        }
        it = elem.getNamespaces();
        while (it.hasNext()) {
            Namespace ns = it.next();
            prefix = ns.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                this.writeDefaultNamespace(ns.getNamespaceURI());
                continue;
            }
            this.writeNamespace(prefix, ns.getNamespaceURI());
        }
        it = elem.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            name = attr.getName();
            this.writeAttribute(name.getLocalPart(), attr.getValue());
        }
    }

    public void writeEndElement(QName name) throws XMLStreamException {
        this.doWriteEndElement(this.mCheckStructure ? name : null, this.mCfgOutputEmptyElems);
    }

    public void closeStartElement(boolean emptyElem) throws XMLStreamException {
        this.mStartElementOpen = false;
        if (this.mCheckNS && !this.mAutomaticNS) {
            this.mCurrElem.checkAllNsWrittenOk();
        }
        try {
            if (emptyElem) {
                this.mWriter.write(" />");
            } else {
                this.mWriter.write(62);
            }
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (emptyElem) {
            this.mCurrElem = this.mCurrElem.getParent();
            if (this.mCurrElem.isRoot()) {
                this.mState = 3;
            }
        }
    }

    public String getTopElemName() {
        return this.mCurrElem.getElementName();
    }

    private String findOrCreatePrefix(String oldPrefix, String nsURI, boolean defaultNsOk) throws XMLStreamException {
        String prefix = this.mCurrElem.findPrefix(nsURI, defaultNsOk);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.generatePrefix(oldPrefix, nsURI);
        this.mCurrElem.addPrefix(prefix, nsURI);
        this.doWriteNamespace(prefix, nsURI);
        return prefix;
    }

    private String generatePrefix(String oldPrefix, String nsURI) throws XMLStreamException {
        String prefix;
        if (this.mRootNsContext != null && (prefix = this.mRootNsContext.getPrefix(nsURI)) != null && prefix.length() > 0) {
            return prefix;
        }
        if (!this.mAutomaticNS) {
            if (oldPrefix != null) {
                throw new XMLStreamException("Prefix '" + oldPrefix + "' did not match (or wasn't declared for) namespace '" + nsURI + "', can not generate a new prefix since feature '" + "javax.xml.stream.isRepairingNamespaces" + "' not enabled.");
            }
            throw new XMLStreamException("Can not create automatic namespace for namespace URI '" + nsURI + "', feature '" + "javax.xml.stream.isRepairingNamespaces" + "' not enabled.");
        }
        return this.mCurrElem.generatePrefix(this.mRootNsContext);
    }

    private void checkStartElement(String localName) throws XMLStreamException {
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        } else if (this.mCheckStructure && this.mState == 3) {
            throw new IllegalStateException("Trying to output second root ('" + localName + "').");
        }
        if (this.mCheckContent) {
            this.checkNameValidity(localName, false);
        }
        if (this.mState == 1) {
            this.mState = 2;
        }
    }

    private void writeStartOrEmpty(String prefix, String localName, String nsURI, boolean isEmpty) throws XMLStreamException {
        int status;
        this.checkStartElement(localName);
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        this.mNsDecl = null;
        if (this.mCheckNS && (status = this.mCurrElem.isPrefixValid(prefix, nsURI, this.mCheckNS, true)) != 1) {
            System.err.println("Wrong prefix '" + prefix + "' -> " + status);
            if (status == 2) {
                prefix = this.mCurrElem.findPrefix(nsURI, true);
            } else if (this.mAutomaticNS) {
                this.mCurrElem.addPrefix(prefix, nsURI);
            } else {
                this.throwOutputError("Undeclared prefix '" + prefix + "' for element <" + prefix + ":" + localName + ">");
            }
            if (prefix == null) {
                prefix = this.generatePrefix(null, nsURI);
                this.mCurrElem.addPrefix(prefix, nsURI);
            }
        }
        this.mCurrElem.setPrefix(prefix);
        this.doWriteStartElement(prefix, localName);
    }

    private void doWriteStartElement(String prefix, String localName) throws XMLStreamException {
        this.mAnyOutput = true;
        this.mStartElementOpen = true;
        try {
            this.mWriter.write(60);
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            if (this.mAutomaticNS) {
                this.mCurrElem.outputDeclaredNamespaces(this.mWriter);
            }
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    private void doWriteNamespace(String prefix, String nsURI) throws XMLStreamException {
        try {
            this.mWriter.write(32);
            this.mWriter.write("xmlns");
            if (prefix != null) {
                this.mWriter.write(58);
                this.mWriter.write(prefix);
            }
            this.mWriter.write("=\"");
            if (nsURI != null && nsURI.length() > 0) {
                this.mWriter.write(nsURI);
            }
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    private void doWriteAttr(String localName, String nsURI, String prefix, String value) throws XMLStreamException {
        if (this.mCheckAttr) {
            this.mCurrElem.checkAttrWrite(nsURI, localName, value);
        }
        try {
            this.mWriter.write(32);
            if (prefix != null) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            this.mWriter.write("=\"");
            XMLQuoter.outputDoubleQuotedAttr(this.mWriter, value);
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    private void doWriteEndElement(QName expName, boolean allowEmpty) throws XMLStreamException {
        if (this.mStartElementOpen && this.mEmptyElement) {
            this.mEmptyElement = false;
            this.closeStartElement(true);
        }
        if (this.mState != 2) {
            this.throwOutputError("No open start element, when trying to write end element");
        }
        String prefix = this.mCurrElem.getPrefix();
        String localName = this.mCurrElem.getLocalName();
        this.mCurrElem = this.mCurrElem.getParent();
        if (expName != null && !localName.equals(expName.getLocalPart())) {
            throw new IllegalArgumentException("Mismatching close element local name, '" + localName + "'; expected '" + expName.getLocalPart() + "'.");
        }
        if (this.mStartElementOpen) {
            this.mStartElementOpen = false;
            if (this.mCheckNS && !this.mAutomaticNS) {
                this.mCurrElem.checkAllNsWrittenOk();
            }
            try {
                if (allowEmpty) {
                    this.mWriter.write(" />");
                    if (this.mCurrElem.isRoot()) {
                        this.mState = 3;
                    }
                    return;
                }
                this.mWriter.write(62);
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        }
        try {
            this.mWriter.write("</");
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            this.mWriter.write(62);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (this.mCurrElem.isRoot()) {
            this.mState = 3;
        }
    }
}

