/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.stax.WstxEventWriter;
import com.ctc.wstx.stax.WstxNonNsStreamWriter;
import com.ctc.wstx.stax.WstxNsStreamWriter;
import com.ctc.wstx.stax.cfg.OutputConfigFlags;
import com.ctc.wstx.stax.cfg.WriterConfig;
import com.ctc.wstx.stax.stream.BaseStreamWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

public final class WstxOutputFactory
extends XMLOutputFactory
implements OutputConfigFlags {
    protected final String DEFAULT_AUTOMATIC_NS_PREFIX = "wstxns";
    static final int PROP_AUTOMATIC_NS = 1;
    static final int PROP_ENABLE_NS = 2;
    static final int PROP_OUTPUT_EMPTY_ELEMS = 3;
    static final int PROP_AUTOMATIC_NS_PREFIX = 4;
    static final int PROP_VALIDATE_NS = 5;
    static final int PROP_VALIDATE_STRUCTURE = 6;
    static final int PROP_VALIDATE_CONTENT = 7;
    static final int PROP_VALIDATE_ATTR = 8;
    static final boolean DEFAULT_ENABLE_NS = true;
    static final boolean DEFAULT_OUTPUT_EMPTY_ELEMS = false;
    static final boolean DEFAULT_VALIDATE_NS = false;
    static final boolean DEFAULT_VALIDATE_STRUCTURE = true;
    static final boolean DEFAULT_VALIDATE_CONTENT = false;
    static final boolean DEFAULT_VALIDATE_ATTR = false;
    static final int DEFAULT_CONFIG_FLAGS = 17;
    static final HashMap sProperties = new HashMap(8);
    protected final WriterConfig mConfig = WriterConfig.createFullDefaults();

    public XMLEventWriter createXMLEventWriter(OutputStream out) {
        return this.createXMLEventWriter(new OutputStreamWriter(out));
    }

    public XMLEventWriter createXMLEventWriter(OutputStream out, String enc) throws XMLStreamException {
        try {
            return this.createXMLEventWriter(new OutputStreamWriter(out, enc));
        }
        catch (UnsupportedEncodingException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new WstxEventWriter(this.createWstxStreamWriter(result), this.mConfig);
    }

    public XMLEventWriter createXMLEventWriter(Writer w) {
        return new WstxEventWriter(w, this.mConfig);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out) {
        return this.createXMLStreamWriter(new OutputStreamWriter(out));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out, String enc) throws XMLStreamException {
        try {
            return this.createXMLStreamWriter(new OutputStreamWriter(out, enc));
        }
        catch (UnsupportedEncodingException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createWstxStreamWriter(result);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer w) {
        return this.createWstxStreamWriter(w);
    }

    public Object getProperty(String name) {
        return this.mConfig.getProperty(name);
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setProperty(String name, Object value) {
        this.mConfig.setProperty(name, value);
    }

    public boolean automaticNamespacesEnabled() {
        return this.mConfig.automaticNamespacesEnabled();
    }

    public boolean willSupportNamespaces() {
        return this.mConfig.willSupportNamespaces();
    }

    public boolean willOutputEmptyElements() {
        return this.mConfig.willOutputEmptyElements();
    }

    public String getAutomaticNsPrefix() {
        return this.mConfig.getAutomaticNsPrefix();
    }

    public boolean willValidateNamespaces() {
        return this.mConfig.willValidateNamespaces();
    }

    public boolean willValidateStructure() {
        return this.mConfig.willValidateStructure();
    }

    public boolean willValidateContent() {
        return this.mConfig.willValidateContent();
    }

    public boolean willValidateAttributes() {
        return this.mConfig.willValidateAttributes();
    }

    public void enableAutomaticNamespaces(boolean state) {
        this.mConfig.enableAutomaticNamespaces(state);
    }

    public void doSupportNamespaces(boolean state) {
        this.mConfig.doSupportNamespaces(state);
    }

    public void doOutputEmptyElements(boolean state) {
        this.mConfig.doOutputEmptyElements(state);
    }

    public void setAutomaticNsPrefix(String prefix) {
        this.mConfig.setAutomaticNsPrefix(prefix);
    }

    public void doValidateNamespaces(boolean state) {
        this.mConfig.doValidateNamespaces(state);
    }

    public void doValidateStructure(boolean state) {
        this.mConfig.doValidateStructure(state);
    }

    public void doValidateContent(boolean state) {
        this.mConfig.doValidateContent(state);
    }

    public void doValidateAttributes(boolean state) {
        this.mConfig.doValidateAttributes(state);
    }

    public void configureForMaxValidation() {
        this.mConfig.configureForMaxValidation();
    }

    public void configureForMinValidation() {
        this.mConfig.configureForMinValidation();
    }

    private BaseStreamWriter createWstxStreamWriter(Writer w) {
        if (this.mConfig.willSupportNamespaces()) {
            return new WstxNsStreamWriter(w, this.mConfig);
        }
        return new WstxNonNsStreamWriter(w, this.mConfig);
    }

    private BaseStreamWriter createWstxStreamWriter(Result res) throws XMLStreamException {
        if (res instanceof StreamResult) {
            StreamResult sr = (StreamResult)res;
            Writer w = sr.getWriter();
            if (w == null) {
                OutputStream out = sr.getOutputStream();
                if (out == null) {
                    throw new XMLStreamException("Can not create StAX writer for a StreamResult -- neither writer nor output stream was set.");
                }
                w = new OutputStreamWriter(out);
            }
            return this.createWstxStreamWriter(w);
        }
        if (res instanceof SAXResult) {
            SAXResult sr = (SAXResult)res;
            throw new XMLStreamException("Can not create a STaX writer for a SAXResult -- not (yet) implemented.");
        }
        if (res instanceof DOMResult) {
            DOMResult sr = (DOMResult)res;
            throw new XMLStreamException("Can not create a STaX writer for a DOMResult -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate a writer for XML result type " + res.getClass() + " (unknown type)");
    }

    public static void main(String[] args) throws Exception {
        WstxOutputFactory f = new WstxOutputFactory();
        System.out.println("Writer factory created ok.");
    }

    static {
        sProperties.put("javax.xml.stream.isRepairingNamespaces", new Integer(1));
        sProperties.put("com.ctc.wstx.outputEnableNS", new Integer(2));
        sProperties.put("com.ctc.wstx.outputEmptyElements", new Integer(3));
        sProperties.put("com.ctc.wstx.outputValidateNS", new Integer(5));
        sProperties.put("com.ctc.wstx.outputValidateStructure", new Integer(6));
        sProperties.put("com.ctc.wstx.outputValidateContent", new Integer(7));
        sProperties.put("com.ctc.wstx.outputValidateAttr", new Integer(8));
    }
}

