/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.cfg;

import com.ctc.wstx.stax.cfg.OutputConfigFlags;
import com.ctc.wstx.util.ArgUtil;
import java.util.HashMap;

public final class WriterConfig
implements OutputConfigFlags {
    protected static final String DEFAULT_AUTOMATIC_NS_PREFIX = "wstxns";
    static final int PROP_AUTOMATIC_NS = 1;
    static final int PROP_ENABLE_NS = 2;
    static final int PROP_OUTPUT_EMPTY_ELEMS = 3;
    static final int PROP_AUTOMATIC_NS_PREFIX = 4;
    static final int PROP_VALIDATE_NS = 5;
    static final int PROP_VALIDATE_STRUCTURE = 6;
    static final int PROP_VALIDATE_CONTENT = 7;
    static final int PROP_VALIDATE_ATTR = 8;
    static final boolean DEFAULT_ENABLE_NS = true;
    static final boolean DEFAULT_OUTPUT_EMPTY_ELEMS = false;
    static final boolean DEFAULT_VALIDATE_NS = true;
    static final boolean DEFAULT_VALIDATE_STRUCTURE = true;
    static final boolean DEFAULT_VALIDATE_CONTENT = false;
    static final boolean DEFAULT_VALIDATE_ATTR = false;
    static final int DEFAULT_FLAGS_J2ME = 25;
    static final int DEFAULT_FLAGS_FULL = 25;
    static final HashMap sProperties = new HashMap(8);
    final boolean mIsJ2MESubset;
    protected int mConfigFlags;
    protected String mAutoNsPrefix;

    private WriterConfig(boolean j2meSubset, int flags, String autoNsPrefix) {
        this.mIsJ2MESubset = j2meSubset;
        this.mConfigFlags = flags;
        this.mAutoNsPrefix = autoNsPrefix;
    }

    public static WriterConfig createJ2MEDefaults() {
        WriterConfig rc = new WriterConfig(true, 25, DEFAULT_AUTOMATIC_NS_PREFIX);
        return rc;
    }

    public static WriterConfig createFullDefaults() {
        WriterConfig rc = new WriterConfig(true, 25, DEFAULT_AUTOMATIC_NS_PREFIX);
        return rc;
    }

    public WriterConfig createNonShared() {
        WriterConfig rc = new WriterConfig(this.mIsJ2MESubset, this.mConfigFlags, this.mAutoNsPrefix);
        return rc;
    }

    public boolean isPropertySupported(String name) {
        return sProperties.containsKey(name);
    }

    public Object getProperty(String name) {
        int id = this.getPropertyId(name);
        switch (id) {
            case 1: {
                return this.automaticNamespacesEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return this.willSupportNamespaces() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.willOutputEmptyElements() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.willValidateNamespaces() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return this.willValidateStructure() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.willValidateContent() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.willValidateAttributes() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getAutomaticNsPrefix();
            }
        }
        throw new Error("Internal error: no handler for property with internal id " + id + ".");
    }

    public void setProperty(String name, Object value) {
        int id = this.getPropertyId(name);
        switch (id) {
            case 1: {
                this.enableAutomaticNamespaces(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 2: {
                this.doSupportNamespaces(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 3: {
                this.doOutputEmptyElements(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 4: {
                this.setAutomaticNsPrefix(value.toString());
                break;
            }
            case 5: {
                this.doValidateNamespaces(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 6: {
                this.doValidateContent(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 7: {
                this.doValidateContent(ArgUtil.convertToBoolean(name, value));
                break;
            }
            case 8: {
                this.doValidateAttributes(ArgUtil.convertToBoolean(name, value));
                break;
            }
            default: {
                throw new Error("Internal error: no handler for property with internal id " + id + ".");
            }
        }
    }

    public int getConfigFlags() {
        return this.mConfigFlags;
    }

    public boolean automaticNamespacesEnabled() {
        return this.hasConfigFlag(2);
    }

    public boolean willSupportNamespaces() {
        return this.hasConfigFlag(1);
    }

    public boolean willOutputEmptyElements() {
        return this.hasConfigFlag(4);
    }

    public String getAutomaticNsPrefix() {
        return this.mAutoNsPrefix;
    }

    public boolean willValidateNamespaces() {
        return this.hasConfigFlag(8);
    }

    public boolean willValidateStructure() {
        return this.hasConfigFlag(16);
    }

    public boolean willValidateContent() {
        return this.hasConfigFlag(32);
    }

    public boolean willValidateAttributes() {
        return this.hasConfigFlag(64);
    }

    public void enableAutomaticNamespaces(boolean state) {
        this.setConfigFlag(2, state);
    }

    public void doSupportNamespaces(boolean state) {
        this.setConfigFlag(1, state);
    }

    public void doOutputEmptyElements(boolean state) {
        this.setConfigFlag(4, state);
    }

    public void setAutomaticNsPrefix(String prefix) {
        this.mAutoNsPrefix = prefix;
    }

    public void doValidateNamespaces(boolean state) {
        this.setConfigFlag(8, state);
    }

    public void doValidateStructure(boolean state) {
        this.setConfigFlag(16, state);
    }

    public void doValidateContent(boolean state) {
        this.setConfigFlag(32, state);
    }

    public void doValidateAttributes(boolean state) {
        this.setConfigFlag(64, state);
    }

    public void configureForMaxValidation() {
        this.doValidateAttributes(true);
        this.doValidateContent(true);
        this.doValidateNamespaces(true);
        this.doValidateStructure(true);
    }

    public void configureForMinValidation() {
        this.doValidateAttributes(false);
        this.doValidateContent(false);
        this.doValidateNamespaces(false);
        this.doValidateStructure(false);
    }

    private void setConfigFlag(int flag, boolean state) {
        this.mConfigFlags = state ? (this.mConfigFlags |= flag) : (this.mConfigFlags &= ~flag);
    }

    private boolean hasConfigFlag(int flag) {
        return (this.mConfigFlags & flag) == flag;
    }

    private int getPropertyId(String id) {
        Integer I = (Integer)sProperties.get(id);
        if (I == null) {
            throw new IllegalArgumentException("Property '" + id + "' not supported.");
        }
        return I;
    }

    static {
        sProperties.put("javax.xml.stream.isRepairingNamespaces", new Integer(1));
        sProperties.put("com.ctc.wstx.outputEnableNS", new Integer(2));
        sProperties.put("com.ctc.wstx.outputEmptyElements", new Integer(3));
        sProperties.put("com.ctc.wstx.outputValidateNS", new Integer(5));
        sProperties.put("com.ctc.wstx.outputValidateStructure", new Integer(6));
        sProperties.put("com.ctc.wstx.outputValidateContent", new Integer(7));
        sProperties.put("com.ctc.wstx.outputValidateAttr", new Integer(8));
    }
}

