/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.evt;

import com.ctc.wstx.stax.dtd.DTDSubset;
import com.ctc.wstx.stax.evt.CompactStartElement;
import com.ctc.wstx.stax.evt.WCharacters;
import com.ctc.wstx.stax.evt.WComment;
import com.ctc.wstx.stax.evt.WDTD;
import com.ctc.wstx.stax.evt.WEndDocument;
import com.ctc.wstx.stax.evt.WEndElement;
import com.ctc.wstx.stax.evt.WEntityDeclaration;
import com.ctc.wstx.stax.evt.WEntityReference;
import com.ctc.wstx.stax.evt.WProcInstr;
import com.ctc.wstx.stax.evt.WStartDocument;
import com.ctc.wstx.stax.stream.BasicStreamReader;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class DefaultEventAllocator
implements XMLEventAllocator,
XMLStreamConstants {
    static final DefaultEventAllocator sRootInstance = new DefaultEventAllocator();

    public static DefaultEventAllocator rootInstance() {
        return sRootInstance;
    }

    public XMLEvent allocate(XMLStreamReader r) {
        Location loc = r.getLocation();
        switch (r.getEventType()) {
            case 12: {
                return new WCharacters(loc, r.getText(), true);
            }
            case 4: {
                return new WCharacters(loc, r.getText(), false);
            }
            case 5: {
                return new WComment(loc, r.getText());
            }
            case 11: {
                String fullText;
                DTDSubset ss;
                if (r instanceof BasicStreamReader) {
                    BasicStreamReader wr = (BasicStreamReader)r;
                    ss = wr.getDTD();
                    fullText = wr.getDTDText();
                } else {
                    ss = null;
                    fullText = r.getText();
                }
                return new WDTD(loc, fullText, ss);
            }
            case 8: {
                return new WEndDocument(loc);
            }
            case 2: {
                return new WEndElement(loc, r);
            }
            case 3: {
                return new WProcInstr(loc, r.getPITarget(), r.getPIData());
            }
            case 6: {
                WCharacters ch = new WCharacters(loc, r.getText(), false);
                ch.setWhitespaceStatus(true);
                return ch;
            }
            case 7: {
                return new WStartDocument(loc, r);
            }
            case 1: {
                return CompactStartElement.construct(loc, r);
            }
            case 9: {
                WEntityDeclaration ed = ((BasicStreamReader)r).getCurrentEntityDecl();
                return new WEntityReference(loc, ed.getName(), ed);
            }
            case 15: {
                throw new Error("Internal error: should not get ENTITY_DECLARATION.");
            }
            case 14: {
                throw new Error("Internal error: should not get NOTATION_DECLARATION.");
            }
            case 13: {
                throw new Error("Internal error: should not get NAMESPACE.");
            }
            case 10: {
                throw new Error("Internal error: should not get ATTRIBUTE.");
            }
        }
        throw new Error("Unrecognized event type " + r.getEventType() + ".");
    }

    public void allocate(XMLStreamReader r, XMLEventConsumer consumer) throws XMLStreamException {
        consumer.add(this.allocate(r));
    }

    public XMLEventAllocator newInstance() {
        return sRootInstance;
    }
}

