/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.evt;

import com.ctc.wstx.stax.evt.WAttribute;
import com.ctc.wstx.util.EmptyIterator;
import com.ctc.wstx.util.SingletonIterator;
import com.ctc.wstx.util.XMLQuoter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.events.Attribute;

public final class WAttrList {
    protected static final String DEFAULT_NS_URI = "";
    private static final int OFFSET_LOCAL_NAME = 0;
    private static final int OFFSET_NS_URI = 1;
    private static final int OFFSET_NS_PREFIX = 2;
    private static final int OFFSET_VALUE = 3;
    private final Location mLocation;
    private final String[] mRawAttrs;
    private ArrayList mAttrList = null;
    private final int[] mAttrMap;
    private final int mAttrHashSize;
    private final int mAttrSpillEnd;

    public WAttrList(Location loc) {
        this.mLocation = loc;
        String[] strs = EmptyIterator.getEmptyStringArray();
        this.mRawAttrs = strs;
        this.mAttrMap = null;
        this.mAttrHashSize = 0;
        this.mAttrSpillEnd = 0;
    }

    public WAttrList(Location loc, String[] rawAttrs) {
        this.mLocation = loc;
        this.mRawAttrs = rawAttrs;
        this.mAttrMap = null;
        this.mAttrHashSize = 0;
        this.mAttrSpillEnd = 0;
    }

    public WAttrList(Location loc, String[] rawAttrs, int[] attrMap, int hashSize, int spillEnd) {
        this.mLocation = loc;
        this.mRawAttrs = rawAttrs;
        this.mAttrMap = attrMap;
        this.mAttrHashSize = hashSize;
        this.mAttrSpillEnd = spillEnd;
    }

    public Attribute getAttr(QName name) {
        if (this.mAttrMap == null) {
            String ln = name.getLocalPart();
            String uri = name.getNamespaceURI();
            boolean defaultNs = uri == null || uri.length() == 0;
            String[] raw = this.mRawAttrs;
            int len = raw.length;
            for (int i = 0; i < len; i += 4) {
                if (!ln.equals(raw[i])) continue;
                String thisUri = raw[i + 1];
                if (!(defaultNs ? thisUri == null || thisUri.length() == 0 : thisUri != null && (thisUri == uri || thisUri.equals(uri)))) continue;
                return this.createAttr(i);
            }
            return null;
        }
        return this.getAttrByMap(name.getNamespaceURI(), name.getLocalPart());
    }

    public Iterator getAttrs() {
        if (this.mAttrList == null) {
            int rawLen = this.mRawAttrs.length;
            if (rawLen == 0) {
                return EmptyIterator.getInstance();
            }
            if (rawLen == 4) {
                return new SingletonIterator(this.createAttr(0));
            }
            ArrayList<WAttribute> l = new ArrayList<WAttribute>(rawLen >> 2);
            for (int i = 0; i < rawLen; i += 4) {
                l.add(this.createAttr(i));
            }
            this.mAttrList = l;
        }
        return this.mAttrList.iterator();
    }

    public void outputAttrs(Writer w) throws IOException {
        String[] raw = this.mRawAttrs;
        int len = raw.length;
        for (int i = 0; i < len; i += 4) {
            w.write(32);
            String prefix = raw[i + 2];
            if (prefix != null && prefix.length() > 0) {
                w.write(prefix);
                w.write(58);
            }
            w.write(raw[i]);
            w.write("=\"");
            XMLQuoter.outputDoubleQuotedAttr(w, raw[i + 3]);
            w.write(34);
        }
    }

    private final WAttribute createAttr(int rawIndex) {
        String[] raw = this.mRawAttrs;
        return new WAttribute(this.mLocation, raw[rawIndex], raw[rawIndex + 1], raw[rawIndex + 2], raw[rawIndex + 3]);
    }

    private final WAttribute getAttrByMap(String nsURI, String localName) {
        String thisURI;
        int hash = localName.hashCode();
        if (nsURI == null) {
            nsURI = DEFAULT_NS_URI;
        } else if (nsURI.length() > 0) {
            hash ^= nsURI.hashCode();
        }
        int ix = this.mAttrMap[hash & this.mAttrHashSize - 1];
        if (ix == 0) {
            return null;
        }
        String[] raw = this.mRawAttrs;
        String thisName = raw[ix = ix - 1 << 2];
        if ((thisName == localName || thisName.equals(localName)) && ((thisURI = raw[ix + 1]) == nsURI || thisURI.equals(nsURI))) {
            return this.createAttr(ix);
        }
        int len = this.mAttrSpillEnd;
        for (int i = this.mAttrHashSize; i < len; i += 2) {
            String thisURI2;
            if (this.mAttrMap[i] != hash || (thisName = raw[ix = this.mAttrMap[i + 1] << 2]) != localName && !thisName.equals(localName) || (thisURI2 = raw[ix + 1]) != nsURI && !thisURI2.equals(nsURI)) continue;
            return this.createAttr(ix);
        }
        return null;
    }
}

