/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.io;

import com.ctc.wstx.stax.io.BaseReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public final class UTF8Reader
extends BaseReader {
    static final char NULL_CHAR = '\u0000';
    static final char NULL_BYTE = '\u0000';
    char mSurrogate = '\u0000';
    int mCharCount = 0;
    int mByteCount = 0;

    public UTF8Reader(InputStream in, byte[] buf, int ptr, int len) {
        super(in, buf, ptr, len);
    }

    public int read(char[] cbuf, int start, int len) throws IOException {
        if (this.mBuffer == null) {
            return -1;
        }
        if (len < 1) {
            return len;
        }
        if (start < 0 || start + len > cbuf.length) {
            this.reportBounds(cbuf, start, len);
        }
        len += start;
        int outPtr = start;
        if (this.mSurrogate != '\u0000') {
            cbuf[outPtr++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        }
        if (this.mPtr >= this.mLength && !this.loadMore()) {
            return -1;
        }
        block0: do {
            byte d;
            int needed;
            int b = this.mBuffer[this.mPtr++];
            while (b >= 0) {
                cbuf[outPtr++] = (char)b;
                if (outPtr < len && this.mPtr < this.mLength) {
                    b = this.mBuffer[this.mPtr++];
                    continue;
                }
                break block0;
            }
            int c = b;
            if ((c & 0xE0) == 192) {
                c = b & 0x1F;
                needed = 1;
            } else if ((c & 0xF0) == 224) {
                c = b & 0xF;
                needed = 2;
            } else if ((c & 0xF8) == 240) {
                c = b & 0xF;
                needed = 3;
            } else {
                this.reportInvalidInitial(c & 0xFF, outPtr - start);
                needed = 1;
            }
            if (this.mLength - this.mPtr < needed) {
                this.loadMore(needed);
            }
            if (((d = this.mBuffer[this.mPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF, outPtr - start);
            }
            c = c << 6 | d & 0x3F;
            if (needed > 1) {
                if (((d = this.mBuffer[this.mPtr++]) & 0xC0) != 128) {
                    this.reportInvalidOther(d & 0xFF, outPtr - start);
                }
                c = c << 6 | d & 0x3F;
                if (needed > 2) {
                    if (((d = this.mBuffer[this.mPtr++]) & 0xC0) != 128) {
                        this.reportInvalidOther(d & 0xFF, outPtr - start);
                    }
                    c = c << 6 | d & 0x3F;
                    if (needed > 3) {
                        if (((d = this.mBuffer[this.mPtr++]) & 0xC0) != 128) {
                            this.reportInvalidOther(d & 0xFF, outPtr - start);
                        }
                        c = c << 6 | d & 0x3F;
                        cbuf[outPtr++] = (char)(55296 + ((c -= 65536) >> 10));
                        c = 0xDC00 | c & 0x3FF;
                        if (outPtr >= len) {
                            this.mSurrogate = (char)c;
                            break;
                        }
                    }
                }
            }
            cbuf[outPtr++] = (char)c;
        } while (outPtr < len && this.mPtr < this.mLength);
        len = outPtr - start;
        this.mCharCount += len;
        return len == 0 ? -1 : len;
    }

    private void reportInvalidInitial(int mask, int offset) throws IOException {
        int bytePos = this.mByteCount + this.mPtr - 1;
        int charPos = this.mCharCount + offset + 1;
        throw new CharConversionException("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask) + " (at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportInvalidOther(int mask, int offset) throws IOException {
        int bytePos = this.mByteCount + this.mPtr - 1;
        int charPos = this.mCharCount + offset;
        throw new CharConversionException("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask) + " (at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private boolean loadMore() throws IOException {
        this.mByteCount += this.mLength;
        int count = this.mIn.read(this.mBuffer);
        if (count <= 0) {
            this.mBuffer = null;
            if (count == 0) {
                this.reportStrangeStream();
            }
            return false;
        }
        this.mLength = count;
        this.mPtr = 0;
        return true;
    }

    private void loadMore(int needed) throws IOException {
        for (int i = this.mPtr; i < this.mLength; ++i) {
            this.mBuffer[i - this.mPtr] = this.mBuffer[i];
        }
        this.mLength -= this.mPtr;
        this.mPtr = 0;
        while (this.mLength < needed) {
            int count = this.mIn.read(this.mBuffer, this.mLength, this.mBuffer.length - this.mLength);
            if (count < 1) {
                this.mBuffer = null;
                if (count == 0) {
                    this.reportStrangeStream();
                }
                throw new IOException("Unexpected EOF in the middle of multi-byte UTF-8 character");
            }
            this.mLength += count;
        }
    }
}

