/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.ns;

import com.ctc.wstx.util.StringVector;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;

public final class OutputElement
implements NamespaceContext {
    public static final int PREFIX_UNBOUND = 0;
    public static final int PREFIX_OK = 1;
    public static final int PREFIX_MISBOUND = 2;
    static final OutputElement sRootInstance = new OutputElement();
    static final String sXmlNsPrefix = "xml";
    static final String sXmlNsURI = "http://www.w3.org/XML/1998/namespace";
    final OutputElement mParent;
    String mPrefix;
    final String mLocalName;
    final String mDefaultNsUri;
    final boolean mDefaultNsDeclared;
    boolean mDefaultNsOutput;
    static final String AUTOMATIC_NS_PREFIX = "wstxns";
    StringVector mNamespaces;
    boolean mNsShared;
    BitSet mNsOutput;
    int mLocalNsStart;
    int mLocalNsEnd;
    int mNextAutomaticNsId = 1;
    HashMap mAttr = null;

    public OutputElement(OutputElement parent, String localName, Declarations decl, boolean checkNs) throws XMLStreamException {
        StringVector otherNs;
        String defaultNsUri;
        this.mParent = parent;
        this.mPrefix = "";
        this.mLocalName = localName;
        this.mDefaultNsOutput = false;
        this.mNextAutomaticNsId = parent.mNextAutomaticNsId;
        if (decl == null) {
            defaultNsUri = null;
            otherNs = null;
        } else {
            defaultNsUri = decl.getDefaultNsUri();
            otherNs = decl.getNamespaces();
        }
        if (defaultNsUri == null) {
            this.mDefaultNsUri = parent.mDefaultNsUri;
            this.mDefaultNsDeclared = false;
        } else {
            this.mDefaultNsUri = defaultNsUri;
            this.mDefaultNsDeclared = true;
        }
        if (otherNs == null || otherNs.isEmpty()) {
            this.mNamespaces = parent.mNamespaces;
            this.mNsShared = true;
            this.mLocalNsEnd = 0;
            this.mLocalNsStart = 0;
            this.mNsOutput = null;
        } else {
            StringVector orig = parent.mNamespaces;
            int otherSize = otherNs.size();
            int extraSize = otherSize + 8;
            if (extraSize < 8) {
                extraSize = 8;
            }
            this.mNamespaces = orig.makeCopy(extraSize);
            this.mNsShared = false;
            this.mLocalNsStart = orig.size();
            this.mLocalNsEnd = this.mLocalNsStart + otherSize;
            this.mNsOutput = checkNs ? new BitSet(otherSize >> 1) : null;
            int len = otherNs.size();
            for (int i = 0; i < len; i += 2) {
                String prefix = otherNs.getString(i);
                String nsURI = otherNs.getString(i + 1);
                int ix = this.mNamespaces.findLastIndexNonInterned(prefix);
                if (ix >= 0) {
                    this.mNamespaces.setString(ix, null);
                    this.mNamespaces.setString(ix + 1, null);
                }
                this.mNamespaces.addStrings(prefix, nsURI);
            }
        }
    }

    private OutputElement() {
        this.mParent = null;
        this.mPrefix = "";
        this.mLocalName = "";
        this.mDefaultNsUri = "";
        this.mDefaultNsDeclared = true;
        this.mDefaultNsOutput = true;
        this.mNamespaces = new StringVector(2);
        this.mNsShared = false;
        this.mNsOutput = null;
        this.mLocalNsEnd = 0;
        this.mLocalNsStart = 0;
    }

    public static final OutputElement getRootInstance() {
        return sRootInstance;
    }

    public void setPrefix(String prefix) {
        this.mPrefix = prefix;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix.length() == 0) {
            return this.mDefaultNsUri;
        }
        return this.mNamespaces.findLastNonInterned(prefix);
    }

    public String getPrefix(String nsURI) {
        if (this.mDefaultNsUri.equals(nsURI)) {
            return "";
        }
        return this.mNamespaces.findLastByValueNonInterned(nsURI);
    }

    public Iterator getPrefixes(String nsURI) {
        return this.getPrefixes(nsURI, new ArrayList(), false);
    }

    protected Iterator getPrefixes(String nsURI, ArrayList l, boolean defaultMatched) {
        if (!defaultMatched && this.mDefaultNsUri.equals(nsURI)) {
            l.add("");
        }
        String[] strs = this.mNamespaces.getInternalArray();
        int i = this.mNamespaces.size();
        while ((i -= 2) >= 0) {
            String uri = strs[i + 1];
            if (!uri.equals(nsURI)) continue;
            l.add(strs[i]);
        }
        return l.iterator();
    }

    public OutputElement getParent() {
        return this.mParent;
    }

    public String getLocalName() {
        return this.mLocalName;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public boolean isRoot() {
        return this == sRootInstance;
    }

    public String findPrefix(String nsURI, boolean defaultNsOk) throws XMLStreamException {
        if (defaultNsOk) {
            if (nsURI == this.mDefaultNsUri) {
                return "";
            }
            if (nsURI == null ? this.mDefaultNsUri.length() == 0 : nsURI.equals(this.mDefaultNsUri)) {
                return "";
            }
        }
        if (sXmlNsURI.equals(nsURI)) {
            return sXmlNsPrefix;
        }
        return this.mNamespaces.findLastByValueNonInterned(nsURI);
    }

    public void checkDefaultNsWrite(String nsURI) throws XMLStreamException {
        if (!this.mDefaultNsDeclared) {
            throw new XMLStreamException("Default namespace not declared for element '" + this.getElementName() + "'.");
        }
        if (!nsURI.equals(this.mDefaultNsUri)) {
            throw new XMLStreamException("Default namespace declared as '" + this.mDefaultNsUri + "'; trying to output it as '" + nsURI + "'.");
        }
        this.mDefaultNsOutput = true;
    }

    public void checkNsWrite(String prefix, String nsURI) throws XMLStreamException {
        for (int i = this.mLocalNsStart; i < this.mLocalNsEnd; i += 2) {
            String currURI;
            String currPrefix = this.mNamespaces.getString(i);
            if (prefix != currPrefix && !prefix.equals(currPrefix) || (currURI = this.mNamespaces.getString(i + 1)) != nsURI && !currURI.equals(nsURI)) continue;
            int ix = i - this.mLocalNsStart >> 1;
            this.mNsOutput.set(ix);
            return;
        }
        throw new XMLStreamException("Trying to write undeclared namespace (prefix '" + prefix + "', URI '" + nsURI + "'.");
    }

    public int isPrefixValid(String prefix, String nsURI, boolean checkNS, boolean isElement) throws XMLStreamException {
        if (nsURI == null) {
            nsURI = "";
        }
        if (prefix == null || prefix.length() == 0) {
            if (!isElement) {
                return 1;
            }
            if (nsURI == this.mDefaultNsUri || nsURI.equals(this.mDefaultNsUri)) {
                return 1;
            }
            return 2;
        }
        if (prefix.equals(sXmlNsPrefix)) {
            if (checkNS && !nsURI.equals(sXmlNsURI)) {
                this.throwOutputError("Namespace prefix 'xml' can not be bound to non-default namespace ('" + nsURI + "'); has to be the default '" + sXmlNsURI + "'");
            }
            return 1;
        }
        String act = this.mNamespaces.findLastNonInterned(prefix);
        if (act == null) {
            return 0;
        }
        return act == nsURI || act.equals(nsURI) ? 1 : 2;
    }

    public void checkAttrWrite(String nsURI, String localName, String value) throws XMLStreamException {
        AttrName an = new AttrName(nsURI, localName);
        if (this.mAttr == null) {
            this.mAttr = new HashMap();
            this.mAttr.put(an, value);
        } else {
            String old = this.mAttr.put(an, value);
            if (old != null) {
                throw new XMLStreamException("Duplicate attribute write for attribute '" + an + "' (previous value '" + old + "', new value '" + value + "').");
            }
        }
    }

    public void checkAllNsWrittenOk() throws XMLStreamException {
        this.mAttr = null;
        if (this.mDefaultNsDeclared && !this.mDefaultNsOutput) {
            throw new XMLStreamException("Default namespace declared but not written, for element '" + this.getElementName() + "'.");
        }
        int count = this.mLocalNsEnd - this.mLocalNsStart >> 1;
        for (int i = 0; i < count; ++i) {
            if (this.mNsOutput.get(i)) continue;
            throw new XMLStreamException("Namespace with prefix '" + this.mNamespaces.getString(this.mLocalNsStart + i + i) + "' declared but not output in element '" + this.getElementName() + "'.");
        }
    }

    public void outputDeclaredNamespaces(Writer w) throws IOException, XMLStreamException {
        int count;
        if (this.mDefaultNsDeclared) {
            this.mDefaultNsOutput = true;
            w.write(32);
            w.write("xmlns");
            w.write("=\"");
            w.write(this.mDefaultNsUri);
            w.write(34);
        }
        if ((count = this.mLocalNsEnd - this.mLocalNsStart >> 1) > 0) {
            BitSet done = this.mNsOutput;
            if (done == null) {
                this.mNsOutput = done = new BitSet();
            }
            for (int i = 0; i < count; ++i) {
                if (done.get(i)) continue;
                done.set(i);
                w.write(32);
                w.write("xmlns");
                int ix = this.mLocalNsStart + i + i;
                String prefix = this.mNamespaces.getString(ix);
                w.write(58);
                w.write(prefix);
                w.write("=\"");
                String uri = this.mNamespaces.getString(ix + 1);
                w.write(uri);
                w.write(34);
            }
        }
    }

    public void addPrefix(String prefix, String nsURI) throws XMLStreamException {
        if (nsURI == null) {
            nsURI = "";
        }
        if (this.mNsShared) {
            StringVector orig = this.mNamespaces;
            this.mNamespaces = orig.makeCopy(8);
            this.mLocalNsStart = orig.size();
            this.mNsOutput = new BitSet();
        }
        this.mNamespaces.addStrings(prefix, nsURI);
        this.mLocalNsEnd = this.mNamespaces.size();
    }

    public String generatePrefix(NamespaceContext ctxt) {
        int nr;
        String prefix;
        do {
            ++this.mNextAutomaticNsId;
        } while (this.mNamespaces.findLastNonInterned(prefix = (AUTOMATIC_NS_PREFIX + nr).intern()) != null || ctxt != null && ctxt.getNamespaceURI(prefix) != null);
        return prefix;
    }

    public String getElementName() {
        if (this.mPrefix == null || this.mPrefix.length() == 0) {
            return this.mLocalName;
        }
        return this.mPrefix + ":" + this.mLocalName;
    }

    private void throwOutputError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg);
    }

    public static final class Declarations
    implements NamespaceContext {
        static final int TYPICAL_MAX_NS_COUNT = 8;
        final OutputElement mParent;
        private String mDefaultNsUri = null;
        private StringVector mNamespaces = null;

        public Declarations(OutputElement parent) {
            this.mParent = parent;
        }

        public String getNamespaceURI(String prefix) {
            String str;
            if (prefix.length() == 0 && this.mDefaultNsUri != null) {
                return this.mDefaultNsUri;
            }
            if (this.mNamespaces != null && (str = this.mNamespaces.findLastNonInterned(prefix)) != null) {
                return str;
            }
            return this.mParent.getNamespaceURI(prefix);
        }

        public String getPrefix(String nsURI) {
            String str;
            if (this.mDefaultNsUri != null && this.mDefaultNsUri.equals(nsURI)) {
                return "";
            }
            if (this.mNamespaces != null && (str = this.mNamespaces.findLastByValueNonInterned(nsURI)) != null) {
                return str;
            }
            return this.mParent.getPrefix(nsURI);
        }

        public Iterator getPrefixes(String nsURI) {
            boolean defaultMatches = false;
            ArrayList<String> l = new ArrayList<String>();
            if (this.mDefaultNsUri != null && this.mDefaultNsUri.equals(nsURI)) {
                l.add("");
                defaultMatches = true;
            }
            if (this.mNamespaces != null) {
                String[] strs = this.mNamespaces.getInternalArray();
                int i = this.mNamespaces.size();
                while ((i -= 2) >= 0) {
                    String uri = strs[i + 1];
                    if (!uri.equals(nsURI)) continue;
                    l.add(strs[i]);
                }
            }
            return this.mParent.getPrefixes(nsURI, l, defaultMatches);
        }

        public String getDefaultNsUri() {
            return this.mDefaultNsUri;
        }

        public StringVector getNamespaces() {
            return this.mNamespaces;
        }

        public void setDefaultNsUri(String uri) {
            this.mDefaultNsUri = uri == null ? "" : uri;
        }

        public void addNamespace(String prefix, String uri) throws XMLStreamException {
            if (uri == null) {
                uri = "";
            }
            if (prefix == null || prefix.length() == 0) {
                this.setDefaultNsUri(uri);
                return;
            }
            if (this.mNamespaces == null) {
                this.mNamespaces = new StringVector(16);
                this.mNamespaces.addStrings(prefix, uri);
                return;
            }
            String old = this.mNamespaces.findLastNonInterned(prefix);
            if (old != null) {
                if (!old.equals(uri)) {
                    throw new XMLStreamException("Trying to reset namespace with prefix '" + prefix + "'; previous URI was '" + old + "', trying to reset to '" + uri + "'.");
                }
            } else {
                this.mNamespaces.addStrings(prefix, uri);
            }
        }
    }

    static final class AttrName
    implements Comparable {
        final String mNsURI;
        final String mLocalName;
        final int mHashCode;

        public AttrName(String nsURI, String localName) {
            this.mNsURI = nsURI == null ? "" : nsURI;
            this.mLocalName = localName;
            this.mHashCode = this.mNsURI.hashCode() * 31 ^ this.mLocalName.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttrName)) {
                return false;
            }
            AttrName other = (AttrName)o;
            String otherLN = other.mLocalName;
            if (otherLN != this.mLocalName && !otherLN.equals(this.mLocalName)) {
                return false;
            }
            String otherURI = other.mNsURI;
            return otherURI == this.mNsURI || otherURI.equals(this.mNsURI);
        }

        public String toString() {
            if (this.mNsURI.length() > 0) {
                return "{" + this.mNsURI + "} " + this.mLocalName;
            }
            return this.mLocalName;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public int compareTo(Object o) {
            AttrName other = (AttrName)o;
            int result = this.mNsURI.compareTo(other.mNsURI);
            if (result == 0) {
                result = this.mLocalName.compareTo(other.mLocalName);
            }
            return result;
        }
    }
}

