/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.stream;

import com.ctc.wstx.stax.DefaultXmlSymbolTable;
import com.ctc.wstx.stax.cfg.ErrorConsts;
import com.ctc.wstx.stax.cfg.ReaderConfig;
import com.ctc.wstx.stax.dtd.DTDSubset;
import com.ctc.wstx.stax.evt.WAttrList;
import com.ctc.wstx.stax.evt.WEntityDeclaration;
import com.ctc.wstx.stax.exc.WstxException;
import com.ctc.wstx.stax.io.BranchingReaderSource;
import com.ctc.wstx.stax.io.InputBootstrapper;
import com.ctc.wstx.stax.io.WstxInputSource;
import com.ctc.wstx.stax.ns.AttributeCollector;
import com.ctc.wstx.stax.ns.BaseNsContext;
import com.ctc.wstx.stax.ns.InputElementStack;
import com.ctc.wstx.stax.ns.NonNsInputElementStack;
import com.ctc.wstx.stax.ns.NsInputElementStack;
import com.ctc.wstx.stax.stream.ReaderCreator;
import com.ctc.wstx.stax.stream.StreamScanner;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.TextBuffer;
import com.ctc.wstx.util.TextBuilder;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class BasicStreamReader
extends StreamScanner
implements XMLStreamReader {
    protected static final String DEFAULT_NS_PREFIX = null;
    protected static final String UNKNOWN_ATTR_TYPE = "CDATA";
    static final int DOC_STANDALONE_UNKNOWN = 0;
    static final int DOC_STANDALONE_YES = 1;
    static final int DOC_STANDALONE_NO = 2;
    static final int STATE_PROLOG = 0;
    static final int STATE_TREE = 1;
    static final int STATE_EPILOG = 2;
    static final int STATE_CLOSED = 3;
    private static final int MASK_GET_TEXT = 6768;
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    protected static final String sPrefixXml = DefaultXmlSymbolTable.getXmlSymbol();
    protected static final String sPrefixXmlns = DefaultXmlSymbolTable.getXmlnsSymbol();
    protected final ReaderCreator mOwner;
    String mDocInputEncoding = null;
    String mDocCharEncoding = null;
    String mDocXmlVersion = null;
    public int mDocStandalone = 0;
    String mRootPrefix;
    String mRootLName;
    protected String mDtdPublicId;
    protected String mDtdSystemId;
    protected final InputElementStack mElementStack;
    protected final AttributeCollector mAttrCollector;
    char[] mAttrBuffer = null;
    protected boolean mStDoctypeFound = false;
    protected boolean mStTokenUnfinished = false;
    protected boolean mStEmptyElem = false;
    protected boolean mStPartialCData = false;
    int mParseState;
    protected int mCurrToken = 7;
    String mCurrName;
    static final int ALL_WS_UNKNOWN = 0;
    static final int ALL_WS_YES = 1;
    static final int ALL_WS_NO = 2;
    int mWsStatus;
    protected Map mGeneralEntities = null;
    protected WEntityDeclaration mCurrEntity;
    protected int mVldContent = 3;
    protected final ReaderConfig mConfig;
    protected final int mConfigFlags;
    final boolean mCfgReplaceEntities;
    final boolean mCfgNormalizeLFs;
    final boolean mCfgCoalesceText;
    final boolean mCfgReportTextAsChars;
    final boolean mCfgLazyParsing;
    final int mShortestTextSegment;
    final Map mCustomEntities;

    protected BasicStreamReader(BranchingReaderSource input, ReaderCreator owner, ReaderConfig cfg, InputElementStack elemStack) throws IOException, XMLStreamException {
        super(input, cfg, cfg.getEntityResolver());
        this.mOwner = owner;
        this.mTextBuffer = new TextBuffer(cfg.getTextBufferLength());
        this.mConfig = cfg;
        this.mConfigFlags = cfg.getConfigFlags();
        this.mCfgReplaceEntities = (this.mConfigFlags & 4) != 0;
        this.mCfgNormalizeLFs = (this.mConfigFlags & 0x100) != 0;
        this.mCfgCoalesceText = (this.mConfigFlags & 2) != 0;
        this.mCfgReportTextAsChars = (this.mConfigFlags & 0x800) != 0;
        this.mCfgLazyParsing = (this.mConfigFlags & 0x8000) != 0;
        this.mShortestTextSegment = cfg.getShortestReportedTextSegment();
        this.mCustomEntities = cfg.getCustomInternalEntities();
        this.mElementStack = elemStack;
        this.mAttrCollector = elemStack.getAttrCollector();
        input.initInputLocation(this);
    }

    public static BasicStreamReader createBasicStreamReader(BranchingReaderSource input, ReaderCreator owner, ReaderConfig cfg, InputBootstrapper bs) throws IOException, XMLStreamException {
        BasicStreamReader sr = new BasicStreamReader(input, owner, cfg, BasicStreamReader.createElementStack(cfg));
        sr.initProlog(bs);
        return sr;
    }

    protected static InputElementStack createElementStack(ReaderConfig cfg) {
        if (cfg.willSupportNamespaces()) {
            return new NsInputElementStack(16, sPrefixXml, sPrefixXmlns);
        }
        return new NonNsInputElementStack(16);
    }

    public String getCharacterEncodingScheme() {
        return this.mDocCharEncoding;
    }

    public String getEncoding() {
        return this.mDocInputEncoding;
    }

    public String getVersion() {
        return this.mDocXmlVersion;
    }

    public boolean isStandalone() {
        return this.mDocStandalone == 1;
    }

    public boolean standaloneSet() {
        return this.mDocStandalone != 0;
    }

    public Object getProperty(String name) {
        return null;
    }

    public int getAttributeCount() {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException("Current state not START_ELEMENT.");
        }
        return this.mAttrCollector.getCount();
    }

    public String getAttributeLocalName(int index) {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException("Current state not START_ELEMENT.");
        }
        return this.mAttrCollector.getLocalName(index);
    }

    public QName getAttributeName(int index) {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException("Current state not START_ELEMENT.");
        }
        return this.mAttrCollector.getQName(index);
    }

    public String getAttributeNamespace(int index) {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException("Current state not START_ELEMENT.");
        }
        return this.mAttrCollector.getURI(index);
    }

    public String getAttributePrefix(int index) {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException("Current state not START_ELEMENT.");
        }
        return this.mAttrCollector.getPrefix(index);
    }

    public String getAttributeType(int index) {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException("Current state not START_ELEMENT.");
        }
        return UNKNOWN_ATTR_TYPE;
    }

    public String getAttributeValue(int index) {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException("Current state not START_ELEMENT.");
        }
        return this.mAttrCollector.getValue(index);
    }

    public String getAttributeValue(String nsURI, String localName) {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException("Current state not START_ELEMENT.");
        }
        return this.mAttrCollector.getValue(nsURI, localName);
    }

    public String getElementText() throws XMLStreamException {
        int type;
        if (this.mCurrToken != 1) {
            this.throwParseError("Current state not START_ELEMENT.");
        }
        String text = null;
        StringBuffer sb = null;
        while ((type = this.next()) != 2) {
            if (type == 5 || type == 3) continue;
            if ((1 << type & 0x1250) == 0) {
                this.throwParseError("Expected a text token, got " + this.tokenTypeDesc(type) + ".");
            }
            String nextText = this.getText();
            if (sb != null) {
                sb.append(nextText);
                continue;
            }
            if (text != null) {
                sb = new StringBuffer(text.length() + nextText.length());
                sb.append(text);
                sb.append(nextText);
                text = null;
                continue;
            }
            text = nextText;
        }
        if (sb != null) {
            return sb.toString();
        }
        return text == null ? "" : text;
    }

    public int getEventType() {
        if (this.mCurrToken == 12 ? this.mCfgCoalesceText || this.mCfgReportTextAsChars : this.mCurrToken == 6 && this.mCfgReportTextAsChars) {
            return 4;
        }
        return this.mCurrToken;
    }

    public String getLocalName() {
        if (this.mCurrToken == 1 || this.mCurrToken == 2) {
            return this.mElementStack.getLocalName();
        }
        if (this.mCurrToken == 9) {
            return this.mCurrEntity.getName();
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE");
    }

    public QName getName() {
        if (this.mCurrToken != 1 && this.mCurrToken != 2) {
            throw new IllegalStateException("Current state not START_ELEMENT or END_ELEMENT");
        }
        return this.mElementStack.getQName();
    }

    public NamespaceContext getNamespaceContext() {
        return this.mElementStack;
    }

    public int getNamespaceCount() {
        if (this.mCurrToken != 1 && this.mCurrToken != 2) {
            throw new IllegalStateException("Current state not START_ELEMENT or END_ELEMENT.");
        }
        return this.mElementStack.getCurrentNsCount();
    }

    public String getNamespacePrefix(int index) {
        if (this.mCurrToken != 1 && this.mCurrToken != 2) {
            throw new IllegalStateException("Current state not START_ELEMENT or END_ELEMENT.");
        }
        return this.mElementStack.getLocalNsPrefix(index);
    }

    public String getNamespaceURI() {
        if (this.mCurrToken != 1 && this.mCurrToken != 2) {
            return null;
        }
        return this.mElementStack.getNsURI();
    }

    public String getNamespaceURI(int index) {
        if (this.mCurrToken != 1 && this.mCurrToken != 2) {
            throw new IllegalStateException("Current state not START_ELEMENT or END_ELEMENT.");
        }
        return this.mElementStack.getLocalNsURI(index);
    }

    public String getNamespaceURI(String prefix) {
        if (this.mCurrToken != 1 && this.mCurrToken != 2) {
            throw new IllegalStateException("Current state not START_ELEMENT or END_ELEMENT.");
        }
        return this.mElementStack.getNamespaceURI(prefix);
    }

    public String getPIData() {
        if (this.mCurrToken != 3) {
            return null;
        }
        if (this.mStTokenUnfinished) {
            try {
                this.finishToken();
            }
            catch (Exception ie) {
                this.throwLazyError(ie);
            }
        }
        return this.mTextBuffer.contentsAsString();
    }

    public String getPITarget() {
        if (this.mCurrToken != 3) {
            return null;
        }
        return this.mCurrName;
    }

    public String getPrefix() {
        if (this.mCurrToken != 1 && this.mCurrToken != 2) {
            return null;
        }
        return this.mElementStack.getPrefix();
    }

    public String getText() {
        if ((1 << this.mCurrToken & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrToken);
        }
        if (this.mStTokenUnfinished) {
            try {
                this.finishToken();
            }
            catch (Exception ie) {
                this.throwLazyError(ie);
            }
        }
        if (this.mCurrToken == 9) {
            return this.mCurrEntity.getReplacementText();
        }
        if (this.mCurrToken == 11) {
            return this.getDTDInternalSubset();
        }
        return this.mTextBuffer.contentsAsString();
    }

    public char[] getTextCharacters() {
        if ((1 << this.mCurrToken & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrToken);
        }
        if (this.mStTokenUnfinished) {
            try {
                this.finishToken();
            }
            catch (Exception ie) {
                this.throwLazyError(ie);
            }
        }
        if (this.mCurrToken == 9) {
            return this.mCurrEntity.getReplacementChars();
        }
        if (this.mCurrToken == 11) {
            String str = this.getDTDInternalSubset();
            return str == null ? null : str.toCharArray();
        }
        return this.mTextBuffer.getTextBuffer();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int len) {
        if ((1 << this.mCurrToken & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrToken);
        }
        if (this.mStTokenUnfinished) {
            try {
                this.finishToken();
            }
            catch (Exception ie) {
                this.throwLazyError(ie);
            }
        }
        if (this.mCurrToken == 9) {
            char[] c = this.mCurrEntity.getReplacementChars();
            if (c == null) {
                return -1;
            }
            int max = c.length - sourceStart;
            if (max < len) {
                len = max;
            }
            if (len > 0) {
                System.arraycopy(c, sourceStart, target, targetStart, len);
            }
            return len;
        }
        if (this.mCurrToken == 11) {
            String str = this.getDTDInternalSubset();
            if (str == null) {
                return 0;
            }
            int max = str.length() - sourceStart;
            if (max < len) {
                len = max;
            }
            str.getChars(sourceStart, sourceStart + len, target, targetStart);
            return len;
        }
        return this.mTextBuffer.contentsToArray(sourceStart, target, targetStart, len);
    }

    public int getTextLength() {
        if ((1 << this.mCurrToken & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrToken);
        }
        if (this.mStTokenUnfinished) {
            try {
                this.finishToken();
            }
            catch (Exception ie) {
                this.throwLazyError(ie);
            }
        }
        if (this.mCurrToken == 9) {
            return this.mCurrEntity.getReplacementTextLength();
        }
        if (this.mCurrToken == 11) {
            String str = this.getDTDInternalSubset();
            return str == null ? 0 : str.length();
        }
        return this.mTextBuffer.size();
    }

    public int getTextStart() {
        if ((1 << this.mCurrToken & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrToken);
        }
        if (this.mStTokenUnfinished) {
            try {
                this.finishToken();
            }
            catch (Exception ie) {
                this.throwLazyError(ie);
            }
        }
        if (this.mCurrToken == 9 || this.mCurrToken == 11) {
            return 0;
        }
        return this.mTextBuffer.getTextStart();
    }

    public boolean hasName() {
        return this.mCurrToken == 1 || this.mCurrToken == 2;
    }

    public boolean hasNext() {
        return this.mCurrToken != 8;
    }

    public boolean hasText() {
        return (1 << this.mCurrToken & 0x1A70) != 0;
    }

    public boolean isAttributeSpecified(int index) {
        if (this.mCurrToken != 1) {
            throw new IllegalStateException("Current state not START_ELEMENT.");
        }
        return true;
    }

    public boolean isCharacters() {
        return this.mCurrToken == 4 || this.mCurrToken == 12 || this.mCurrToken == 6;
    }

    public boolean isEndElement() {
        return this.mCurrToken == 2;
    }

    public boolean isStartElement() {
        return this.mCurrToken == 1;
    }

    public boolean isWhiteSpace() {
        if (this.mCurrToken == 4 || this.mCurrToken == 12) {
            if (this.mStTokenUnfinished) {
                try {
                    this.finishToken();
                }
                catch (Exception ie) {
                    this.throwLazyError(ie);
                }
            }
            if (this.mWsStatus == 0) {
                this.mWsStatus = this.mTextBuffer.isAllWhitespace() ? 1 : 2;
            }
            return this.mWsStatus == 1;
        }
        return this.mCurrToken == 6;
    }

    public void require(int type, String nsUri, String localName) throws XMLStreamException {
        int curr = this.mCurrToken;
        if (curr != type) {
            if (curr == 12) {
                if (this.mCfgCoalesceText || this.mCfgReportTextAsChars) {
                    curr = 4;
                }
            } else if (curr == 6 && this.mCfgReportTextAsChars) {
                curr = 4;
            }
        }
        if (type != curr) {
            this.throwParseError("Expected type " + this.tokenTypeDesc(type) + ", current type " + this.tokenTypeDesc(curr));
        }
        if (localName != null) {
            String n;
            if (curr != 1 && curr != 2) {
                this.throwParseError("Expected non-null local name, but current token not a START_ELEMENT or END_ELEMENT (was " + this.tokenTypeDesc(this.mCurrToken) + ")");
            }
            if ((n = this.mElementStack.getLocalName()) != localName && !n.equals(localName)) {
                this.throwParseError("Expected local name '" + localName + "'; current local name '" + n + "'.");
            }
        }
        if (nsUri != null) {
            if (curr != 1 && curr != 2) {
                this.throwParseError("Expected non-null NS URI, but current token not a START_ELEMENT or END_ELEMENT (was " + this.tokenTypeDesc(curr) + ")");
            }
            String uri = this.mElementStack.getNsURI();
            if (nsUri.length() == 0) {
                if (uri != null && uri.length() > 0) {
                    this.throwParseError("Expected empty namespace, instead have '" + uri + "'.");
                }
            } else if (nsUri != uri && !nsUri.equals(uri)) {
                this.throwParseError("Expected namespace '" + nsUri + "'; have '" + uri + "'.");
            }
        }
    }

    public int next() throws XMLStreamException {
        block8: {
            this.mTokenInputTotal = this.mCurrInputProcessed + this.mInputPtr;
            this.mTokenInputRow = this.mCurrInputRow;
            this.mTokenInputCol = this.mInputPtr - this.mCurrInputRowStart;
            try {
                if (this.mParseState == 1) {
                    int type;
                    this.mCurrToken = type = this.nextFromTree();
                    if (!this.mCfgLazyParsing && this.mStTokenUnfinished) {
                        this.finishToken();
                    }
                    if (type == 12 ? this.mCfgCoalesceText || this.mCfgReportTextAsChars : type == 6 && this.mCfgReportTextAsChars) {
                        return 4;
                    }
                    return type;
                }
                if (this.mParseState == 0) {
                    this.nextFromProlog(true);
                    break block8;
                }
                if (this.mParseState == 2) {
                    this.nextFromProlog(false);
                    break block8;
                }
                return 8;
            }
            catch (IOException ie) {
                this.throwFromIOE(ie);
            }
        }
        if (this.mCurrToken == 6 && this.mCfgReportTextAsChars) {
            return 4;
        }
        return this.mCurrToken;
    }

    public int nextTag() throws XMLStreamException {
        block5: while (true) {
            int next = this.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (this.isWhiteSpace()) continue block5;
                    this.throwParseError("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            this.throwParseError("Received event " + ErrorConsts.tokenTypeDesc(next) + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    public void close() {
        if (this.mParseState != 3) {
            this.mParseState = 3;
            this.mCurrToken = 8;
            if (this.mSymbols.isDirty()) {
                this.mOwner.updateSymbolTable(this.mSymbols);
            }
        }
    }

    public DTDSubset getDTD() {
        return null;
    }

    public String getDTDText() {
        if (this.mCurrToken != 11) {
            return null;
        }
        return this.mTextBuffer.contentsAsString();
    }

    public String getDTDInternalSubset() {
        if (this.mCurrToken != 11) {
            return null;
        }
        String text = this.mTextBuffer.contentsAsString();
        int ix = text.indexOf(91);
        if (ix < 0) {
            return "";
        }
        int last = text.lastIndexOf(93);
        return last < 0 ? text.substring(ix + 1) : text.substring(ix + 1, last);
    }

    public String getDTDPublicId() {
        if (this.mCurrToken != 11) {
            throw new IllegalStateException("getPublicId() can only be called when stream is in DTD state.");
        }
        return this.mDtdPublicId;
    }

    public String getDTDSystemId() {
        if (this.mCurrToken != 11) {
            throw new IllegalStateException("getPublicId() can only be called when stream is in DTD state.");
        }
        return this.mDtdSystemId;
    }

    public WEntityDeclaration getCurrentEntityDecl() {
        return this.mCurrEntity;
    }

    public BaseNsContext constructNsContext(Location loc) {
        return this.mElementStack.createNonTransientNsContext(loc);
    }

    public WAttrList buildAttrList(Location loc) {
        return this.mAttrCollector.buildAttrList(loc);
    }

    public int getDepth() {
        return this.mElementStack.getDepth();
    }

    public boolean isEmptyElement() {
        return this.mStEmptyElem;
    }

    protected final boolean hasConfigFlags(int flags) {
        return (this.mConfigFlags & flags) == flags;
    }

    protected String checkKeyword(char c, String expected) throws IOException, WstxException {
        int i;
        int ptr = 0;
        int len = expected.length();
        while (expected.charAt(ptr) == c && ++ptr < len) {
            if (this.mInputPtr < this.mInputLen) {
                c = this.mInputBuffer[this.mInputPtr++];
                continue;
            }
            int ci = this.getNext();
            if (ci < 0) break;
            c = (char)ci;
        }
        if (ptr == len && ((i = this.peekNext()) < 0 || !BasicStreamReader.isNameChar((char)i) && i != 58)) {
            return null;
        }
        StringBuffer sb = new StringBuffer(expected.length() + 16);
        sb.append(expected.substring(0, ptr));
        sb.append(c);
        while (true) {
            if (this.mInputPtr < this.mInputLen) {
                c = this.mInputBuffer[this.mInputPtr++];
            } else {
                int ci = this.getNext();
                if (ci < 0) break;
                c = (char)ci;
            }
            if (!BasicStreamReader.isNameChar(c)) {
                --this.mInputPtr;
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void checkCData() throws IOException, WstxException {
        char c;
        String wrong = this.checkKeyword(this.getNextChar(" in CDATA section"), UNKNOWN_ATTR_TYPE);
        if (wrong != null) {
            this.throwParseError("Unrecognized XML directive '" + wrong + "'; expected 'CDATA'.");
        }
        if ((c = this.getNextChar(" in CDATA section")) != '[') {
            this.throwUnexpectedChar(c, "excepted '[' after '<![CDATA'");
        }
    }

    protected boolean checkEquals(String errorMsg) throws IOException, XMLStreamException {
        char c;
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(errorMsg);
        if (c <= ' ') {
            int i = this.getNextAfterWS();
            if (i < 0) {
                return false;
            }
            if (i != 61) {
                --this.mInputPtr;
                return false;
            }
        } else if (c != '=') {
            --this.mInputPtr;
            return false;
        }
        this.skipWS();
        return true;
    }

    protected void parseNonNormalizedAttrValue(char openingQuote, TextBuilder tb) throws IOException, XMLStreamException {
        char[] outBuf = tb.getCharBuffer();
        int outPtr = tb.getCharSize();
        int outLen = outBuf.length;
        WstxInputSource currScope = this.mInput;
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in attribute value");
            if (c <= ' ') {
                if (c == '\n') {
                    this.markLF();
                } else if (c == '\r') {
                    c = this.getNextChar(" in attribute value");
                    if (c != '\n') {
                        --this.mInputPtr;
                        c = this.mCfgNormalizeLFs ? (char)'\n' : '\r';
                    } else if (!this.mCfgNormalizeLFs) {
                        if (outPtr >= outLen) {
                            outBuf = tb.bufferFull(1);
                            outLen = outBuf.length;
                        }
                        outBuf[outPtr++] = 13;
                    }
                    this.markLF();
                } else if (c == '\u0000') {
                    this.throwNullChar();
                }
            } else if (c == openingQuote) {
                if (this.mInput == currScope) {
                    break;
                }
            } else if (c == '&') {
                if ((this.inputInBuffer() < 3 || (c = this.resolveSimpleEntity(true)) == '\u0000') && (c = this.fullyResolveEntity(this.mCustomEntities, this.mGeneralEntities, false)) == '\u0000') {
                    continue;
                }
            } else if (c == '<') {
                this.throwParseError("Unexpected '<'  in attribute value");
            }
            if (outPtr >= outLen) {
                outBuf = tb.bufferFull(1);
                outLen = outBuf.length;
            }
            outBuf[outPtr++] = c;
        }
        tb.setBufferSize(outPtr);
    }

    protected void parseNormalizedAttrValue(char openingQuote, TextBuilder tb) throws IOException, XMLStreamException {
        char[] outBuf = tb.getCharBuffer();
        int outPtr = tb.getCharSize();
        int outLen = outBuf.length;
        WstxInputSource currScope = this.mInput;
        while (true) {
            int c;
            block14: {
                block16: {
                    block17: {
                        block15: {
                            block13: {
                                int n = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in attribute value");
                                if (c > 32) break block13;
                                if (c == 10) {
                                    this.markLF();
                                } else if (c == 13) {
                                    c = this.getNextChar(" in attribute value");
                                    if (c != 10) {
                                        --this.mInputPtr;
                                    }
                                    this.markLF();
                                } else if (c == 0) {
                                    this.throwNullChar();
                                }
                                c = 32;
                                break block14;
                            }
                            if (c != openingQuote) break block15;
                            if (this.mInput == currScope) {
                                break;
                            }
                            break block14;
                        }
                        if (c != 38) break block16;
                        if (this.inputInBuffer() < 3) break block17;
                        char c2 = this.resolveSimpleEntity(true);
                        c = c2;
                        if (c2 != '\u0000') break block14;
                    }
                    if ((c = (int)this.fullyResolveEntity(this.mCustomEntities, this.mGeneralEntities, false)) == 0) {
                        continue;
                    }
                    break block14;
                }
                if (c == 60) {
                    this.throwParseError("Unexpected '<'  in attribute value");
                }
            }
            if (outPtr >= outLen) {
                outBuf = tb.bufferFull(1);
                outLen = outBuf.length;
            }
            outBuf[outPtr++] = c;
        }
        tb.setBufferSize(outPtr);
    }

    protected void initProlog(InputBootstrapper bs) throws IOException, XMLStreamException {
        this.mDocInputEncoding = bs.getAppEncoding();
        this.mDocCharEncoding = bs.getDeclaredEncoding();
        this.mDocXmlVersion = bs.getVersion();
        String sa = bs.getStandalone();
        this.mDocStandalone = sa == null ? 0 : ("yes".equals(sa) ? 1 : 2);
        this.mParseState = 0;
    }

    private void nextFromProlog(boolean isProlog) throws IOException, XMLStreamException {
        char c;
        int i;
        if (this.mStTokenUnfinished) {
            this.mStTokenUnfinished = false;
            i = this.skipToken();
        } else {
            i = this.getNext();
        }
        if (i <= 32 && i >= 0) {
            if (this.hasConfigFlags(4096)) {
                this.mCurrToken = 6;
                if (this.readSpacePrimary((char)i, true)) {
                    this.mStTokenUnfinished = false;
                } else if (this.mCfgLazyParsing) {
                    this.mStTokenUnfinished = true;
                } else {
                    this.mStTokenUnfinished = false;
                    this.readSpaceSecondary(true);
                }
                return;
            }
            i = this.getNextAfterWS((char)i);
        }
        if (i < 0) {
            if (isProlog) {
                this.throwUnexpectedEOF(" in prolog");
            }
            this.close();
            this.mCurrToken = 8;
            return;
        }
        if (i != 60) {
            this.throwUnexpectedChar(i, (isProlog ? " in prolog" : " in epilog") + "; expected '<'");
        }
        if ((c = this.getNextChar(isProlog ? " in prolog" : " in epilog")) == '?') {
            this.mCurrToken = 3;
            this.mStTokenUnfinished = true;
            this.mCurrName = this.parseFullName();
            this.checkPITarget(this.mCurrName);
        } else if (c == '!') {
            this.nextFromPrologBang(isProlog);
        } else if (c == '/') {
            if (isProlog) {
                this.throwParseError("Unexpected character combination '</' in prolog.");
            }
            this.throwParseError("Unexpected character combination '</' in epilog (extra close tag?).");
        } else if (c == ':' || BasicStreamReader.isNameStartChar(c)) {
            if (!isProlog) {
                this.throwParseError("Illegal to have multiple roots (start tag in epilog?).");
            }
            this.mParseState = 1;
            this.handleStartElem(c);
            if (this.mRootLName != null && this.hasConfigFlags(16) && !this.mElementStack.matches(this.mRootPrefix, this.mRootLName)) {
                String str = this.mRootPrefix == null ? this.mRootLName : this.mRootPrefix + ":" + this.mRootLName;
                this.throwParseError("Unexpected root element <" + str + ">; expected <" + this.mElementStack.getTopElementDesc() + ">.");
            }
            this.mCurrToken = 1;
        } else {
            this.throwUnexpectedChar(c, (isProlog ? " in prolog" : " in epilog") + ", after '<'.");
        }
        if (!this.mCfgLazyParsing && this.mStTokenUnfinished) {
            this.finishToken();
        }
    }

    private void nextFromPrologBang(boolean isProlog) throws IOException, XMLStreamException {
        int i = this.getNext();
        if (i < 0) {
            this.throwUnexpectedEOF(" in prolog");
        }
        if (i == 68) {
            String keyw = this.checkKeyword('D', "DOCTYPE");
            if (keyw != null) {
                this.throwParseError("Unrecognized XML directive '<!" + keyw + "' (misspelled DOCTYPE?).");
            }
            if (!isProlog) {
                this.throwParseError(ErrorConsts.ERR_DTD_IN_EPILOG);
            }
            if (this.mStDoctypeFound) {
                this.throwParseError(ErrorConsts.ERR_DTD_DUP);
            }
            this.mStDoctypeFound = true;
            this.mCurrToken = 11;
            this.startDTD();
            return;
        }
        if (i == 45) {
            char c = this.getNextChar(isProlog ? " in prolog" : " in epilog");
            if (c != '-') {
                this.throwUnexpectedChar(i, " (malformed comment?)");
            }
            this.mStTokenUnfinished = true;
            this.mCurrToken = 5;
            return;
        }
        if (i == 91 && (i = this.peekNext()) == 67) {
            this.throwUnexpectedChar(i, ErrorConsts.ERR_CDATA_IN_EPILOG);
        }
        this.throwUnexpectedChar(i, " after '<!' (malformed comment?)");
    }

    private void startDTD() throws IOException, XMLStreamException {
        char c;
        this.mTextBuffer.resetInitialized();
        this.mTextBuffer.append("<!DOCTYPE");
        ((BranchingReaderSource)this.mInput).startBranch(this.mTextBuffer, this.mInputPtr, this.mCfgNormalizeLFs);
        if (this.mCfgNsEnabled) {
            c = this.getNextCharAfterWS(" in DOCTYPE declaration");
            String str = this.parseLocalName(c);
            c = this.getNextChar(" in DOCTYPE declaration");
            if (c == ':') {
                this.mRootPrefix = str;
                this.mRootLName = this.parseLocalName(this.getNextChar("; expected an identifier"));
            } else if (c <= ' ' || c == '[' || c == '>') {
                --this.mInputPtr;
                this.mRootPrefix = null;
                this.mRootLName = str;
            } else {
                this.throwUnexpectedChar(c, " in DOCTYPE declaration; expected '[' or white space.");
            }
        } else {
            c = this.getNextCharAfterWS(" in DOCTYPE declaration");
            this.mRootLName = this.parseFullName(c);
            this.mRootPrefix = null;
        }
        c = this.getNextCharAfterWS(" in DOCTYPE declaration");
        if (c != '[' && c != '>') {
            String keyw = null;
            if (c == 'P') {
                keyw = this.checkKeyword(this.getNextChar(" in DOCTYPE declaration"), "UBLIC");
                if (keyw != null) {
                    keyw = "P" + keyw;
                } else {
                    c = this.getNextCharAfterWS(" in DOCTYPE declaration");
                    if (c != '\"' && c != '\'') {
                        this.throwUnexpectedChar(c, " in DOCTYPE declaration; expected a public identifier.");
                    }
                    this.mDtdPublicId = this.parsePublicId(c, this.mCfgNormalizeLFs, " in DOCTYPE declaration");
                    if (this.mDtdPublicId.length() == 0) {
                        this.mDtdPublicId = null;
                    }
                    if ((c = this.getNextCharAfterWS(" in DOCTYPE declaration")) != '\"' && c != '\'') {
                        this.throwParseError(" in DOCTYPE declaration; expected a system identifier.");
                    }
                    this.mDtdSystemId = this.parseSystemId(c, this.mCfgNormalizeLFs, " in DOCTYPE declaration");
                    if (this.mDtdSystemId.length() == 0) {
                        this.mDtdSystemId = null;
                    }
                }
            } else if (c == 'S') {
                this.mDtdPublicId = null;
                keyw = this.checkKeyword(this.getNextChar(" in DOCTYPE declaration"), "YSTEM");
                if (keyw != null) {
                    keyw = "S" + keyw;
                } else {
                    c = this.getNextCharAfterWS(" in DOCTYPE declaration");
                    if (c != '\"' && c != '\'') {
                        this.throwUnexpectedChar(c, " in DOCTYPE declaration; expected a system identifier.");
                    }
                    this.mDtdSystemId = this.parseSystemId(c, this.mCfgNormalizeLFs, " in DOCTYPE declaration");
                    if (this.mDtdSystemId.length() == 0) {
                        this.mDtdSystemId = null;
                    }
                }
            } else if (!BasicStreamReader.isNameStartChar(c)) {
                this.throwUnexpectedChar(c, " in DOCTYPE declaration; expected keywords 'PUBLIC' or 'SYSTEM'.");
            } else {
                --this.mInputPtr;
                keyw = this.checkKeyword(c, "SYSTEM");
            }
            if (keyw != null) {
                this.throwParseError("Unexpected keyword '" + keyw + "'; expected 'PUBLIC' or 'SYSTEM'");
            }
            c = this.getNextCharAfterWS(" in DOCTYPE declaration");
        }
        if (c != '[' && c != '>') {
            this.throwUnexpectedChar(c, " in DOCTYPE declaration; expected closing '>'.");
        }
        --this.mInputPtr;
        this.mStTokenUnfinished = true;
    }

    private int nextFromTree() throws IOException, XMLStreamException {
        char c;
        int i;
        if (this.mStTokenUnfinished) {
            this.mStTokenUnfinished = false;
            i = this.skipToken();
        } else {
            if (this.mCurrToken == 1) {
                if (this.mStEmptyElem) {
                    this.mStEmptyElem = false;
                    return 2;
                }
            } else if (this.mCurrToken == 2) {
                this.mVldContent = this.mElementStack.pop();
                if (this.mElementStack.isEmpty()) {
                    this.mParseState = 2;
                    this.nextFromProlog(false);
                    return this.mCurrToken;
                }
            } else if (this.mStPartialCData) {
                char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in CDATA section");
                if (this.readCDataPrimary(c)) {
                    return 12;
                }
                if (this.mTextBuffer.size() == 0 && this.readCDataSecondary(this.mCfgLazyParsing ? 1 : this.mShortestTextSegment)) {
                    if (this.mTextBuffer.size() > 0) {
                        return 12;
                    }
                } else {
                    this.mStTokenUnfinished = this.mTextBuffer.size() < this.mShortestTextSegment;
                    return 12;
                }
            }
            i = this.getNext();
        }
        if (i < 0) {
            this.throwUnexpectedEOF("; was expecting a close tag.");
        }
        while (i == 38) {
            if (this.mVldContent == 0) {
                this.reportInvalidContent(9);
            }
            char c3 = c = this.mCfgReplaceEntities ? this.fullyResolveEntity(this.mCustomEntities, this.mGeneralEntities, true) : this.resolveCharOnlyEntity(true);
            if (c != '\u0000') {
                if (this.mVldContent == 1 && c > ' ') {
                    this.reportInvalidContent(4);
                }
                TextBuffer tb = this.mTextBuffer;
                tb.resetInitialized();
                tb.append(c);
                this.mStTokenUnfinished = true;
                return 4;
            }
            if (!this.mCfgReplaceEntities) {
                WEntityDeclaration ed = this.resolveNonCharEntity(this.mCustomEntities, this.mGeneralEntities);
                if (ed == null) {
                    this.throwParseError("Internal error: Entity neither char nor general entity; yet no exception thrown so far");
                }
                this.mCurrEntity = ed;
                if (!ed.isParsed()) {
                    this.throwParseError("Reference to unparsed entity '" + ed.getName() + "' from content not allowed.");
                }
                return 9;
            }
            i = this.getNextChar(" in main document content");
        }
        if (i == 60) {
            c = this.getNextChar(" in start tag");
            if (c == '?') {
                if (this.mVldContent == 0) {
                    this.reportInvalidContent(3);
                }
                this.mStTokenUnfinished = true;
                this.mCurrName = this.parseFullName();
                this.checkPITarget(this.mCurrName);
                return 3;
            }
            if (c == '!') {
                int type = this.nextFromTreeCommentOrCData();
                if (this.mVldContent == 0) {
                    this.reportInvalidContent(type);
                }
                return type;
            }
            if (c == '/') {
                this.readEndElem();
                return 2;
            }
            if (c == ':' || BasicStreamReader.isNameStartChar(c)) {
                if (this.mVldContent == 0) {
                    this.reportInvalidContent(3);
                }
                this.handleStartElem(c);
                return 1;
            }
            if (c == '[') {
                this.throwUnexpectedChar(c, " in content after '<' (malformed <![CDATA[]] directive?)");
            }
            this.throwUnexpectedChar(c, " in content after '<' (malformed start element?).");
        }
        if (this.mVldContent <= 1) {
            if (this.mVldContent == 0 || i > 32) {
                this.reportInvalidContent(4);
            }
            this.mStTokenUnfinished = !this.readSpacePrimary((char)i, false);
            return 6;
        }
        this.mStTokenUnfinished = this.readTextPrimary((char)i) ? this.mCfgCoalesceText : this.mCfgCoalesceText || this.mTextBuffer.size() < this.mShortestTextSegment;
        return 4;
    }

    private void handleStartElem(char c) throws IOException, XMLStreamException {
        if (this.mCfgNsEnabled) {
            String localName;
            String prefix;
            String str = this.parseLocalName(c);
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar("; expected an identifier");
            if (c == ':') {
                prefix = str;
                c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar("; expected an identifier");
                localName = this.parseLocalName(c);
            } else {
                --this.mInputPtr;
                prefix = DEFAULT_NS_PREFIX;
                localName = str;
            }
            this.mElementStack.push(prefix, localName);
            this.handleNsAttrs();
        } else {
            this.mElementStack.push(this.parseFullName(c));
            this.handleNonNsAttrs();
        }
    }

    private void handleNsAttrs() throws IOException, XMLStreamException {
        AttributeCollector ac = this.mAttrCollector;
        boolean normalizeAttr = this.hasConfigFlags(512);
        boolean isEmpty = false;
        boolean gotDefaultNS = false;
        while (true) {
            TextBuilder tb;
            String localName;
            String prefix;
            char c;
            if ((c = this.getNextCharAfterWS(" in start tag")) == '/') {
                c = this.getNextChar(" in start tag");
                if (c != '>') {
                    this.throwUnexpectedChar(c, " expected '>'");
                }
                isEmpty = true;
                break;
            }
            if (c == '>') break;
            if (c == '<') {
                this.throwParseError("Unexpected '<' character in element (missing closing '>'?)");
            }
            String str = this.parseLocalName(c);
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar("; expected an identifier");
            if (c == ':') {
                prefix = str;
                c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar("; expected an identifier");
                localName = this.parseLocalName(c);
            } else {
                --this.mInputPtr;
                prefix = DEFAULT_NS_PREFIX;
                localName = str;
            }
            char c3 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in start tag");
            if (c <= ' ') {
                c = this.getNextCharAfterWS(c, " in start tag");
            }
            if (c != '=') {
                this.throwUnexpectedChar(c, " expected '='");
            }
            char c4 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in start tag");
            if (c <= ' ') {
                c = this.getNextCharAfterWS(c, " in start tag");
            }
            if (c != '\"' && c != '\'') {
                this.throwUnexpectedChar(c, " in start tag Expected a quote");
            }
            int startLen = -1;
            if (prefix == sPrefixXmlns) {
                tb = ac.getNsBuilder(localName);
                if (tb == null) {
                    this.throwParseError("Duplicate declaration for namespace prefix '" + localName + "'.");
                }
                startLen = tb.getCharSize();
            } else if (localName == sPrefixXmlns && prefix == DEFAULT_NS_PREFIX) {
                tb = ac.getDefaultNsBuilder();
                if (null == tb) {
                    this.throwParseError("Duplicate default namespace declaration.");
                }
            } else {
                tb = ac.getAttrBuilder(prefix, localName);
            }
            tb.startNewEntry();
            if (normalizeAttr) {
                this.parseNormalizedAttrValue(c, tb);
            } else {
                this.parseNonNormalizedAttrValue(c, tb);
            }
            if (startLen < 0 || tb.getCharSize() != startLen) continue;
            this.throwParseError("Non-default namespace can not map to empty URI (as per Namespace 1.0 # 2)");
        }
        this.mVldContent = this.mElementStack.resolveElem(this, this.hasConfigFlags(1024));
        this.mStEmptyElem = isEmpty;
    }

    private void handleNonNsAttrs() throws IOException, XMLStreamException {
        AttributeCollector ac = this.mAttrCollector;
        boolean normalizeAttr = this.hasConfigFlags(512);
        boolean isEmpty = false;
        while (true) {
            char c;
            if ((c = this.getNextCharAfterWS(" in start tag")) == '/') {
                c = this.getNextChar(" in start tag");
                if (c != '>') {
                    this.throwUnexpectedChar(c, " expected '>'");
                }
                isEmpty = true;
                break;
            }
            if (c == '>') break;
            if (c == '<') {
                this.throwParseError("Unexpected '<' character in element (missing closing '>'?)");
            }
            String name = this.parseFullName(c);
            TextBuilder tb = ac.getAttrBuilder(null, name);
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in start tag");
            if (c <= ' ') {
                c = this.getNextCharAfterWS(c, " in start tag");
            }
            if (c != '=') {
                this.throwUnexpectedChar(c, " expected '='");
            }
            char c3 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in start tag");
            if (c <= ' ') {
                c = this.getNextCharAfterWS(c, " in start tag");
            }
            if (c != '\"' && c != '\'') {
                this.throwUnexpectedChar(c, " in start tag Expected a quote");
            }
            tb.startNewEntry();
            if (normalizeAttr) {
                this.parseNormalizedAttrValue(c, tb);
                continue;
            }
            this.parseNonNormalizedAttrValue(c, tb);
        }
        this.mElementStack.resolveElem(this, false);
        this.mStEmptyElem = isEmpty;
    }

    private void readEndElem() throws IOException, XMLStreamException {
        int i;
        int len;
        char c;
        if (this.mElementStack.isEmpty()) {
            this.reportExtraEndElem();
            return;
        }
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in end tag");
        if (!BasicStreamReader.isNameStartChar(c) && c != ':') {
            if (c <= ' ') {
                this.throwUnexpectedChar(c, "; missing element name?");
            }
            this.throwUnexpectedChar(c, "; expected an element name.");
        }
        String expPrefix = this.mElementStack.getPrefix();
        String expLocalName = this.mElementStack.getLocalName();
        if (expPrefix != null && expPrefix.length() > 0) {
            len = expPrefix.length();
            i = 0;
            while (true) {
                if (c != expPrefix.charAt(i)) {
                    this.reportWrongEndPrefix(expPrefix, expLocalName, i);
                    return;
                }
                if (++i >= len) break;
                c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in end tag");
            }
            char c3 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in end tag");
            if (c != ':') {
                this.reportWrongEndPrefix(expPrefix, expLocalName, i);
                return;
            }
            c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in end tag");
        } else if (c == ':') {
            c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in end tag");
        }
        len = expLocalName.length();
        i = 0;
        while (true) {
            if (c != expLocalName.charAt(i)) {
                this.reportWrongEndElem(expPrefix, expLocalName, i);
                return;
            }
            if (++i >= len) break;
            c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in end tag");
        }
        char c4 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in end tag");
        if (c <= ' ') {
            c = this.getNextCharAfterWS(c, " in end tag");
        } else if (c != '>' && (c == ':' || BasicStreamReader.isNameChar(c))) {
            this.reportWrongEndElem(expPrefix, expLocalName, len);
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, " in end tag Expected '>'.");
        }
    }

    private void reportExtraEndElem() throws IOException, XMLStreamException {
        String name = this.parseFNameForError();
        this.throwParseError("Unbalanced close tag </" + name + ">; no open start tag.");
    }

    private void reportWrongEndPrefix(String prefix, String localName, int done) throws IOException, XMLStreamException {
        --this.mInputPtr;
        String fullName = prefix + ":" + localName;
        String rest = this.parseFNameForError();
        String actName = fullName.substring(0, done) + rest;
        this.throwParseError("Unexpected close tag </" + actName + ">; expected </" + fullName + ">.");
    }

    private void reportWrongEndElem(String prefix, String localName, int done) throws IOException, XMLStreamException {
        String fullName;
        --this.mInputPtr;
        if (prefix != null && prefix.length() > 0) {
            fullName = prefix + ":" + localName;
            done += 1 + prefix.length();
        } else {
            fullName = localName;
        }
        String rest = this.parseFNameForError();
        String actName = fullName.substring(0, done) + rest;
        this.throwParseError("Unexpected close tag </" + actName + ">; expected </" + fullName + ">.");
    }

    private int nextFromTreeCommentOrCData() throws IOException, XMLStreamException {
        char c = this.getNextChar(" in main document content");
        if (c == '[') {
            this.checkCData();
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in CDATA section");
            this.mStTokenUnfinished = this.readCDataPrimary(c) ? this.mCfgCoalesceText : this.mCfgCoalesceText || this.mTextBuffer.size() < this.mShortestTextSegment;
            return 12;
        }
        if (c == '-' && this.getNextChar(" in main document content") == '-') {
            this.mStTokenUnfinished = true;
            return 5;
        }
        this.throwParseError("Unrecognized XML directive; expected CDATA or comment ('<![CDATA[' or '<!--').");
        return 0;
    }

    private int skipToken() throws IOException, XMLStreamException {
        switch (this.mCurrToken) {
            case 12: {
                if (this.mStPartialCData) {
                    this.skipCommentOrCData(" in CDATA section", ']', false);
                    this.mStPartialCData = false;
                }
                char c = this.getNextChar(" in main document content");
                if (this.mCfgCoalesceText) {
                    return this.skipCoalescedText(c);
                }
                return c;
            }
            case 5: {
                this.skipCommentOrCData(" in comment", '-', true);
                return this.getNextChar(" in main document content");
            }
            case 4: {
                char c = this.skipTokenText(this.getNextChar(" in main document content"));
                if (this.mCfgCoalesceText) {
                    return this.skipCoalescedText(c);
                }
                return c;
            }
            case 11: {
                this.finishDTD(false);
                return this.getNextChar(" in prolog");
            }
            case 3: {
                while (true) {
                    char c;
                    char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in processing instruction");
                    if (c == '?') {
                        while ((c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in processing instruction")) == '?') {
                        }
                        if (c == '>') {
                            return this.getNext();
                        }
                    }
                    if (c > '\r') continue;
                    if (c == '\n' || c == '\r') {
                        this.skipCRLF(c);
                        continue;
                    }
                    if (c != '\u0000') continue;
                    this.throwNullChar();
                }
            }
            case 6: {
                while (true) {
                    if (this.mInputPtr < this.mInputLen) {
                        char c;
                        if ((c = this.mInputBuffer[this.mInputPtr++]) > ' ') {
                            return c;
                        }
                        if (c != '\u0000') continue;
                        this.throwNullChar();
                        continue;
                    }
                    int ci = this.getNext();
                    if (ci < 0 || ci > 32) {
                        return ci;
                    }
                    if (ci != 0) continue;
                    this.throwNullChar();
                }
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                throw new IllegalStateException("skipToken() called when current token is " + this.tokenTypeDesc(this.mCurrToken));
            }
        }
        throw new IllegalStateException("Internal error: unexpected token " + this.tokenTypeDesc(this.mCurrToken));
    }

    private void skipCommentOrCData(String errorMsg, char endChar, boolean preventDoubles) throws IOException, XMLStreamException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(errorMsg);
            if (c <= '\r') {
                if (c == '\n' || c == '\r') {
                    this.skipCRLF(c);
                } else if (c == '\u0000') {
                    this.throwNullChar();
                }
            }
            if (c != endChar) continue;
            c = this.getNextChar(errorMsg);
            if (c == endChar) {
                c = this.getNextChar(errorMsg);
                if (c == '>') break;
                if (preventDoubles) {
                    this.throwParseError("String '--' not allowed in comment (missing '>'?)");
                }
                while (c == endChar) {
                    c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(errorMsg);
                }
                if (c == '>') break;
            }
            if (c > '\r') continue;
            if (c == '\n' || c == '\r') {
                this.skipCRLF(c);
                continue;
            }
            if (c != '\u0000') continue;
            this.throwNullChar();
        }
    }

    private int skipCoalescedText(char c) throws IOException, XMLStreamException {
        while (true) {
            if (c == '<') {
                if (!this.ensureInput(3)) {
                    return c;
                }
                if (this.mInputBuffer[this.mInputPtr] != '!' || this.mInputBuffer[this.mInputPtr + 1] != '[') {
                    return c;
                }
                this.mInputPtr += 2;
                this.checkCData();
                this.skipCommentOrCData(" in CDATA section", ']', false);
                c = this.getNextChar(" in main document content");
                continue;
            }
            if ((c = this.skipTokenText(c)) == '&') break;
        }
        return c;
    }

    private char skipTokenText(char c) throws IOException, XMLStreamException {
        while (c != '<') {
            if (c == '&') {
                if (this.mCfgReplaceEntities) {
                    if (this.mInputLen - this.mInputPtr < 3 || this.resolveSimpleEntity(true) == '\u0000') {
                        c = this.fullyResolveEntity(this.mCustomEntities, this.mGeneralEntities, true);
                    }
                } else if (this.resolveCharOnlyEntity(true) == '\u0000') {
                    return c;
                }
            } else if (c <= '\r') {
                if (c == '\r' || c == '\n') {
                    this.skipCRLF(c);
                } else if (c == '\u0000') {
                    this.throwNullChar();
                }
            }
            c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in document text content");
        }
        return c;
    }

    protected void finishToken() throws IOException, XMLStreamException {
        this.mStTokenUnfinished = false;
        switch (this.mCurrToken) {
            case 12: {
                if (this.mCfgCoalesceText) {
                    this.readCoalescedText(this.mCurrToken);
                } else {
                    this.readCDataSecondary(this.mShortestTextSegment);
                }
                return;
            }
            case 4: {
                if (this.mCfgCoalesceText) {
                    this.readCoalescedText(this.mCurrToken);
                } else {
                    this.readTextSecondary(this.mShortestTextSegment);
                }
                return;
            }
            case 6: {
                boolean prolog = this.mParseState != 1;
                this.readSpaceSecondary(prolog);
                return;
            }
            case 5: {
                this.readTokenComment();
                return;
            }
            case 11: {
                this.finishDTD(true);
                return;
            }
            case 3: {
                this.readTokenPI();
                return;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                throw new IllegalStateException("finishToken() called when current token is " + this.tokenTypeDesc(this.mCurrToken));
            }
        }
        throw new IllegalStateException("Internal error: unexpected token " + this.tokenTypeDesc(this.mCurrToken));
    }

    protected void finishDTD(boolean copyContents) throws IOException, XMLStreamException {
        char c;
        if (!copyContents) {
            ((BranchingReaderSource)this.mInput).endBranch(this.mInputPtr);
        }
        if ((c = this.getNextChar(" in DOCTYPE declaration")) == '[') {
            this.mConfig.getDtdReader().skipInternalSubset(this, this.mInput, this.mConfig);
            c = this.getNextCharAfterWS(" in internal DTD subset");
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, "; expected '>' to finish DOCTYPE declaration.");
        }
        if (copyContents) {
            ((BranchingReaderSource)this.mInput).endBranch(this.mInputPtr);
        }
    }

    private void readTokenComment() throws IOException, XMLStreamException {
        int ptr;
        char[] inputBuf = this.mInputBuffer;
        int inputLen = this.mInputLen;
        int start = ptr = this.mInputPtr;
        while (ptr < inputLen) {
            char c;
            if ((c = inputBuf[ptr++]) > '-') continue;
            if (c == '\n') {
                this.markLF(ptr);
                continue;
            }
            if (c == '\r') {
                if (!this.mCfgNormalizeLFs && ptr < inputLen) {
                    if (inputBuf[ptr] == '\n') {
                        ++ptr;
                    }
                    this.markLF(ptr);
                    continue;
                }
                --ptr;
                break;
            }
            if (c == '-') {
                if (ptr + 1 >= inputLen) {
                    --ptr;
                    break;
                }
                if (inputBuf[ptr] != '-') continue;
                c = inputBuf[ptr + 1];
                if (c != '>') {
                    this.throwParseError("String '--' not allowed in comment (missing '>'?)");
                }
                this.mTextBuffer.resetWithShared(inputBuf, start, ptr - start - 1);
                this.mInputPtr = ptr + 2;
                return;
            }
            if (c != '\u0000') continue;
            this.throwNullChar();
        }
        this.mInputPtr = ptr;
        this.mTextBuffer.resetWithCopy(inputBuf, start, ptr - start);
        this.readTokenComment2(this.mTextBuffer);
    }

    private void readTokenComment2(TextBuffer tb) throws IOException, XMLStreamException {
        char[] outBuf = this.mTextBuffer.getCurrentSegment();
        int outPtr = this.mTextBuffer.getCurrentSegmentSize();
        int outLen = outBuf.length;
        while (true) {
            int c;
            int n = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in comment");
            if (c <= 13) {
                if (c == 10) {
                    this.markLF();
                } else if (c == 13) {
                    if (this.skipCRLF((char)c)) {
                        if (!this.mCfgNormalizeLFs) {
                            if (outPtr >= outLen) {
                                outBuf = this.mTextBuffer.finishCurrentSegment();
                                outLen = outBuf.length;
                                outPtr = 0;
                            }
                            outBuf[outPtr++] = c;
                        }
                        c = 10;
                    } else if (this.mCfgNormalizeLFs) {
                        c = 10;
                    }
                } else if (c == 0) {
                    this.throwNullChar();
                }
            } else if (c == 45) {
                c = this.getNextChar(" in comment", tb);
                if (c == 45) {
                    c = this.getNextChar(" in comment");
                    if (c == 62) break;
                    this.throwParseError(ErrorConsts.ERR_HYPHENS_IN_COMMENT);
                    break;
                }
                c = 45;
                --this.mInputPtr;
            }
            if (outPtr >= outLen) {
                outBuf = this.mTextBuffer.finishCurrentSegment();
                outLen = outBuf.length;
                outPtr = 0;
            }
            outBuf[outPtr++] = c;
        }
        this.mTextBuffer.setCurrentLength(outPtr);
    }

    private void readTokenPI() throws IOException, XMLStreamException {
        int ptr;
        char c;
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in processing instruction");
        if (c <= ' ') {
            if (c == '\u0000') {
                this.throwNullChar();
            }
        } else {
            if (c != '?') {
                this.throwUnexpectedChar(c, "; expected \"?>\" as proc. instr. end marker.");
            }
            if ((c = this.getNextChar(" in processing instruction")) != '>') {
                this.throwUnexpectedChar(c, "; expected '>' (as part of \"?>\") as proc. instr. end marker.");
            }
            this.mTextBuffer.resetWithEmpty();
            return;
        }
        int start = ptr = --this.mInputPtr;
        char[] inputBuf = this.mInputBuffer;
        int inputLen = this.mInputLen;
        char[] outBuf = this.mTextBuffer.getCurrentSegment();
        int outPtr = this.mTextBuffer.getCurrentSegmentSize();
        block0: while (ptr < inputLen) {
            if ((c = inputBuf[ptr++]) <= '\r') {
                if (c == '\n') {
                    this.markLF(ptr);
                    continue;
                }
                if (c == '\r') {
                    if (ptr < inputLen && !this.mCfgNormalizeLFs) {
                        if (inputBuf[ptr] == '\n') {
                            ++ptr;
                        }
                        this.markLF(ptr);
                        continue;
                    }
                    --ptr;
                    break;
                }
                if (c != '\u0000') continue;
                this.throwNullChar();
                continue;
            }
            if (c != '?') continue;
            do {
                if (ptr >= inputLen) {
                    --ptr;
                    break block0;
                }
                if ((c = inputBuf[ptr++]) != '>') continue;
                this.mInputPtr = ptr;
                this.mTextBuffer.resetWithShared(inputBuf, start, ptr - start - 2);
                return;
            } while (c == '?');
            --ptr;
        }
        this.mInputPtr = ptr;
        this.mTextBuffer.resetWithCopy(inputBuf, start, ptr - start);
        this.readTokenPI2(this.mTextBuffer);
    }

    private void readTokenPI2(TextBuffer tb) throws IOException, XMLStreamException {
        char[] inputBuf = this.mInputBuffer;
        int inputLen = this.mInputLen;
        int inputPtr = this.mInputPtr;
        char[] outBuf = tb.getCurrentSegment();
        int outPtr = tb.getCurrentSegmentSize();
        block0: while (true) {
            int c;
            if (inputPtr >= inputLen) {
                this.loadMore(" in processing instruction");
                inputBuf = this.mInputBuffer;
                inputPtr = this.mInputPtr;
                inputLen = this.mInputLen;
            }
            if ((c = inputBuf[inputPtr++]) <= 13) {
                if (c == 10) {
                    this.markLF(inputPtr);
                } else if (c == 13) {
                    this.mInputPtr = inputPtr;
                    if (this.skipCRLF((char)c)) {
                        if (!this.mCfgNormalizeLFs) {
                            if (outPtr >= outBuf.length) {
                                outBuf = this.mTextBuffer.finishCurrentSegment();
                                outPtr = 0;
                            }
                            outBuf[outPtr++] = c;
                        }
                        c = 10;
                    } else if (this.mCfgNormalizeLFs) {
                        c = 10;
                    }
                    inputPtr = this.mInputPtr;
                    inputBuf = this.mInputBuffer;
                    inputLen = this.mInputLen;
                } else if (c == 0) {
                    this.throwNullChar();
                }
            } else if (c == 63) {
                this.mInputPtr = inputPtr;
                while (true) {
                    int n = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in processing instruction");
                    if (c == 62) break block0;
                    if (c != 63) break;
                    if (outPtr >= outBuf.length) {
                        outBuf = tb.finishCurrentSegment();
                        outPtr = 0;
                    }
                    outBuf[outPtr++] = c;
                }
                inputPtr = --this.mInputPtr;
                inputBuf = this.mInputBuffer;
                inputLen = this.mInputLen;
                c = 63;
            }
            if (outPtr >= outBuf.length) {
                outBuf = tb.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = c;
        }
        tb.setCurrentLength(outPtr);
    }

    private void readCoalescedText(int currType) throws IOException, XMLStreamException {
        boolean wasCData;
        if (currType == 4 || currType == 6) {
            this.readTextSecondary(Integer.MAX_VALUE);
            wasCData = false;
        } else if (currType == 12) {
            if (this.mStPartialCData) {
                this.readCDataSecondary(Integer.MAX_VALUE);
            }
            wasCData = true;
        } else {
            throw new IllegalStateException("Internal error: unexpected token " + this.tokenTypeDesc(this.mCurrToken) + "; expected CHARACTERS, CDATA or SPACE.");
        }
        while (true) {
            char c;
            if (this.mInputPtr >= this.mInputLen) {
                this.mTextBuffer.ensureNotShared();
                if (!this.loadMore()) break;
            }
            if ((c = this.mInputBuffer[this.mInputPtr]) == '<') {
                if (this.mInputLen - this.mInputPtr < 3) {
                    this.mTextBuffer.ensureNotShared();
                    if (!this.ensureInput(3)) break;
                }
                if (this.mInputBuffer[this.mInputPtr + 1] != '!' || this.mInputBuffer[this.mInputPtr + 2] != '[') break;
                this.mInputPtr += 3;
                this.checkCData();
                this.readCDataSecondary(Integer.MAX_VALUE);
                wasCData = true;
                continue;
            }
            if (c == '&' && !wasCData) break;
            this.readTextSecondary(Integer.MAX_VALUE);
            wasCData = false;
        }
    }

    private boolean readCDataPrimary(char c) throws IOException, XMLStreamException {
        this.mWsStatus = c <= ' ' ? 0 : 2;
        int ptr = this.mInputPtr;
        int inputLen = this.mInputLen;
        char[] inputBuf = this.mInputBuffer;
        int start = ptr - 1;
        while (true) {
            block18: {
                if (c <= '\r') {
                    if (c == '\n') {
                        this.markLF(ptr);
                    } else if (c == '\r') {
                        if (ptr >= inputLen) {
                            --ptr;
                            break;
                        }
                        if (this.mCfgNormalizeLFs) {
                            if (inputBuf[ptr] == '\n') {
                                --ptr;
                                break;
                            }
                            inputBuf[ptr - 1] = 10;
                        } else if (inputBuf[ptr] == '\n') {
                            ++ptr;
                        }
                        this.markLF(ptr);
                    } else if (c == '\u0000') {
                        this.throwNullChar();
                    }
                } else if (c == ']') {
                    if (ptr + 1 >= inputLen) {
                        --ptr;
                        break;
                    }
                    if (inputBuf[ptr] == ']') {
                        ++ptr;
                        do {
                            if (ptr >= inputLen) {
                                ptr -= 2;
                                break block18;
                            }
                            if ((c = inputBuf[ptr++]) != '>') continue;
                            this.mInputPtr = ptr;
                            this.mTextBuffer.resetWithShared(inputBuf, start, ptr -= start + 3);
                            this.mStPartialCData = false;
                            return true;
                        } while (c == ']');
                        --ptr;
                    }
                }
            }
            if (ptr >= inputLen) break;
            c = inputBuf[ptr++];
        }
        this.mInputPtr = ptr;
        this.mTextBuffer.resetWithShared(inputBuf, start, ptr - start);
        this.mStPartialCData = true;
        return false;
    }

    private boolean readCDataSecondary(int shortestSegment) throws IOException, XMLStreamException {
        char[] inputBuf = this.mInputBuffer;
        int inputLen = this.mInputLen;
        int inputPtr = this.mInputPtr;
        char[] outBuf = this.mTextBuffer.getCurrentSegment();
        int outPtr = this.mTextBuffer.getCurrentSegmentSize();
        while (true) {
            int c;
            block13: {
                block11: {
                    block14: {
                        block12: {
                            if (inputPtr >= inputLen) {
                                this.loadMore(" in CDATA section");
                                inputBuf = this.mInputBuffer;
                                inputPtr = this.mInputPtr;
                                inputLen = this.mInputLen;
                            }
                            if ((c = inputBuf[inputPtr++]) > 13) break block11;
                            if (c != 10) break block12;
                            this.markLF(inputPtr);
                            break block13;
                        }
                        if (c != 13) break block14;
                        this.mInputPtr = inputPtr;
                        if (this.skipCRLF((char)c)) {
                            if (!this.mCfgNormalizeLFs) {
                                outBuf[outPtr++] = c;
                                if (outPtr >= outBuf.length) {
                                    outBuf = this.mTextBuffer.finishCurrentSegment();
                                    outPtr = 0;
                                }
                            }
                            c = 10;
                        } else if (this.mCfgNormalizeLFs) {
                            c = 10;
                        }
                        inputPtr = this.mInputPtr;
                        inputBuf = this.mInputBuffer;
                        inputLen = this.mInputLen;
                        break block13;
                    }
                    if (c != 0) break block13;
                    this.throwNullChar();
                    break block13;
                }
                if (c == 93) {
                    this.mInputPtr = inputPtr;
                    if (this.checkCDataEnd(outBuf, outPtr)) {
                        this.mStPartialCData = false;
                        return true;
                    }
                    inputPtr = this.mInputPtr;
                    inputBuf = this.mInputBuffer;
                    inputLen = this.mInputLen;
                    outBuf = this.mTextBuffer.getCurrentSegment();
                    outPtr = this.mTextBuffer.getCurrentSegmentSize();
                    continue;
                }
            }
            outBuf[outPtr++] = c;
            if (outPtr < outBuf.length) continue;
            TextBuffer tb = this.mTextBuffer;
            if (!this.mCfgCoalesceText) {
                tb.setCurrentLength(outBuf.length);
                if (tb.size() >= this.mShortestTextSegment) {
                    this.mInputPtr = inputPtr;
                    this.mStPartialCData = true;
                    return false;
                }
            }
            outBuf = tb.finishCurrentSegment();
            outPtr = 0;
        }
    }

    private boolean checkCDataEnd(char[] outBuf, int outPtr) throws IOException, XMLStreamException {
        boolean match;
        char c;
        int bracketCount = 0;
        do {
            ++bracketCount;
        } while ((c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in CDATA section")) == ']');
        boolean bl = match = bracketCount >= 2 && c == '>';
        if (match) {
            bracketCount -= 2;
        }
        while (bracketCount > 0) {
            --bracketCount;
            outBuf[outPtr++] = 93;
            if (outPtr < outBuf.length) continue;
            outBuf = this.mTextBuffer.finishCurrentSegment();
            outPtr = 0;
        }
        this.mTextBuffer.setCurrentLength(outPtr);
        if (match) {
            return true;
        }
        --this.mInputPtr;
        return false;
    }

    private boolean readTextPrimary(char c) throws IOException, XMLStreamException {
        this.mWsStatus = c <= ' ' ? 0 : 2;
        int ptr = this.mInputPtr;
        char[] inputBuf = this.mInputBuffer;
        int inputLen = this.mInputLen;
        int start = ptr - 1;
        while (true) {
            if (c < '?') {
                if (c == '<') {
                    this.mInputPtr = --ptr;
                    this.mTextBuffer.resetWithShared(inputBuf, start, ptr - start);
                    return true;
                }
                if (c == '\n') {
                    this.markLF(ptr);
                } else if (c == '\r') {
                    if (ptr >= inputLen) {
                        --ptr;
                        break;
                    }
                    if (this.mCfgNormalizeLFs) {
                        if (inputBuf[ptr] == '\n') {
                            --ptr;
                            break;
                        }
                        inputBuf[ptr - 1] = 10;
                    } else if (inputBuf[ptr] == '\n') {
                        ++ptr;
                    }
                    this.markLF(ptr);
                } else {
                    if (c == '&') {
                        --ptr;
                        break;
                    }
                    if (c == '>') {
                        if (ptr - start >= 3 && inputBuf[ptr - 3] == ']' && inputBuf[ptr - 2] == ']') {
                            this.mInputPtr = ptr;
                            this.throwParseError(ErrorConsts.ERR_BRACKET_IN_TEXT);
                        }
                    } else if (c == '\u0000') {
                        this.throwNullChar();
                    }
                }
            }
            if (ptr >= inputLen) break;
            c = inputBuf[ptr++];
        }
        this.mInputPtr = ptr;
        this.mTextBuffer.resetWithShared(inputBuf, start, ptr - start);
        return false;
    }

    private boolean readTextSecondary(int shortestSegment) throws IOException, XMLStreamException {
        char[] outBuf = this.mTextBuffer.getCurrentSegment();
        int outPtr = this.mTextBuffer.getCurrentSegmentSize();
        while (true) {
            TextBuffer tb;
            int c;
            block19: {
                block22: {
                    block23: {
                        block24: {
                            block21: {
                                block20: {
                                    int n = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in document text content");
                                    if (c >= 63) break block19;
                                    if (c != 10) break block20;
                                    this.markLF();
                                    break block19;
                                }
                                if (c == 60) {
                                    --this.mInputPtr;
                                    this.mTextBuffer.setCurrentLength(outPtr);
                                    return true;
                                }
                                if (c != 13) break block21;
                                if (this.skipCRLF((char)c)) {
                                    if (!this.mCfgNormalizeLFs) {
                                        outBuf[outPtr++] = c;
                                        if (outPtr >= outBuf.length) {
                                            outBuf = this.mTextBuffer.finishCurrentSegment();
                                            outPtr = 0;
                                        }
                                    }
                                    c = 10;
                                } else if (this.mCfgNormalizeLFs) {
                                    c = 10;
                                }
                                break block19;
                            }
                            if (c != 38) break block22;
                            if (!this.mCfgReplaceEntities) break block23;
                            if (this.mInputLen - this.mInputPtr < 3) break block24;
                            char c2 = this.resolveSimpleEntity(true);
                            c = c2;
                            if (c2 != '\u0000') break block19;
                        }
                        if ((c = (int)this.fullyResolveEntity(this.mCustomEntities, this.mGeneralEntities, true)) == 0) {
                            continue;
                        }
                        break block19;
                    }
                    c = this.resolveCharOnlyEntity(true);
                    if (c == 0) {
                        --this.mInputPtr;
                        this.mTextBuffer.setCurrentLength(outPtr);
                        return true;
                    }
                    break block19;
                }
                if (c == 62) {
                    if (outPtr >= 2) {
                        if (outBuf[outPtr - 2] == ']' && outBuf[outPtr - 1] == ']') {
                            this.throwParseError(ErrorConsts.ERR_BRACKET_IN_TEXT);
                        }
                    } else {
                        tb = this.mTextBuffer;
                        tb.setCurrentLength(outPtr);
                        if (tb.endsWith("]]")) {
                            this.throwParseError(ErrorConsts.ERR_BRACKET_IN_TEXT);
                        }
                    }
                } else if (c == 0) {
                    this.throwNullChar();
                }
            }
            outBuf[outPtr++] = c;
            if (outPtr < outBuf.length) continue;
            tb = this.mTextBuffer;
            tb.setCurrentLength(outBuf.length);
            if (tb.size() >= shortestSegment) {
                return false;
            }
            outBuf = tb.finishCurrentSegment();
            outPtr = 0;
        }
    }

    private boolean readSpacePrimary(char c, boolean prologWS) throws IOException, XMLStreamException {
        int ptr = this.mInputPtr;
        char[] inputBuf = this.mInputBuffer;
        int inputLen = this.mInputLen;
        int start = ptr - 1;
        while (true) {
            if (c > ' ') {
                if (!prologWS && c != '<') {
                    this.throwNotWS(c);
                }
                this.mInputPtr = --ptr;
                this.mTextBuffer.resetWithShared(this.mInputBuffer, start, ptr - start);
                return true;
            }
            if (c == '\n') {
                this.markLF(ptr);
            } else if (c == '\r') {
                if (ptr >= this.mInputLen) {
                    --ptr;
                    break;
                }
                if (this.mCfgNormalizeLFs) {
                    if (inputBuf[ptr] == '\n') {
                        --ptr;
                        break;
                    }
                    inputBuf[ptr - 1] = 10;
                } else if (inputBuf[ptr] == '\n') {
                    ++ptr;
                }
                this.markLF(ptr);
            } else if (c == '\u0000') {
                this.throwNullChar();
            }
            if (ptr >= inputLen) break;
            c = inputBuf[ptr++];
        }
        this.mInputPtr = ptr;
        this.mTextBuffer.resetWithShared(inputBuf, start, ptr - start);
        return false;
    }

    private void readSpaceSecondary(boolean prologWS) throws IOException, XMLStreamException {
        char[] outBuf = this.mTextBuffer.getCurrentSegment();
        int outPtr = this.mTextBuffer.getCurrentSegmentSize();
        while (true) {
            if (this.mInputPtr >= this.mInputLen && !this.loadMore()) {
                if (prologWS) break;
                this.throwUnexpectedEOF(" in document text content");
                break;
            }
            int c = this.mInputBuffer[this.mInputPtr];
            if (c > 32) {
                if (prologWS || c == 60) break;
                this.throwNotWS((char)c);
                break;
            }
            ++this.mInputPtr;
            if (c == 10) {
                this.markLF();
            } else if (c == 13) {
                if (this.skipCRLF((char)c)) {
                    if (!this.mCfgNormalizeLFs) {
                        outBuf[outPtr++] = c;
                        if (outPtr >= outBuf.length) {
                            outBuf = this.mTextBuffer.finishCurrentSegment();
                            outPtr = 0;
                        }
                    }
                    c = 10;
                } else if (this.mCfgNormalizeLFs) {
                    c = 10;
                }
            } else if (c == 0) {
                this.throwNullChar();
            }
            outBuf[outPtr++] = c;
            if (outPtr < outBuf.length) continue;
            outBuf = this.mTextBuffer.finishCurrentSegment();
            outPtr = 0;
        }
        this.mTextBuffer.setCurrentLength(outPtr);
    }

    private void throwNotTextual(int type) {
        throw new IllegalStateException("Not a textual event (" + this.tokenTypeDesc(this.mCurrToken) + ")");
    }

    private void throwNotWS(char c) throws WstxException {
        this.throwUnexpectedChar(c, "; element <" + this.mElementStack.getTopElementDesc() + "> does not allow mixed content");
    }

    private void checkPITarget(String target) throws WstxException {
        char c;
        if (target.length() == 0) {
            this.throwParseError("Missing processing instruction target.");
        }
        if (!(target.length() != 3 || (c = target.charAt(0)) != 'x' && c != 'X' || (c = target.charAt(1)) != 'm' && c != 'M' || (c = target.charAt(2)) != 'l' && c != 'L')) {
            this.throwParseError("Illegal processing instruction target ('" + target + "'); 'xml' (case insensitive) is reserved by the specs.");
        }
    }

    protected void reportInvalidContent(int evtType) throws WstxException {
        this.throwParseError("Internal error: sub-class should override method");
    }

    public SymbolTable getSymbolTable() {
        return this.mSymbols;
    }
}

