#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import time
import com.xhaus.jyson.JysonCodec as json

print "Executing RunPlan.py\n"

if bambooServer is None:
	print "No server provided."
	sys.exit(1)

contentType = 'application/json'
headers = {'accept' : 'application/json'}

def finished(brkey):
	response = request.get('/rest/api/latest/result/' + brkey, contentType=contentType, headers=headers)
	return json.loads(response.response)['finished']

def successful(brkey):
	response = request.get('/rest/api/latest/result/' + brkey, contentType=contentType, headers=headers)
	return json.loads(response.response)['successful']

def getKeyStatesAndTimes(brkey):
	response = request.get('/rest/api/latest/result/' + brkey, contentType=contentType, headers=headers)
	jsonData = json.loads(response.response)
	return (jsonData['planResultKey']['key'], jsonData['buildState'], jsonData['state'], jsonData['prettyBuildStartedTime'], jsonData['prettyBuildCompletedTime'])

credentials = CredentialsFallback(bambooServer, username, password).getCredentials()
request = HttpRequest(bambooServer, credentials['username'], credentials['password'])
response = request.post('/rest/api/latest/queue/' + projPlanKey, '{}', contentType=contentType, headers=headers)
result = json.loads(response.response)
buildNumber = result['buildNumber']
print 'Build number is ' + str(buildNumber) + '\n'
brkey = result['buildResultKey']

while (not finished(brkey)):
	time.sleep(5)

(planResultKey, buildState, state, prettyBuildStartedTime, prettyBuildCompletedTime) = getKeyStatesAndTimes(brkey)

print "Build job started at " + prettyBuildStartedTime + "\n"

if successful(brkey):
	print "Build job completed successfully at " + prettyBuildCompletedTime + "\n"
else:
	print "Build job failed at " + prettyBuildCompletedTime + "\n"
	if failTask:
		raise Exception("Build job failed at " + prettyBuildCompletedTime + "\n")
