#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from net.conjur.api import Endpoints
from net.conjur.api.clients import ResourceClient

from java.net import URI

import logging


logging.basicConfig(filename='log/plugin.log',
                            filemode='a',
                            format='%(asctime)s,%(msecs)d %(name)s %(levelname)s %(message)s',
                            datefmt='%H:%M:%S',
                            level=logging.DEBUG)

class ConjurClient(object):

    @staticmethod
    def new_instance(container):
        return ConjurClient(container.url, container.account, container.username, container.password)


    def __init__(self, url, account, username, password):
        logging.debug("Creating Conjur client for '%s', account '%s', user '%s'" % (url, account, username))

        authnUri = URI.create("%s/authn/%s/" % (url, account))
        secretsUri = URI.create("%s/secrets/%s/variable" % (url, account))

        endpoints = Endpoints(authnUri, secretsUri)

        self.resourceClient = ResourceClient(username, password, endpoints)


    def retrieve_secret(self, path):
        return self.resourceClient.retrieveSecret(path)

