/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.shell;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.shell.CollectionCompleter;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.util.GetlineCompleter;

public class ProcessQueryCompleter
implements GetlineCompleter {
    private static final String SIGAR_PACKAGE = "org.hyperic.sigar.";
    private static final Map METHODS = new HashMap();
    private static final Collection NOPS = Arrays.asList("eq", "ne", "gt", "ge", "lt", "le");
    private static final Collection SOPS = Arrays.asList("eq", "ne", "re", "ct", "ew", "sw");
    private static final Class[] NOPARAM = new Class[0];
    private static final String PROC_PREFIX = "getProc";
    private ShellBase shell;
    private GetlineCompleter m_completer;
    private Map methods;

    public ProcessQueryCompleter(ShellBase shell) {
        this.shell = shell;
        this.methods = ProcessQueryCompleter.getMethods();
        this.m_completer = new CollectionCompleter(shell, this.methods.keySet());
    }

    public static Map getMethods() {
        return METHODS;
    }

    public static Collection getMethodOpNames(Method method) {
        if (method == null) {
            return SOPS;
        }
        Class<?> rtype = method.getReturnType();
        if (rtype == Character.TYPE || rtype == Double.TYPE || rtype == Integer.TYPE || rtype == Long.TYPE) {
            return NOPS;
        }
        return SOPS;
    }

    public static boolean isSigarClass(Class type) {
        return type.getName().startsWith(SIGAR_PACKAGE);
    }

    public String complete(String line) {
        int ix = line.indexOf(".");
        if (ix == -1) {
            if (!(line = this.m_completer.complete(line)).endsWith(".") && this.methods.get(line) != null) {
                return line + ".";
            }
            return line;
        }
        String attrClass = line.substring(0, ix);
        String attr = line.substring(ix + 1, line.length());
        Method method = (Method)this.methods.get(attrClass);
        if (method == null) {
            return line;
        }
        Class<?> subtype = method.getReturnType();
        boolean isSigarClass = ProcessQueryCompleter.isSigarClass(subtype);
        int ix2 = attr.indexOf(".");
        if (ix2 != -1) {
            method = null;
            String op = attr.substring(ix2 + 1, attr.length());
            attr = attr.substring(0, ix2);
            if (isSigarClass) {
                try {
                    method = subtype.getMethod("get" + attr, NOPARAM);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            Method m = method;
            CollectionCompleter completer = new CollectionCompleter(this.shell, ProcessQueryCompleter.getMethodOpNames(m));
            String partial = completer.complete(op);
            String result = attrClass + "." + attr + "." + partial;
            if (partial.length() == 2) {
                result = result + "=";
            }
            return result;
        }
        if (isSigarClass) {
            ArrayList<String> possible = new ArrayList<String>();
            Method[] submethods = subtype.getDeclaredMethods();
            for (int i = 0; i < submethods.length; ++i) {
                Method m = submethods[i];
                if (!m.getName().startsWith("get")) continue;
                possible.add(m.getName().substring(3));
            }
            CollectionCompleter completer = new CollectionCompleter(this.shell, possible);
            String partial = completer.complete(attr);
            String result = attrClass + "." + partial;
            if (possible.contains(partial)) {
                result = result + ".";
            }
            return result;
        }
        return line;
    }

    static {
        Method[] methods = SigarProxy.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            String name = methods[i].getName();
            if (!name.startsWith(PROC_PREFIX) || (params = methods[i].getParameterTypes()).length != 1 || params[0] != Long.TYPE) continue;
            METHODS.put(name.substring(PROC_PREFIX.length()), methods[i]);
        }
    }
}

