/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.coding;

import akka.annotation.InternalApi;
import akka.http.scaladsl.coding.DeflateCompressor;
import akka.http.scaladsl.coding.GzipCompressor$;
import akka.http.scaladsl.coding.GzipDecompressor$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]a!\u0002\r\u001a\u0001e\t\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000b9\u0002A\u0011A\u0018\t\u0011I\u0002\u0001R1A\u0005RMBqA\u0010\u0001C\u0002\u0013%q\b\u0003\u0004D\u0001\u0001\u0006I\u0001\u0011\u0005\b\t\u0002\u0001\r\u0011\"\u0003F\u0011\u001dI\u0005\u00011A\u0005\n)Ca\u0001\u0015\u0001!B\u00131\u0005bB)\u0001\u0001\u0004%IA\u0015\u0005\b-\u0002\u0001\r\u0011\"\u0003X\u0011\u0019I\u0006\u0001)Q\u0005'\")a\u0006\u0001C\u00015\")1\f\u0001C)9\")A\u000e\u0001C)[\")q\u000e\u0001C)a\")!\u000f\u0001C\u0005g\")Q\u000f\u0001C\u0005m\")q\u000f\u0001C\u0005m\u001e9q0\u0007E\u00013\u0005\u0005aa\u0002\r\u001a\u0011\u0003I\u00121\u0001\u0005\u0007]Q!\t!a\u0003\t\u0013\u00055AC1A\u0005\u0002\u0005=\u0001bBA\t)\u0001\u0006I\u0001\u000b\u0002\u000f\u000fjL\u0007oQ8naJ,7o]8s\u0015\tQ2$\u0001\u0004d_\u0012Lgn\u001a\u0006\u00039u\t\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0003=}\tA\u0001\u001b;ua*\t\u0001%\u0001\u0003bW.\f7C\u0001\u0001#!\t\u0019C%D\u0001\u001a\u0013\t)\u0013DA\tEK\u001ad\u0017\r^3D_6\u0004(/Z:t_J\f\u0001cY8naJ,7o]5p]2+g/\u001a7\u0004\u0001A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\t\u0001\u0014\u0007\u0005\u0002$\u0001!)aE\u0001a\u0001Q\u0005AA-\u001a4mCR,'/F\u00015!\t)D(D\u00017\u0015\t9\u0004(A\u0002{SBT!!\u000f\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0002w\u0005!!.\u0019<b\u0013\tidG\u0001\u0005EK\u001ad\u0017\r^3s\u0003!\u0019\u0007.Z2l'VlW#\u0001!\u0011\u0005U\n\u0015B\u0001\"7\u0005\u0015\u0019%kQ\u001a3\u0003%\u0019\u0007.Z2l'Vl\u0007%\u0001\u0006iK\u0006$WM]*f]R,\u0012A\u0012\t\u0003S\u001dK!\u0001\u0013\u0016\u0003\u000f\t{w\u000e\\3b]\u0006q\u0001.Z1eKJ\u001cVM\u001c;`I\u0015\fHCA&O!\tIC*\u0003\u0002NU\t!QK\\5u\u0011\u001dyu!!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003-AW-\u00193feN+g\u000e\u001e\u0011\u0002\u0013\tLH/Z:SK\u0006$W#A*\u0011\u0005%\"\u0016BA++\u0005\u0011auN\\4\u0002\u001b\tLH/Z:SK\u0006$w\fJ3r)\tY\u0005\fC\u0004P\u0015\u0005\u0005\t\u0019A*\u0002\u0015\tLH/Z:SK\u0006$\u0007\u0005F\u00011\u0003I\u0019w.\u001c9sKN\u001cx+\u001b;i\u0005V4g-\u001a:\u0015\u0007u\u0013G\r\u0005\u0002_A6\tqL\u0003\u0002:?%\u0011\u0011m\u0018\u0002\u000b\u0005f$Xm\u0015;sS:<\u0007\"B2\u000e\u0001\u0004i\u0016!B5oaV$\b\"B3\u000e\u0001\u00041\u0017A\u00022vM\u001a,'\u000fE\u0002*O&L!\u0001\u001b\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005%R\u0017BA6+\u0005\u0011\u0011\u0015\u0010^3\u0002\u001f\u0019dWo\u001d5XSRD')\u001e4gKJ$\"!\u00188\t\u000b\u0015t\u0001\u0019\u00014\u0002!\u0019Lg.[:i/&$\bNQ;gM\u0016\u0014HCA/r\u0011\u0015)w\u00021\u0001g\u0003%)\b\u000fZ1uK\u000e\u00138\r\u0006\u0002Li\")1\r\u0005a\u0001;\u00061\u0001.Z1eKJ$\u0012!X\u0001\biJ\f\u0017\u000e\\3sQ\t\u0001\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005y\\(aC%oi\u0016\u0014h.\u00197Ba&\fab\u0012>ja\u000e{W\u000e\u001d:fgN|'\u000f\u0005\u0002$)M\u0019A#!\u0002\u0011\u0007%\n9!C\u0002\u0002\n)\u0012a!\u00118z%\u00164GCAA\u0001\u0003]!UMZ1vYR\u001cu.\u001c9sKN\u001c\u0018n\u001c8MKZ,G.F\u0001)\u0003a!UMZ1vYR\u001cu.\u001c9sKN\u001c\u0018n\u001c8MKZ,G\u000e\t\u0015\u0003)eD#aE=")
@InternalApi
public class GzipCompressor
extends DeflateCompressor {
    private Deflater deflater;
    private final int compressionLevel;
    private final CRC32 checkSum;
    private boolean headerSent;
    private long bytesRead;
    private volatile boolean bitmap$0;

    public static int DefaultCompressionLevel() {
        return GzipCompressor$.MODULE$.DefaultCompressionLevel();
    }

    private Deflater deflater$lzycompute() {
        GzipCompressor gzipCompressor = this;
        synchronized (gzipCompressor) {
            if (!this.bitmap$0) {
                this.deflater = new Deflater(this.compressionLevel, true);
                this.bitmap$0 = true;
            }
        }
        return this.deflater;
    }

    @Override
    public Deflater deflater() {
        return !this.bitmap$0 ? this.deflater$lzycompute() : this.deflater;
    }

    private CRC32 checkSum() {
        return this.checkSum;
    }

    private boolean headerSent() {
        return this.headerSent;
    }

    private void headerSent_$eq(boolean x$1) {
        this.headerSent = x$1;
    }

    private long bytesRead() {
        return this.bytesRead;
    }

    private void bytesRead_$eq(long x$1) {
        this.bytesRead = x$1;
    }

    @Override
    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        this.updateCrc(input);
        return this.header().$plus$plus(super.compressWithBuffer(input, buffer));
    }

    @Override
    public ByteString flushWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.flushWithBuffer(buffer));
    }

    @Override
    public ByteString finishWithBuffer(byte[] buffer) {
        return this.header().$plus$plus(super.finishWithBuffer(buffer)).$plus$plus(this.trailer());
    }

    private void updateCrc(ByteString input) {
        this.checkSum().update((byte[])input.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        this.bytesRead_$eq(this.bytesRead() + (long)input.length());
    }

    private ByteString header() {
        ByteString byteString;
        if (!this.headerSent()) {
            this.headerSent_$eq(true);
            byteString = GzipDecompressor$.MODULE$.Header();
        } else {
            byteString = ByteString$.MODULE$.empty();
        }
        return byteString;
    }

    /*
     * WARNING - void declaration
     */
    private ByteString trailer() {
        void var3_3;
        int crc = (int)this.checkSum().getValue();
        int tot = (int)this.bytesRead();
        ByteString trailer = GzipCompressor.int32$1(crc).$plus$plus(GzipCompressor.int32$1(tot));
        return var3_3;
    }

    private static final ByteString int32$1(int i) {
        return ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{i, i >> 8, i >> 16, i >> 24}), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    public GzipCompressor(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        super(compressionLevel);
        this.checkSum = new CRC32();
        this.headerSent = false;
        this.bytesRead = 0L;
    }

    public GzipCompressor() {
        this(GzipCompressor$.MODULE$.DefaultCompressionLevel());
    }
}

