/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshProcess
implements OverthereProcess {
    private SshConnection connection;
    private final Session session;
    private final String obfuscatedCommandLine;
    private final Session.Command command;
    private int exitValue = -1;
    private static Logger logger = LoggerFactory.getLogger(SshProcess.class);

    SshProcess(SshConnection connection, OperatingSystemFamily os, Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        this.connection = connection;
        this.session = session;
        this.obfuscatedCommandLine = commandLine.toCommandLine(os, true);
        this.command = session.exec(commandLine.toCommandLine(os, false));
    }

    @Override
    public synchronized OutputStream getStdin() {
        OverthereUtils.checkArgument(this.command != null, "Process for command line [{}] is not running", this.obfuscatedCommandLine);
        return this.command.getOutputStream();
    }

    @Override
    public synchronized InputStream getStdout() {
        OverthereUtils.checkArgument(this.command != null, "Process for command line [{}] is not running", this.obfuscatedCommandLine);
        return this.command.getInputStream();
    }

    @Override
    public synchronized InputStream getStderr() {
        OverthereUtils.checkArgument(this.command != null, "Process for command line [{}] is not running", this.obfuscatedCommandLine);
        return this.command.getErrorStream();
    }

    @Override
    public synchronized int waitFor() {
        if (this.command == null) {
            return this.exitValue;
        }
        try {
            this.command.join();
            Integer exitStatus = this.command.getExitStatus();
            logger.info("Command [{}] on {} returned exit code {}", new Object[]{this.obfuscatedCommandLine, this.connection, exitStatus});
            this.closeSession();
            if (exitStatus == null) {
                logger.warn("Command [{}] on {} could not be started. Returning exit code -1", (Object)this.obfuscatedCommandLine, (Object)this.connection);
                this.exitValue = -1;
            } else {
                this.exitValue = exitStatus;
            }
            return this.exitValue;
        }
        catch (ConnectionException e) {
            throw new RuntimeIOException(String.format("Caught exception while awaiting end of process for command [%s] on [%s]", this.obfuscatedCommandLine, this.connection), e);
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.command == null) {
            return;
        }
        this.closeSession();
    }

    @Override
    public synchronized int exitValue() {
        if (this.command != null) {
            throw new IllegalThreadStateException(String.format("Process for command [%s] on [%s] is still running", this.obfuscatedCommandLine, this.connection));
        }
        return this.exitValue;
    }

    private void closeSession() {
        if (this.session.isOpen()) {
            try {
                this.session.close();
            }
            catch (SSHException e) {
                throw new RuntimeIOException("Could not close the SSH session", e);
            }
        }
    }
}

