/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.GlobalContextManager;
import com.xebialabs.deployit.booter.local.LocalGlobalContextManager;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

final class GlobalContext {
    private final Map<String, Value> context = new ConcurrentHashMap<String, Value>();
    private final AtomicReference<GlobalContextManager> globalContextManagerReference = new AtomicReference<GlobalContextManager>(new LocalGlobalContextManager().withContext(this.context));
    public static final File DEFAULTS = new File("conf", "deployit-defaults.properties");

    GlobalContext() {
    }

    void setManager(GlobalContextManager globalContextManager) {
        this.globalContextManagerReference.set(globalContextManager.withContext(this.context));
    }

    GlobalContextManager getManager() {
        return this.globalContextManagerReference.get();
    }

    void register(PropertyDescriptor pd, String defaultValue) {
        if (defaultValue == null && !pd.isHidden()) {
            return;
        }
        this.context.put(pd.getFqn(), new Value(pd.getDescription(), defaultValue));
    }

    void register(PropertyDescriptor pd, PropertyDescriptor inheritedFrom) {
        this.context.put(pd.getFqn(), new InheritedValue(this, pd.getDescription(), inheritedFrom.getFqn(), pd.isHidden()));
    }

    String lookup(PropertyDescriptor pd) {
        return this.lookup(pd.getFqn());
    }

    String lookup(String key) {
        Value value = this.context.get(key);
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    void copyFrom(GlobalContext other) {
        Map<String, Value> copiedEntries = other.context.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Value)e.getValue()).copyInto(this)));
        this.context.putAll(copiedEntries);
    }

    void init(File defaultFile) {
        this.getManager().loadStoredDefaults(defaultFile);
        this.getManager().validateValues(defaultFile);
        this.getManager().storeDefaults(defaultFile);
    }

    static class ExplicitValue
    extends Value {
        ExplicitValue(String description, String value) {
            super(description, value);
        }

        @Override
        boolean isExplicit() {
            return true;
        }

        @Override
        Value copyInto(GlobalContext context) {
            return new ExplicitValue(this.description, this.value);
        }
    }

    static class InheritedValue
    extends Value {
        private GlobalContext context;
        private final String superTypeProperty;
        private final boolean shouldWrite;

        InheritedValue(GlobalContext context, String description, String superTypeProperty, boolean shouldWrite) {
            super(description, "");
            this.context = context;
            this.superTypeProperty = superTypeProperty;
            this.shouldWrite = shouldWrite;
        }

        @Override
        public String getValue() {
            return this.context.lookup(this.superTypeProperty);
        }

        @Override
        boolean isShouldWrite() {
            return this.shouldWrite;
        }

        String getSuperTypeProperty() {
            return this.superTypeProperty;
        }

        @Override
        Value copyInto(GlobalContext targetContext) {
            return new InheritedValue(targetContext, this.description, this.superTypeProperty, this.shouldWrite);
        }
    }

    static class Value {
        final String description;
        final String value;

        Value(String description, String value) {
            this.description = description;
            this.value = value;
        }

        boolean isExplicit() {
            return false;
        }

        boolean isShouldWrite() {
            return true;
        }

        public String getValue() {
            return this.value;
        }

        Value copyInto(GlobalContext context) {
            return new Value(this.description, this.value);
        }
    }
}

