/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.utils.CheckUtils;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.javadude.scannit.Scannit;

public class ValidationRuleConverter {
    private static final Map<String, Class<?>> ruleTypeMap = new HashMap();

    private ValidationRuleConverter() {
    }

    public static void initialize() {
        ruleTypeMap.clear();
        Set rules = Scannit.getInstance().getTypesAnnotatedWith(Rule.class);
        for (Class validationRuleAnnotation : rules) {
            Rule rule = validationRuleAnnotation.getAnnotation(Rule.class);
            ruleTypeMap.put(rule.type(), validationRuleAnnotation);
        }
    }

    public static Validator<?> makeRule(Annotation validationRuleAnnotation, Type ciType) {
        Class<? extends Annotation> vraClazz = validationRuleAnnotation.annotationType();
        ValidationRuleConverter.checkApplicability(vraClazz, ciType);
        return ValidationRuleConverter.createRule(validationRuleAnnotation, vraClazz);
    }

    public static Validator<?> makeRule(ValidationRuleSpecification ruleSpec, Type ciType) {
        Class<?> vraClazz = ValidationRuleConverter.getValidationRuleAnnotationClass(ruleSpec, ciType.toString());
        ValidationRuleConverter.checkApplicability(vraClazz, ciType);
        return ValidationRuleConverter.createRule(ruleSpec, vraClazz);
    }

    public static Validator<?> makeRule(Annotation validationRuleAnnotation, LocalPropertyDescriptor propertyDescriptor) {
        Class<? extends Annotation> vraClazz = validationRuleAnnotation.annotationType();
        ValidationRuleConverter.checkApplicability(vraClazz, propertyDescriptor);
        return ValidationRuleConverter.createRule(validationRuleAnnotation, vraClazz);
    }

    public static Validator<?> makeRule(ValidationRuleSpecification ruleSpec, LocalPropertyDescriptor propertyDescriptor) {
        Class<?> vraClazz = ValidationRuleConverter.getValidationRuleAnnotationClass(ruleSpec, propertyDescriptor.getFqn());
        ValidationRuleConverter.checkApplicability(vraClazz, propertyDescriptor);
        return ValidationRuleConverter.createRule(ruleSpec, vraClazz);
    }

    public static boolean isRule(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Rule.class);
    }

    private static Class<?> getValidationRuleAnnotationClass(ValidationRuleSpecification ruleSpec, String fqn) {
        String type = ruleSpec.getType();
        Class<?> vraClazz = ruleTypeMap.get(type);
        if (vraClazz == null) {
            throw new IllegalArgumentException(String.format("Could not find validation rule type %s defined on property %s", type, fqn));
        }
        return vraClazz;
    }

    private static Validator<?> createRule(Annotation validationRuleAnnotation, Class<?> vraClazz) {
        Rule rule = vraClazz.getAnnotation(Rule.class);
        Validator<?> validationRule = ValidationRuleConverter.instantiate(rule.clazz());
        for (Method method : vraClazz.getDeclaredMethods()) {
            Object annotationValue = ValidationRuleConverter.getAnnotationValue(validationRuleAnnotation, method);
            ReflectionUtils.setField(validationRule, method.getName(), annotationValue);
        }
        return validationRule;
    }

    private static Validator<?> createRule(ValidationRuleSpecification ruleSpec, Class<?> vraClazz) {
        Validator<?> validationRule = ValidationRuleConverter.instantiate(vraClazz.getAnnotation(Rule.class).clazz());
        ruleSpec.getProperties().forEach((key, value) -> ReflectionUtils.setFieldWithConversion(validationRule, key, value));
        return validationRule;
    }

    private static void checkApplicability(Class<?> vraClazz, Type ciType) {
        if (vraClazz.isAnnotationPresent(Target.class)) {
            Target annotation = vraClazz.getAnnotation(Target.class);
            CheckUtils.checkArgument(Arrays.asList(annotation.value()).contains((Object)ElementType.TYPE), "Validation rule [%s] is not applicable to type [%s], because it is not a type level validation", vraClazz.getAnnotation(Rule.class).type(), ciType);
        }
    }

    private static void checkApplicability(Class<?> vraClazz, LocalPropertyDescriptor propertyDescriptor) {
        if (vraClazz.isAnnotationPresent(ApplicableTo.class)) {
            List<PropertyKind> propertyKinds = Arrays.asList(vraClazz.getAnnotation(ApplicableTo.class).value());
            CheckUtils.checkArgument(propertyKinds.contains(propertyDescriptor.getKind()), "Validation rule [%s] is not applicable to property [%s], because it is not of type(s) %s", vraClazz.getAnnotation(Rule.class).type(), propertyDescriptor.getFqn(), propertyKinds);
        }
        if (vraClazz.isAnnotationPresent(Target.class)) {
            Target annotation = vraClazz.getAnnotation(Target.class);
            CheckUtils.checkArgument(Arrays.asList(annotation.value()).contains((Object)ElementType.FIELD), "Validation rule [%s] is not applicable to property [%s], because it is not a property level validation", vraClazz.getAnnotation(Rule.class).type(), propertyDescriptor.getFqn());
        }
    }

    private static Validator<?> instantiate(Class<? extends Validator<?>> rule) {
        try {
            return rule.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Cannot instantiate validation rule " + rule, e);
        }
    }

    private static Object getAnnotationValue(Annotation validationRuleAnnotation, Method method) {
        try {
            return method.invoke((Object)validationRuleAnnotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not invoke method.", e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not convert validation rule.");
        }
    }

    static {
        ValidationRuleConverter.initialize();
    }
}

