/*
 * Decompiled with CFR 0.152.
 */
package akka.http.shaded.com.twitter.hpack;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class HuffmanDecoder {
    private static final IOException EOS_DECODED = new IOException("EOS Decoded");
    private static final IOException INVALID_PADDING = new IOException("Invalid Padding");
    private final Node root;

    HuffmanDecoder(int[] nArray, byte[] byArray) {
        if (nArray.length != 257 || nArray.length != byArray.length) {
            throw new IllegalArgumentException("invalid Huffman coding");
        }
        this.root = HuffmanDecoder.buildTree(nArray, byArray);
    }

    public byte[] decode(byte[] byArray) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Node node = this.root;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < byArray.length; ++n) {
            int n4 = byArray[n] & 0xFF;
            n2 = n2 << 8 | n4;
            n3 += 8;
            while (n3 >= 8) {
                int n5 = n2 >>> n3 - 8 & 0xFF;
                node = node.children[n5];
                n3 -= node.bits;
                if (!node.isTerminal()) continue;
                if (node.symbol == 256) {
                    throw EOS_DECODED;
                }
                byteArrayOutputStream.write(node.symbol);
                node = this.root;
            }
        }
        while (n3 > 0) {
            n = n2 << 8 - n3 & 0xFF;
            if (!(node = node.children[n]).isTerminal() || node.bits > n3) break;
            n3 -= node.bits;
            byteArrayOutputStream.write(node.symbol);
            node = this.root;
        }
        if ((n2 & (n = (1 << n3) - 1)) != n) {
            throw INVALID_PADDING;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static Node buildTree(int[] nArray, byte[] byArray) {
        Node node = new Node();
        for (int i = 0; i < nArray.length; ++i) {
            HuffmanDecoder.insert(node, i, nArray[i], byArray[i]);
        }
        return node;
    }

    private static void insert(Node node, int n, int n2, byte by) {
        Node node2 = node;
        while (by > 8) {
            if (node2.isTerminal()) {
                throw new IllegalStateException("invalid Huffman code: prefix not unique");
            }
            by = (byte)(by - 8);
            int n3 = n2 >>> by & 0xFF;
            if (node2.children[n3] == null) {
                ((Node)node2).children[n3] = new Node();
            }
            node2 = node2.children[n3];
        }
        Node node3 = new Node(n, by);
        int n4 = 8 - by;
        int n5 = n2 << n4 & 0xFF;
        int n6 = 1 << n4;
        for (int i = n5; i < n5 + n6; ++i) {
            ((Node)node2).children[i] = node3;
        }
    }

    private static final class Node {
        private final int symbol;
        private final int bits;
        private final Node[] children;

        private Node() {
            this.symbol = 0;
            this.bits = 8;
            this.children = new Node[256];
        }

        private Node(int n, int n2) {
            assert (n2 > 0 && n2 <= 8);
            this.symbol = n;
            this.bits = n2;
            this.children = null;
        }

        private boolean isTerminal() {
            return this.children == null;
        }
    }
}

