/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.util.PropertyUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class ServerConfigFile {
    private final File configFile;
    private static final Logger logger = LoggerFactory.getLogger(ServerConfigFile.class);

    public ServerConfigFile(File file) {
        this.configFile = file;
    }

    public boolean exists() {
        return this.configFile.exists();
    }

    public String getName() {
        return this.configFile.getName();
    }

    public void readIntoConfiguration(ServerConfiguration serverConfiguration) {
        serverConfiguration.load(ServerConfigFile.readConfigurationFile(this.configFile));
    }

    public ServerConfiguration loadConfig() {
        return this.loadConfig(true, true);
    }

    public ServerConfiguration loadConfig(boolean saveDirty, boolean encryptedPasswords) {
        return this.loadConfig(saveDirty, encryptedPasswords, false);
    }

    public ServerConfiguration loadConfig(boolean saveDirty, boolean encryptedPasswords, boolean cloudConfigEnabled) {
        if (this.configFile.exists()) {
            ServerConfiguration serverConfiguration = ServerConfigFile.readConfiguration(this.configFile, encryptedPasswords, cloudConfigEnabled);
            if (!serverConfiguration.isValid()) {
                throw new Error("Configuration " + this.configFile + " is not valid please run with -setup option.");
            }
            if (saveDirty) {
                this.saveDirtyConfiguration(serverConfiguration);
            }
            return serverConfiguration;
        }
        throw new Error("Configuration " + this.configFile + " does not exist, please run with -setup option before starting the server or command line interface.");
    }

    static ServerConfiguration readConfiguration(File configFile, boolean encryptedPasswords) {
        return ServerConfigFile.readConfiguration(configFile, encryptedPasswords, false);
    }

    static ServerConfiguration readConfiguration(File configFile, boolean encryptedPasswords, boolean cloudConfigEnabled) {
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        serverConfiguration.setSpringCloudEnabled(cloudConfigEnabled);
        serverConfiguration.setFile(configFile);
        serverConfiguration.setConfigResource((Resource)new ClassPathResource(configFile.getName()));
        serverConfiguration.load(ServerConfigFile.readConfigurationFile(configFile), encryptedPasswords);
        return serverConfiguration;
    }

    static Properties readConfigurationFile(File configFile) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ServerConfigFile.readSystemEnvironmentVariables(properties);
        return properties;
    }

    static Properties readSystemEnvironmentVariables(Properties properties) {
        System.getenv().entrySet().stream().filter(m -> ((String)m.getKey()).startsWith("XL_SPRING_CLOUD_")).forEach(p -> properties.setProperty(((String)p.getKey()).replaceAll("_", ".").toLowerCase(), (String)p.getValue()));
        return properties;
    }

    public void appendConfiguration(Map<String, String> additionalProperties) {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(this.configFile);
             BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.configFile, true));){
            Properties existingProperties = new Properties();
            existingProperties.load(input);
            additionalProperties.entrySet().stream().filter(e -> !existingProperties.containsKey(e.getKey())).forEach(e -> properties.setProperty((String)e.getKey(), (String)e.getValue()));
            if (!properties.isEmpty()) {
                properties.store(output, null);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void writeConfiguration(ServerConfiguration serverConfiguration) {
        Properties properties = new Properties();
        serverConfiguration.save(properties);
        PropertyUtil.storePropertiesFile(this.configFile, properties);
    }

    public void saveDirtyConfiguration(ServerConfiguration serverConfiguration) {
        if (serverConfiguration.isDirty()) {
            logger.info("Saving (dirty) configuration");
            this.writeConfiguration(serverConfiguration);
        }
    }

    public String toString() {
        return this.configFile.getAbsolutePath();
    }
}

