/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oslogin.common;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SshPublicKeyName
implements ResourceName {
    private static final PathTemplate USER_FINGERPRINT = PathTemplate.createWithoutUrlEncoding((String)"users/{user}/sshPublicKeys/{fingerprint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String user;
    private final String fingerprint;

    @Deprecated
    protected SshPublicKeyName() {
        this.user = null;
        this.fingerprint = null;
    }

    private SshPublicKeyName(Builder builder) {
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.fingerprint = (String)Preconditions.checkNotNull((Object)builder.getFingerprint());
    }

    public String getUser() {
        return this.user;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SshPublicKeyName of(String user, String fingerprint) {
        return SshPublicKeyName.newBuilder().setUser(user).setFingerprint(fingerprint).build();
    }

    public static String format(String user, String fingerprint) {
        return SshPublicKeyName.newBuilder().setUser(user).setFingerprint(fingerprint).build().toString();
    }

    public static SshPublicKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = USER_FINGERPRINT.validatedMatch(formattedString, "SshPublicKeyName.parse: formattedString not in valid format");
        return SshPublicKeyName.of((String)matchMap.get("user"), (String)matchMap.get("fingerprint"));
    }

    public static List<SshPublicKeyName> parseList(List<String> formattedStrings) {
        ArrayList<SshPublicKeyName> list = new ArrayList<SshPublicKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SshPublicKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SshPublicKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SshPublicKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return USER_FINGERPRINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SshPublicKeyName sshPublicKeyName = this;
            synchronized (sshPublicKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    if (this.fingerprint != null) {
                        fieldMapBuilder.put((Object)"fingerprint", (Object)this.fingerprint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return USER_FINGERPRINT.instantiate(new String[]{"user", this.user, "fingerprint", this.fingerprint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SshPublicKeyName that = (SshPublicKeyName)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.fingerprint, that.fingerprint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.user);
        h *= 1000003;
        return h ^= Objects.hashCode(this.fingerprint);
    }

    public static class Builder {
        private String user;
        private String fingerprint;

        protected Builder() {
        }

        public String getUser() {
            return this.user;
        }

        public String getFingerprint() {
            return this.fingerprint;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        private Builder(SshPublicKeyName sshPublicKeyName) {
            this.user = sshPublicKeyName.user;
            this.fingerprint = sshPublicKeyName.fingerprint;
        }

        public SshPublicKeyName build() {
            return new SshPublicKeyName(this);
        }
    }
}

