/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.t2bus;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.eventbus.EventBus;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import nl.javadude.t2bus.AnnotatedHandlerFinder;
import nl.javadude.t2bus.BusError;
import nl.javadude.t2bus.DeadEvent;
import nl.javadude.t2bus.EventHandler;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.HandlerFindingStrategy;
import nl.javadude.t2bus.event.strategy.LoggingEventHandlerStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class T2Bus {
    private final SetMultimap<Class<?>, EventHandler> handlersByType = Multimaps.newSetMultimap(new ConcurrentHashMap(), (Supplier)new Supplier<Set<EventHandler>>(){

        public Set<EventHandler> get() {
            return T2Bus.this.newHandlerSet();
        }
    });
    private final Logger logger;
    private final EventHandlerStrategy defaultEventHandler;
    private final HandlerFindingStrategy finder = new AnnotatedHandlerFinder();
    private final ThreadLocal<ConcurrentLinkedQueue<EventWithHandlers>> eventsToDispatch = new ThreadLocal<ConcurrentLinkedQueue<EventWithHandlers>>(){

        @Override
        protected ConcurrentLinkedQueue<EventWithHandlers> initialValue() {
            return new ConcurrentLinkedQueue<EventWithHandlers>();
        }
    };
    private final ThreadLocal<Boolean> isDispatching = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final ThreadLocal<EventHandlerStrategy> eventHandler = new ThreadLocal<EventHandlerStrategy>(){

        @Override
        protected EventHandlerStrategy initialValue() {
            return T2Bus.this.defaultEventHandler;
        }
    };
    private final LoadingCache<Class<?>, Set<Class<?>>> flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Set<Class<?>>>(){

        public Set<Class<?>> load(Class<?> concreteClass) throws Exception {
            return TypeToken.of(concreteClass).getTypes().rawTypes();
        }
    });

    public T2Bus() {
        this("default");
    }

    public T2Bus(String identifier) {
        this.logger = LoggerFactory.getLogger((String)(EventBus.class.getName() + "." + identifier));
        this.defaultEventHandler = new LoggingEventHandlerStrategy();
    }

    public void register(Object object) {
        this.handlersByType.putAll(this.finder.findAllHandlers(object));
    }

    public void unregister(Object object) {
        Multimap<Class<?>, EventHandler> methodsInListener = this.finder.findAllHandlers(object);
        for (Map.Entry entry : methodsInListener.asMap().entrySet()) {
            Set<EventHandler> currentHandlers = this.getHandlersForEventType((Class)entry.getKey());
            Collection eventMethodsInListener = (Collection)entry.getValue();
            if (currentHandlers == null || !currentHandlers.containsAll((Collection)entry.getValue())) {
                throw new IllegalArgumentException("missing event handler for an annotated method. Is " + object + " registered?");
            }
            currentHandlers.removeAll(eventMethodsInListener);
        }
    }

    public void post(Object event) {
        Set<Class<?>> dispatchTypes = this.flattenHierarchy(event.getClass());
        boolean dispatched = false;
        ArrayList vetoers = Lists.newArrayList();
        ArrayList handlers = Lists.newArrayList();
        for (Class<?> eventType : dispatchTypes) {
            Set<EventHandler> wrappers = this.getHandlersForEventType(eventType);
            if (wrappers == null || wrappers.isEmpty()) continue;
            dispatched = true;
            this.divvyUpWrappers(wrappers, vetoers, handlers);
        }
        if (dispatched) {
            this.enqueueEvent(event, vetoers, handlers);
        } else if (!(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
        this.dispatchQueuedEvents();
    }

    public void post(Object event, EventHandlerStrategy eventHandlerStrategy) {
        if (this.isDispatching.get().booleanValue()) {
            throw new BusError("Cannot set a new ExceptionHandler when in a dispatch loop. Event = [%s]", event);
        }
        this.eventHandler.set(eventHandlerStrategy);
        this.post(event);
        this.eventHandler.remove();
    }

    private void divvyUpWrappers(Set<EventHandler> wrappers, List<EventHandler> vetoers, List<EventHandler> handlers) {
        for (EventHandler wrapper : wrappers) {
            if (wrapper.isVetoer()) {
                vetoers.add(wrapper);
                continue;
            }
            handlers.add(wrapper);
        }
    }

    void enqueueEvent(Object event, List<EventHandler> vetoers, List<EventHandler> handlers) {
        this.eventsToDispatch.get().offer(new EventWithHandlers(event, vetoers, handlers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchQueuedEvents() {
        if (this.isDispatching.get().booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventWithHandlers eventWithHandler;
            while ((eventWithHandler = this.eventsToDispatch.get().poll()) != null) {
                this.dispatch(eventWithHandler);
            }
        }
        finally {
            this.isDispatching.set(false);
        }
    }

    void dispatch(EventWithHandlers eventWithHandler) {
        EventHandler vetoer;
        boolean canContinue = true;
        Object event = eventWithHandler.event;
        Iterator i$ = eventWithHandler.vetoers.iterator();
        while (i$.hasNext() && (canContinue = this.handle(event, vetoer = (EventHandler)i$.next()))) {
        }
        if (canContinue) {
            for (EventHandler handler : eventWithHandler.handlers) {
                this.handle(event, handler);
            }
        }
    }

    boolean handle(Object event, EventHandler wrapper) {
        return this.eventHandler.get().handle(event, wrapper);
    }

    Set<EventHandler> getHandlersForEventType(Class<?> type) {
        return this.handlersByType.get(type);
    }

    Set<EventHandler> newHandlerSet() {
        return new CopyOnWriteArraySet<EventHandler>();
    }

    Set<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        try {
            return (Set)this.flattenHierarchyCache.get(concreteClass);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    static class EventWithHandlers {
        final Object event;
        private final List<EventHandler> vetoers;
        private final List<EventHandler> handlers;

        public EventWithHandlers(Object event, List<EventHandler> vetoers, List<EventHandler> handlers) {
            this.event = event;
            this.vetoers = vetoers;
            this.handlers = handlers;
        }
    }
}

