/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm;

import com.hierynomus.ntlm.messages.WindowsVersion;
import java.security.SecureRandom;
import java.util.Random;

public class NtlmConfig {
    private WindowsVersion windowsVersion;
    private String workstationName;
    private boolean integrity;
    private boolean omitVersion;
    private byte[] machineID;

    public static NtlmConfig defaultConfig() {
        return NtlmConfig.builder(new SecureRandom()).build();
    }

    public static Builder builder(Random r) {
        return new Builder(r);
    }

    private NtlmConfig() {
    }

    private NtlmConfig(NtlmConfig other) {
        this.windowsVersion = other.windowsVersion;
        this.workstationName = other.workstationName;
        this.integrity = other.integrity;
        this.omitVersion = other.omitVersion;
        this.machineID = other.machineID;
    }

    public WindowsVersion getWindowsVersion() {
        return this.windowsVersion;
    }

    public String getWorkstationName() {
        return this.workstationName;
    }

    public boolean isIntegrityEnabled() {
        return this.integrity;
    }

    public boolean isOmitVersion() {
        return this.omitVersion;
    }

    public byte[] getMachineID() {
        return this.machineID;
    }

    static /* synthetic */ byte[] access$402(NtlmConfig x0, byte[] x1) {
        x0.machineID = x1;
        return x1;
    }

    public static class Builder {
        private NtlmConfig config = new NtlmConfig();

        public Builder(Random r) {
            this.config.windowsVersion = new WindowsVersion(WindowsVersion.ProductMajorVersion.WINDOWS_MAJOR_VERSION_6, WindowsVersion.ProductMinorVersion.WINDOWS_MINOR_VERSION_1, 7600, WindowsVersion.NtlmRevisionCurrent.NTLMSSP_REVISION_W2K3);
            this.config.integrity = true;
            this.config.omitVersion = false;
            NtlmConfig.access$402(this.config, new byte[32]);
            r.nextBytes(this.config.machineID);
        }

        public Builder withWindowsVersion(WindowsVersion windowsVersion) {
            this.config.windowsVersion = windowsVersion;
            return this;
        }

        public Builder withWorkstationName(String workstationName) {
            this.config.workstationName = workstationName;
            return this;
        }

        public Builder withIntegrity(boolean integrity) {
            this.config.integrity = integrity;
            return this;
        }

        public Builder withOmitVersion(boolean omitVersion) {
            this.config.omitVersion = omitVersion;
            return this;
        }

        public Builder withMachineID(byte[] machineID) {
            if (machineID == null) {
                throw new IllegalArgumentException("MachineID must not be null");
            }
            if (machineID.length != 32) {
                throw new IllegalArgumentException("MachineID must be 32 bytes");
            }
            NtlmConfig.access$402(this.config, machineID);
            return this;
        }

        public NtlmConfig build() {
            return new NtlmConfig(this.config);
        }
    }
}

