/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import org.springframework.cloud.config.server.environment.DocumentedConfigObservation;
import org.springframework.cloud.config.server.environment.ObservationEnvironmentRepositoryContext;
import org.springframework.util.StringUtils;

class ObservationEnvironmentRepositoryObservationConvention
implements ObservationConvention<ObservationEnvironmentRepositoryContext> {
    ObservationEnvironmentRepositoryObservationConvention() {
    }

    public KeyValues getLowCardinalityKeyValues(ObservationEnvironmentRepositoryContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.appendIfPresent(keyValues, DocumentedConfigObservation.LowCardinalityTags.ENVIRONMENT_CLASS, context.getEnvironmentRepositoryClass().getName());
        keyValues = this.appendIfPresent(keyValues, DocumentedConfigObservation.LowCardinalityTags.LABEL, context.getLabel());
        keyValues = this.appendIfPresent(keyValues, DocumentedConfigObservation.LowCardinalityTags.PROFILE, context.getProfile());
        return this.appendIfPresent(keyValues, DocumentedConfigObservation.LowCardinalityTags.APPLICATION, context.getApplication());
    }

    private KeyValues appendIfPresent(KeyValues keyValues, KeyName profile, String value) {
        if (StringUtils.hasText((String)value)) {
            keyValues = keyValues.and(new KeyValue[]{profile.withValue(value)});
        }
        return keyValues;
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ObservationEnvironmentRepositoryContext;
    }

    public String getName() {
        return "spring.cloud.config.environment.find";
    }

    public String getContextualName(ObservationEnvironmentRepositoryContext context) {
        return "env find";
    }
}

