/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.ws;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteStringBuilder;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class Utf8Encoder$
extends GraphStage<FlowShape<String, ByteString>> {
    public static final Utf8Encoder$ MODULE$ = new Utf8Encoder$();
    private static final int SurrogateHighMask = 55296;
    private static final int SurrogateLowMask = 56320;
    private static final long Utf8OneByteLimit;
    private static final long Utf8TwoByteLimit;
    private static final long Utf8ThreeByteLimit;
    private static final Inlet<String> stringIn;
    private static final Outlet<ByteString> byteStringOut;
    private static final FlowShape<String, ByteString> shape;
    private static final Attributes initialAttributes;

    static {
        int lowerNBitsSet_n = 7;
        Utf8OneByteLimit = (1L << lowerNBitsSet_n) - 1L;
        int lowerNBitsSet_n2 = 11;
        Utf8TwoByteLimit = (1L << lowerNBitsSet_n2) - 1L;
        int lowerNBitsSet_n3 = 16;
        Utf8ThreeByteLimit = (1L << lowerNBitsSet_n3) - 1L;
        stringIn = Inlet$.MODULE$.apply("Utf8Encoder.stringIn");
        byteStringOut = Outlet$.MODULE$.apply("Utf8Encoder.byteStringOut");
        shape = new FlowShape(MODULE$.stringIn(), MODULE$.byteStringOut());
        initialAttributes = Attributes$.MODULE$.name("utf8Encoder");
    }

    public int SurrogateHighMask() {
        return SurrogateHighMask;
    }

    public int SurrogateLowMask() {
        return SurrogateLowMask;
    }

    public long Utf8OneByteLimit() {
        return Utf8OneByteLimit;
    }

    public long Utf8TwoByteLimit() {
        return Utf8TwoByteLimit;
    }

    public long Utf8ThreeByteLimit() {
        return Utf8ThreeByteLimit;
    }

    public long lowerNBitsSet(int n) {
        return (1L << n) - 1L;
    }

    public Inlet<String> stringIn() {
        return stringIn;
    }

    public Outlet<ByteString> byteStringOut() {
        return byteStringOut;
    }

    public FlowShape<String, ByteString> shape() {
        return shape;
    }

    public Attributes initialAttributes() {
        return initialAttributes;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(){
            private int surrogateValue;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            private int surrogateValue() {
                return this.surrogateValue;
            }

            private void surrogateValue_$eq(int x$1) {
                this.surrogateValue = x$1;
            }

            private boolean inSurrogatePair() {
                return this.surrogateValue() != 0;
            }

            public void onPush() {
                ByteStringBuilder builder = new ByteStringBuilder();
                String input = (String)this.grab(Utf8Encoder$.MODULE$.stringIn());
                for (int offset = 0; offset < input.length(); ++offset) {
                    this.step$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), offset), builder);
                }
                if (builder.length() > 0) {
                    this.push(Utf8Encoder$.MODULE$.byteStringOut(), builder.result());
                    return;
                }
                this.pull(Utf8Encoder$.MODULE$.stringIn());
            }

            public void onUpstreamFinish() {
                if (this.inSurrogatePair()) {
                    this.failStage(new IllegalArgumentException("Truncated String input (ends in the middle of surrogate pair)"));
                    return;
                }
                this.completeStage();
            }

            public void onPull() {
                this.pull(Utf8Encoder$.MODULE$.stringIn());
            }

            private static final void b$1(int v, ByteStringBuilder builder$1) {
                builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)v)));
            }

            private final void step$1(int n, ByteStringBuilder builder$1) {
                if (!this.inSurrogatePair()) {
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8OneByteLimit()) {
                        builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)n)));
                        return;
                    }
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8TwoByteLimit()) {
                        int b$1_v = 0xC0 | (n & 0x7C0) >> 6;
                        builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)b$1_v)));
                        int b$1_v2 = 0x80 | n & 0x3F;
                        builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)b$1_v2)));
                        return;
                    }
                    if (n >= Utf8Encoder$.MODULE$.SurrogateHighMask() && n < Utf8Encoder$.MODULE$.SurrogateLowMask()) {
                        this.surrogateValue_$eq(65536 + ((n & 0x3FF) << 10));
                        return;
                    }
                    if (n >= Utf8Encoder$.MODULE$.SurrogateLowMask() && n < 57343) {
                        throw new IllegalArgumentException("Unexpected UTF-16 surrogate continuation");
                    }
                    if ((long)n <= Utf8Encoder$.MODULE$.Utf8ThreeByteLimit()) {
                        int b$1_v = 0xE0 | (n & 0xF000) >> 12;
                        builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)b$1_v)));
                        int b$1_v3 = 0x80 | (n & 0xFC0) >> 6;
                        builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)b$1_v3)));
                        int b$1_v4 = 0x80 | n & 0x3F;
                        builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)b$1_v4)));
                        return;
                    }
                    throw new IllegalStateException("Char cannot be >= 2^16");
                }
                if (n >= Utf8Encoder$.MODULE$.SurrogateLowMask() && n <= 57343) {
                    this.surrogateValue_$eq(this.surrogateValue() | n & 0x3FF);
                    int b$1_v = 0xF0 | (this.surrogateValue() & 0x1C0000) >> 18;
                    builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)b$1_v)));
                    int b$1_v5 = 0x80 | (this.surrogateValue() & 0x3F000) >> 12;
                    builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)b$1_v5)));
                    int b$1_v6 = 0x80 | (this.surrogateValue() & 0xFC0) >> 6;
                    builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)b$1_v6)));
                    int b$1_v7 = 0x80 | this.surrogateValue() & 0x3F;
                    builder$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)b$1_v7)));
                    this.surrogateValue_$eq(0);
                    return;
                }
                throw new IllegalArgumentException("Expected UTF-16 surrogate continuation");
            }
            {
                InHandler.$init$((InHandler)this);
                OutHandler.$init$((OutHandler)this);
                this.surrogateValue = 0;
                this.setHandlers(Utf8Encoder$.MODULE$.stringIn(), Utf8Encoder$.MODULE$.byteStringOut(), this);
            }
        };
    }

    public String toString() {
        return "Utf8Encoder";
    }

    private Utf8Encoder$() {
    }
}

