package ai.digital.config

import com.xebialabs.deployit.{ServerConfigFile, ServerConfiguration}
import com.xebialabs.deployit.util.{DeployitKeys, PasswordEncrypter}

import java.io.File

object ServerConfigurationHelper {

  val DEFAULT_CONFIGURATION_FILE = new File("conf", "deployit.conf")

  def init(): ServerConfiguration = {
    val passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey(null)
    PasswordEncrypter.init(passwordEncryptionKey)
    val config = new ServerConfigFile(DEFAULT_CONFIGURATION_FILE).loadConfig(false, false, true)
    ServerConfiguration.setInstance(config)
    config
  }

  def getAdminUser: String = "admin"

  def getAdminPassword: Option[String] =
    Option(ServerConfiguration.getInstance().getAdminPassword)
      .map(PasswordEncrypter.getInstance().ensureDecrypted)

  def getKeyStorePassword: Option[String] =
    Option(ServerConfiguration.getInstance().getKeyStorePassword)
      .map(PasswordEncrypter.getInstance().ensureDecrypted)
}
