package ai.digital.config

import com.xebialabs.deployit.ServerConfiguration

trait RetryConfigClientSystemValues {

  def applyConfigClientRetrySystemValues(serverConfiguration: ServerConfiguration): this.type = {
    System.setProperty("spring.cloud.config.retry.initialInterval", serverConfiguration.getSpringCloudRetryInitialInterval.toString)
    System.setProperty("spring.cloud.config.retry.maxAttempts", serverConfiguration.getSpringCloudRetryMaxAttempts.toString)
    System.setProperty("spring.cloud.config.retry.maxInterval", serverConfiguration.getSpringCloudRetryMaxInterval.toString)
    System.setProperty("spring.cloud.config.retry.multiplier", serverConfiguration.getSpringCloudRetryMultiplier.toString)
    this
  }
}
