package ai.digital.config

import com.xebialabs.deployit.spring.profile.DynamicActiveProfile
import com.xebialabs.deployit.{ServerConfiguration, ServerLaunchOptions}

class CentralConfigurationActiveProfiles extends DynamicActiveProfile {
  override val profileNames: Array[String] =
    Array(ConfigServerProfiles.CONFIG_SERVER,
      ConfigServerProfiles.FILE_CONFIG_SERVER)

  override def configPropertyCallback(serverConfiguration: ServerConfiguration): Boolean =
    serverConfiguration.getSpringCloudExternalConfig

  override def launchOptionsCallback(launchOptions: ServerLaunchOptions): Boolean =
    Option(launchOptions).exists(_.isExternalConfig)
}
