package ai.digital.config.server

import ai.digital.config.ConfigFileMapping
import org.springframework.stereotype.Component

trait ConfigFileMappingResolver {
  def propertyKeyToConfigFile(property: String, configFileMapping: ConfigFileMapping): Iterable[String]
}

@Component
class ApplicationConfigFileMappingResolver extends ConfigFileMappingResolver {

  override def propertyKeyToConfigFile(property: String, configFileMapping: ConfigFileMapping): Iterable[String] = {
    configFileMapping.propertyKeyToConfigFileMapping
      .filter { case (propertyPrefix, _) => property.startsWith(propertyPrefix) }
      .values ++ configFileMapping.defaultConfigFile
  }
}
